/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.ConnectorException;

public class UploadNewDocuments
extends AbstractCMISConnector {
    public static final String DOCUMENT_IDS_OUTPUT = "document_ids";
    public static final String DOCUMENTS = "documents";
    public static final String FOLDER_PATH = "folder_path";
    private ProcessAPI processApi;
    private Object rawDocuments;
    private String folder_path;
    private List<String> remoteDocumentIds;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.rawDocuments = parameters.get(DOCUMENTS);
        this.folder_path = (String)parameters.get(FOLDER_PATH);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        this.processApi = this.getAPIAccessor().getProcessAPI();
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS UploadNewDocuments connector is not connected properly.");
        }
        List<Document> documents = this.getDocumentsFromInputParameter();
        this.remoteDocumentIds = new ArrayList<String>();
        for (Document document : documents) {
            byte[] documentContent = this.getDocumentContent(document);
            String remoteDocumentId = cmisClient.uploadNewDocument(this.folder_path, document.getContentFileName(), documentContent, document.getContentMimeType()).getId();
            this.remoteDocumentIds.add(remoteDocumentId);
        }
        this.setOutputParameter(DOCUMENT_IDS_OUTPUT, this.remoteDocumentIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Document> getDocumentsFromInputParameter() throws ConnectorException {
        List<Object> documents = new ArrayList<Document>();
        if (this.rawDocuments instanceof String) {
            String documentName = (String)this.rawDocuments;
            return this.getDocumentsFromName(documentName);
        }
        if (!(this.rawDocuments instanceof Document)) {
            if (!(this.rawDocuments instanceof List)) throw new ConnectorException("Unsupported type " + this.rawDocuments.getClass().getName() + " for parameter " + DOCUMENTS);
            List rawDocList = (List)this.rawDocuments;
            if (rawDocList.size() <= 0) return documents;
            if (rawDocList.get(0) instanceof String) {
                Iterator iterator = rawDocList.iterator();
                while (iterator.hasNext()) {
                    String documentName = (String)iterator.next();
                    documents.addAll(this.getDocumentsFromName(documentName));
                }
                return documents;
            }
            if (!(rawDocList.get(0) instanceof Document)) throw new ConnectorException("Unsupported List<?> type " + rawDocList.get(0).getClass().getName() + " for parameter " + DOCUMENTS);
            return rawDocList;
        }
        documents.add((Document)this.rawDocuments);
        return documents;
    }

    protected List<Document> getDocumentsFromName(String documentName) throws ConnectorException {
        List<Document> documents = this.getDocumentListFromName(documentName);
        if (documents != null) {
            return documents;
        }
        Document document = this.getSingleDocumentFromName(documentName);
        if (document != null) {
            documents = new ArrayList<Document>();
            documents.add(document);
            return documents;
        }
        throw new ConnectorException("Failed to retrieve " + documentName + " either as a single or multiple document");
    }

    protected byte[] getDocumentContent(Document doc) throws ConnectorException {
        try {
            return this.processApi.getDocumentContent(doc.getContentStorageId());
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException("Failed to retrieve document content for " + doc.getName(), (Throwable)e);
        }
    }

    protected Document getSingleDocumentFromName(String documentName) {
        try {
            return this.processApi.getLastDocument(this.getExecutionContext().getProcessInstanceId(), documentName);
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    protected List<Document> getDocumentListFromName(String documentListName) {
        try {
            return this.processApi.getDocumentList(this.getExecutionContext().getProcessInstanceId(), documentListName, 0, Integer.MAX_VALUE);
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }
}

