/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.cmis;

import java.util.Map;
import org.bonitasoft.connectors.cmis.AbstractCMISConnector;
import org.bonitasoft.connectors.cmis.cmisclient.AbstractCmisClient;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.ConnectorException;

public class UploadNewVersionOfDocument
extends AbstractCMISConnector {
    public static final String DOCUMENT_ID_OUTPUT = "document_id";
    public static final String DOCUMENT = "document";
    public static final String REMOTE_DOCUMENT = "remote_document";
    private ProcessAPI processApi;
    private String document;
    private String remote_document;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        super.setInputParameters(parameters);
        this.document = (String)parameters.get(DOCUMENT);
        this.remote_document = (String)parameters.get(REMOTE_DOCUMENT);
    }

    protected void executeBusinessLogic() throws ConnectorException {
        AbstractCmisClient cmisClient = this.getClient();
        if (cmisClient == null) {
            throw new ConnectorException("CMIS UploadNewVersionOfDocument connector is not connected properly.");
        }
        if (!cmisClient.checkIfObjectExists(this.remote_document).booleanValue()) {
            throw new ConnectorException("Remote document " + this.remote_document + " doesn't exists !");
        }
        this.processApi = this.getAPIAccessor().getProcessAPI();
        Document doc = this.getDocument(this.document);
        byte[] documentContent = this.getDocumentContent(doc);
        String documentId = cmisClient.uploadNewVersionOfDocument(this.remote_document, documentContent, doc.getContentMimeType()).getId();
        this.setOutputParameter(DOCUMENT_ID_OUTPUT, documentId);
    }

    private byte[] getDocumentContent(Document doc) throws ConnectorException {
        byte[] documentContent;
        try {
            documentContent = this.processApi.getDocumentContent(doc.getContentStorageId());
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException("Failed to retrieve document content for " + doc.getName(), (Throwable)e);
        }
        return documentContent;
    }

    private Document getDocument(String document) throws ConnectorException {
        Document doc;
        try {
            doc = this.processApi.getLastDocument(this.getExecutionContext().getProcessInstanceId(), document);
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException("Failed to retrieve document " + document, (Throwable)e);
        }
        return doc;
    }
}

