/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.converter;

import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.core.XDocReportException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.connectors.document.converter.FilenameUtil;
import org.bonitasoft.connectors.document.converter.InputParametersValidator;
import org.bonitasoft.connectors.document.converter.MimeTypeUtil;
import org.bonitasoft.connectors.document.converter.core.DocumentConverter;
import org.bonitasoft.connectors.document.converter.core.DocumentConverterFactory;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentConverterConnector
extends AbstractConnector {
    static final String SOURCE_DOCUMENT = "sourceDocument";
    static final String ENCODING = "encoding";
    static final String OUTPUT_FILE_NAME = "outputFileName";
    static final String OUTPUT_DOCUMENT_VALUE = "outputDocumentValue";
    private final DocumentConverterFactory documentConverterFactory;

    public DocumentConverterConnector() {
        this.documentConverterFactory = new DocumentConverterFactory();
    }

    DocumentConverterConnector(DocumentConverterFactory documentConverterFactory) {
        this.documentConverterFactory = documentConverterFactory;
    }

    protected void executeBusinessLogic() throws ConnectorException {
        byte[] content;
        Document document;
        Logger logger = LoggerFactory.getLogger(DocumentConverterConnector.class);
        ProcessAPI processAPI = this.getAPIAccessor().getProcessAPI();
        try {
            document = this.loadDocument(processAPI);
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException((Throwable)e);
        }
        try {
            content = processAPI.getDocumentContent(document.getContentStorageId());
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException((Throwable)e);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
            DocumentConverter converter = this.documentConverterFactory.newConverter(is, ConverterTypeTo.PDF.name(), this.getEncoding());
            long time = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Converting %s to %s...", document.getContentFileName(), ConverterTypeTo.PDF.name()));
            }
            byte[] newContent = converter.convert();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Conversion done in %s ms", System.currentTimeMillis() - time));
            }
            this.setOutputParameter(OUTPUT_DOCUMENT_VALUE, this.createDocumentValue(newContent, MimeTypeUtil.forFormat(ConverterTypeTo.PDF.name()), FilenameUtil.toOutputFileName((String)this.getInputParameter(OUTPUT_FILE_NAME), document.getContentFileName(), ConverterTypeTo.PDF.name())));
        }
        catch (XDocReportException | IOException e) {
            throw new ConnectorException(e);
        }
    }

    private Document loadDocument(ProcessAPI processAPI) throws DocumentNotFoundException {
        long processInstanceId = this.getExecutionContext().getProcessInstanceId();
        return processAPI.getLastDocument(processInstanceId, this.getSourceDocumentReference());
    }

    private String getSourceDocumentReference() {
        return (String)this.getInputParameter(SOURCE_DOCUMENT);
    }

    private String getEncoding() {
        return (String)this.getInputParameter(ENCODING);
    }

    private DocumentValue createDocumentValue(byte[] content, String mimeType, String outputFileName) {
        return new DocumentValue(content, mimeType, outputFileName);
    }

    public void validateInputParameters() throws ConnectorValidationException {
        new InputParametersValidator(this.copyInputParameters()).validateInputParameters();
    }

    private Map<String, Object> copyInputParameters() {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put(OUTPUT_FILE_NAME, this.getInputParameter(OUTPUT_FILE_NAME));
        inputParameters.put(SOURCE_DOCUMENT, this.getInputParameter(SOURCE_DOCUMENT));
        inputParameters.put(ENCODING, this.getInputParameter(ENCODING));
        return inputParameters;
    }
}

