/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.converter.core;

import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.ConverterTypeVia;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bonitasoft.connectors.document.converter.core.DocumentConverter;

public abstract class AbstractDocumentConverter
implements DocumentConverter {
    private final InputStream inputStream;
    private final String encoding;

    protected AbstractDocumentConverter(InputStream inputStream, String encoding) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Source document InputStream cannot be null");
        }
        this.inputStream = inputStream;
        this.encoding = encoding;
    }

    @Override
    public byte[] convert() throws IOException, XDocReportException {
        XDocArchive documentArchive = XDocArchive.readZip((InputStream)this.inputStream);
        IXDocReport report = XDocReportRegistry.getRegistry().createReport(documentArchive);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Options options = Options.getTo((ConverterTypeTo)this.getOutputType()).via(this.converterImplementation(report)).subOptions((Object)this.getPDFOptions());
            IConverter converter = report.getConverter(options);
            converter.convert(XDocArchive.getInputStream((XDocArchive)documentArchive), (OutputStream)out, options);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    protected PdfOptions getPDFOptions() {
        PdfOptions options = PdfOptions.create();
        if (this.encoding != null && !this.encoding.isEmpty()) {
            options = options.fontEncoding(this.encoding);
        }
        return options;
    }

    protected abstract ConverterTypeTo getOutputType();

    private ConverterTypeVia converterImplementation(IXDocReport report) {
        return Objects.equals(report.getKind(), DocumentKind.ODT.name()) ? ConverterTypeVia.ODFDOM : this.converterTypeForDocx();
    }

    protected abstract ConverterTypeVia converterTypeForDocx();
}

