/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.document.templating;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.apache.commons.text.translate.LookupTranslator;
import org.bonitasoft.connectors.document.templating.ZipUtil;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class DocumentTemplating
extends AbstractConnector {
    private static final String TEMP_DOC = "connectorDocumentTemplatingTempDocument";
    private static final String TEMP_DIR = "connectorDocumentTemplatingTempDirectory";
    private static final String ODT_EXT = ".odt";
    private static final String DOCX_EXT = ".docx";
    public static final String INPUT_DOCUMENT_INPUT = "documentInput";
    public static final String INPUT_REPLACEMENTS = "replacements";
    public static final String INPUT_RESULTING_DOC_FILENAME = "outputFileName";
    public static final String OUTPUT_DOCUMENT = "document";
    private Logger logger = Logger.getLogger(DocumentTemplating.class.getName());
    private LookupTranslator lookupTranslator;

    public DocumentTemplating() {
        HashMap<String, String> escapeXml10Map = new HashMap<String, String>();
        escapeXml10Map.put("\u0000", "");
        escapeXml10Map.put("\u0001", "");
        escapeXml10Map.put("\u0002", "");
        escapeXml10Map.put("\u0003", "");
        escapeXml10Map.put("\u0004", "");
        escapeXml10Map.put("\u0005", "");
        escapeXml10Map.put("\u0006", "");
        escapeXml10Map.put("\u0007", "");
        escapeXml10Map.put("\b", "");
        escapeXml10Map.put("\u000b", "");
        escapeXml10Map.put("\f", "");
        escapeXml10Map.put("\u000e", "");
        escapeXml10Map.put("\u000f", "");
        escapeXml10Map.put("\u0010", "");
        escapeXml10Map.put("\u0011", "");
        escapeXml10Map.put("\u0012", "");
        escapeXml10Map.put("\u0013", "");
        escapeXml10Map.put("\u0014", "");
        escapeXml10Map.put("\u0015", "");
        escapeXml10Map.put("\u0016", "");
        escapeXml10Map.put("\u0017", "");
        escapeXml10Map.put("\u0018", "");
        escapeXml10Map.put("\u0019", "");
        escapeXml10Map.put("\u001a", "");
        escapeXml10Map.put("\u001b", "");
        escapeXml10Map.put("\u001c", "");
        escapeXml10Map.put("\u001d", "");
        escapeXml10Map.put("\u001e", "");
        escapeXml10Map.put("\u001f", "");
        escapeXml10Map.put("\ufffe", "");
        escapeXml10Map.put("\uffff", "");
        this.lookupTranslator = new LookupTranslator(Collections.unmodifiableMap(escapeXml10Map));
    }

    protected void executeBusinessLogic() throws ConnectorException {
        try {
            Document document = this.retrieveDocument();
            String outputFilename = (String)this.getInputParameter(INPUT_RESULTING_DOC_FILENAME);
            boolean isOdt = document.getContentFileName().endsWith(ODT_EXT);
            byte[] content = this.getAPIAccessor().getProcessAPI().getDocumentContent(document.getContentStorageId());
            List replacements = (List)this.getInputParameter(INPUT_REPLACEMENTS);
            byte[] finalDocument = this.applyReplacements(content, replacements, isOdt);
            this.setOutputParameter(OUTPUT_DOCUMENT, this.createDocumentValue(document, outputFilename, finalDocument));
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected byte[] applyReplacements(byte[] content, List<List<Object>> inputParameter, boolean isOdt) throws ConnectorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File sanitizeOutput(ByteArrayOutputStream byteArrayOutputStream, boolean isOdt) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
            File file;
            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));){
                Path targetDir = ZipUtil.unzip(TEMP_DIR, zis);
                Path documentPath = this.retrieveDocumentPath(isOdt, targetDir);
                if (this.isCorrupted(documentPath) && this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(String.format("Invalid XML characters have been detected in the document `%s`, they will be removed.", this.getInputParameter(INPUT_DOCUMENT_INPUT)));
                    this.sanitizeFile(documentPath);
                }
                Path tempResFile = Files.createTempFile(TEMP_DOC, isOdt ? ODT_EXT : DOCX_EXT, new FileAttribute[0]);
                ZipUtil.zip(targetDir, tempResFile);
                file = tempResFile.toFile();
            }
            return file;
        }
    }

    protected boolean isCorrupted(Path filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));){
            CharBuffer buffer = CharBuffer.allocate(4096);
            while (reader.read(buffer) != -1) {
                ((Buffer)buffer).flip();
                String currentString = ((Object)buffer).toString();
                if (!Objects.equals(currentString, this.lookupTranslator.translate((CharSequence)currentString))) {
                    boolean bl = true;
                    return bl;
                }
                ((Buffer)buffer).clear();
            }
        }
        return false;
    }

    private Path retrieveDocumentPath(boolean isOdt, Path targetDir) {
        return isOdt ? targetDir.resolve("content.xml") : targetDir.resolve("word").resolve("document.xml");
    }

    private void sanitizeFile(Path filePathToSanitize) throws IOException {
        File fileToSanitize = filePathToSanitize.toFile();
        Path tempFile = Files.createTempFile(fileToSanitize.getName(), null, new FileAttribute[0]);
        Files.copy(filePathToSanitize, tempFile, StandardCopyOption.REPLACE_EXISTING);
        try (BufferedReader reader = new BufferedReader(new FileReader(tempFile.toFile()));
             FileWriter writer = new FileWriter(fileToSanitize);){
            CharBuffer buffer = CharBuffer.allocate(4096);
            while (reader.read(buffer) != -1) {
                ((Buffer)buffer).flip();
                this.lookupTranslator.translate((CharSequence)((Object)buffer).toString(), (Writer)writer);
                ((Buffer)buffer).clear();
            }
        }
    }

    private DocumentValue createDocumentValue(Document document, String outputFilename, byte[] content) {
        return new DocumentValue(content, document.getContentMimeType(), outputFilename != null ? outputFilename : document.getContentFileName());
    }

    public void validateInputParameters() throws ConnectorValidationException {
        try {
            Document document = this.retrieveDocument();
            if (!document.getContentFileName().endsWith(DOCX_EXT) && !document.getContentFileName().endsWith(ODT_EXT)) {
                throw new ConnectorValidationException("The template must be a .docx or a .odt document, other formats are not supported.");
            }
        }
        catch (DocumentNotFoundException e) {
            throw new ConnectorValidationException(e.getMessage());
        }
    }

    private Document retrieveDocument() throws DocumentNotFoundException {
        ProcessAPI processAPI = this.getAPIAccessor().getProcessAPI();
        long processInstanceId = this.getExecutionContext().getProcessInstanceId();
        return processAPI.getLastDocument(processInstanceId, (String)this.getInputParameter(INPUT_DOCUMENT_INPUT));
    }
}

