/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.email;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.bonitasoft.connectors.email.SMTPAuthenticator;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;

public class EmailConnector
extends AbstractConnector {
    public static final String ATTACHMENTS = "attachments";
    public static final String HEADERS = "headers";
    public static final String CHARSET = "charset";
    public static final String MESSAGE = "message";
    public static final String HTML = "html";
    public static final String SUBJECT = "subject";
    public static final String BCC = "bcc";
    public static final String CC = "cc";
    public static final String TO = "to";
    public static final String REPLY_TO = "replyTo";
    public static final String FROM = "from";
    public static final String RETURN_PATH = "returnPath";
    public static final String PASSWORD = "password";
    public static final String USER_NAME = "userName";
    public static final String STARTTLS_SUPPORT = "starttlsSupport";
    public static final String SSL_SUPPORT = "sslSupport";
    public static final String SMTP_PORT = "smtpPort";
    public static final String SMTP_HOST = "smtpHost";
    public static final String TRUST_CERTIFICATE = "trustCertificate";
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void validateInputParameters() throws ConnectorValidationException {
        this.logInputParameters();
        ArrayList<String> errors = new ArrayList<String>(1);
        Integer smtpPort = (Integer)this.getInputParameter(SMTP_PORT);
        if (smtpPort == null) {
            errors.add("smtpPort cannot be null!");
        } else if (smtpPort < 0) {
            errors.add("smtpPort cannot be less than 0!");
        } else if (smtpPort > 65535) {
            errors.add("smtpPort cannot be greater than 65535!");
        }
        String smtpHost = (String)this.getInputParameter(SMTP_HOST);
        if (smtpHost == null) {
            errors.add("smtpHost cannot be null!");
        }
        String from = (String)this.getInputParameter(FROM);
        this.checkInputParameter(from, errors);
        String returnPath = (String)this.getInputParameter(RETURN_PATH);
        this.checkInputParameter(returnPath, errors);
        String to = (String)this.getInputParameter(TO);
        this.checkInputParameter(to, errors);
        String replyTo = (String)this.getInputParameter(REPLY_TO);
        this.checkInputParameter(replyTo, errors);
        String cc = (String)this.getInputParameter(CC);
        this.checkInputParameter(cc, errors);
        String bcc = (String)this.getInputParameter(BCC);
        this.checkInputParameter(bcc, errors);
        if (to == null && cc == null && bcc == null) {
            errors.add("No recipient address(es) is set (either in 'to', 'cc' or 'bcc'");
        }
        if (!errors.isEmpty()) {
            throw new ConnectorValidationException((Connector)this, errors);
        }
    }

    private void logInputParameters() {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logInputParameter(CHARSET);
        this.logInputParameter(MESSAGE);
        this.logInputParameter(HTML);
        this.logInputParameter(SUBJECT);
        this.logInputParameter(BCC);
        this.logInputParameter(CC);
        this.logInputParameter(TO);
        this.logInputParameter(FROM);
        this.logInputParameter(RETURN_PATH);
        this.logInputParameter(USER_NAME);
        this.logInputParameter(STARTTLS_SUPPORT);
        this.logInputParameter(SSL_SUPPORT);
        this.logInputParameter(TRUST_CERTIFICATE);
        this.logInputParameter(SMTP_PORT);
        this.logInputParameter(SMTP_HOST);
        this.logInputParameter(REPLY_TO);
        this.logger.info("password ******");
        List attachments = (List)this.getInputParameter(ATTACHMENTS);
        if (attachments == null) {
            this.logger.info("Attachments null");
        } else {
            for (Object attachment : attachments) {
                this.logger.info(() -> "Attachment " + attachment);
            }
        }
        Map<String, String> headers = this.getHeaders();
        if (headers.isEmpty()) {
            this.logger.info("Headers null");
        } else {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.logger.info("Header " + header.getKey() + " " + header.getValue());
            }
        }
        this.logInputParameter(HEADERS);
    }

    private void logInputParameter(String parameterName) {
        this.logger.info(() -> parameterName + " " + this.getInputParameter(parameterName));
    }

    private void checkInputParameter(String parameter, List<String> errors) {
        if (parameter != null && !parameter.isEmpty() && !this.checkAddresses(parameter)) {
            errors.add(parameter + " address in invalid");
        }
    }

    private boolean checkAddresses(String addresses) {
        try {
            InternetAddress.parse((String)addresses);
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    Session getSession() {
        Session session;
        boolean useSSL;
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.getInputParameter(SMTP_HOST));
        String smtpPort = String.valueOf(this.getInputParameter(SMTP_PORT));
        properties.put("mail.smtp.port", smtpPort);
        String returnPath = (String)this.getInputParameter(RETURN_PATH);
        if (returnPath == null || returnPath.isEmpty()) {
            returnPath = (String)this.getInputParameter(FROM);
        }
        if (returnPath != null && !returnPath.isEmpty()) {
            properties.put("mail.smtp.from", returnPath);
        }
        Boolean startTlsParameter = (Boolean)this.getInputParameter(STARTTLS_SUPPORT, Boolean.valueOf(false));
        Boolean sslParameter = (Boolean)this.getInputParameter(SSL_SUPPORT, Boolean.valueOf(true));
        boolean useStarttls = Boolean.TRUE.equals(startTlsParameter);
        if (useStarttls) {
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.smtp.starttls.required", "true");
        }
        if ((useSSL = Boolean.TRUE.equals(sslParameter)) && Boolean.FALSE.equals(startTlsParameter)) {
            properties.put("mail.smtp.ssl.enable", "true");
        }
        if (useSSL || useStarttls) {
            if (((Boolean)this.getInputParameter(TRUST_CERTIFICATE, Boolean.valueOf(false))).booleanValue()) {
                properties.put("mail.smtp.ssl.trust", "*");
            } else {
                properties.put("mail.smtp.ssl.checkserveridentity", "true");
            }
        }
        String username = (String)this.getInputParameter(USER_NAME);
        String password = (String)this.getInputParameter(PASSWORD);
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            properties.put("mail.smtp.auth", "true");
            SMTPAuthenticator authenticator = new SMTPAuthenticator(username, password);
            session = Session.getInstance((Properties)properties, (Authenticator)authenticator);
        } else {
            session = Session.getInstance((Properties)properties, null);
        }
        return session;
    }

    private Map<String, String> getHeaders() {
        List headersList = (List)this.getInputParameter(HEADERS);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headersList != null) {
            for (List rows : headersList) {
                if (rows.size() != 2) continue;
                Object keyContent = rows.get(0);
                Object valueContent = rows.get(1);
                if (keyContent == null || valueContent == null) continue;
                String key = keyContent.toString();
                String value = valueContent.toString();
                headers.put(key, value);
            }
        }
        return headers;
    }

    private MimeMessage getEmail(Session emailSession) throws ConnectorException {
        MimeMessage mimeMessage = new MimeMessage(emailSession);
        try {
            this.setMessageAddresses(mimeMessage);
            this.setMessageContent(mimeMessage);
            mimeMessage.setSentDate(new Date());
        }
        catch (MessagingException me) {
            throw new ConnectorException(me.getMessage(), me.getCause());
        }
        return mimeMessage;
    }

    private void setMessageContent(MimeMessage mimeMessage) throws MessagingException, ConnectorException {
        String subject = (String)this.getInputParameter(SUBJECT);
        String charset = (String)this.getInputParameter(CHARSET, (Serializable)((Object)"UTF-8"));
        String message = (String)this.getInputParameter(MESSAGE, (Serializable)((Object)""));
        List attachments = (List)this.getInputParameter(ATTACHMENTS);
        boolean html = (Boolean)this.getInputParameter(HTML, Boolean.valueOf(true));
        mimeMessage.setSubject(subject, charset);
        for (Map.Entry<String, String> h : this.getHeaders().entrySet()) {
            if (h.getKey() == null || h.getValue() == null || h.getKey().equals("Content-ID")) continue;
            mimeMessage.setHeader(h.getKey(), h.getValue());
        }
        if (attachments != null) {
            Multipart multipart = this.getMultipart(html, message, charset, attachments);
            mimeMessage.setContent(multipart);
        } else if (html) {
            mimeMessage.setText(message, charset, HTML);
        } else {
            mimeMessage.setText(message, charset);
        }
    }

    private void setMessageAddresses(MimeMessage mimeMessage) throws MessagingException {
        String from = (String)this.getInputParameter(FROM);
        String to = (String)this.getInputParameter(TO);
        String cc = (String)this.getInputParameter(CC);
        String bcc = (String)this.getInputParameter(BCC);
        String replyTo = (String)this.getInputParameter(REPLY_TO);
        if (from != null && !from.isEmpty()) {
            mimeMessage.setFrom((Address)new InternetAddress(from));
        } else {
            mimeMessage.setFrom();
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
        if (cc != null && !cc.isEmpty()) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
        }
        if (bcc != null && !bcc.isEmpty()) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
        }
        if (replyTo != null && !replyTo.isEmpty()) {
            mimeMessage.setReplyTo((Address[])InternetAddress.parse((String)replyTo));
        }
    }

    private Multipart getMultipart(boolean html, String message, String charset, List<Object> attachments) throws ConnectorException {
        try {
            StringBuilder messageBody = new StringBuilder(message);
            ProcessAPI processAPI = this.getAPIAccessor().getProcessAPI();
            MimeMultipart body = new MimeMultipart("mixed");
            ArrayList<MimeBodyPart> bodyParts = new ArrayList<MimeBodyPart>();
            if (attachments != null) {
                for (Object attachment : attachments) {
                    this.handleAttachment(html, messageBody, processAPI, bodyParts, attachment);
                }
            }
            MimeBodyPart bodyPart = new MimeBodyPart();
            if (html) {
                bodyPart.setText(messageBody.toString(), charset, HTML);
            } else {
                bodyPart.setText(messageBody.toString(), charset);
            }
            body.addBodyPart((BodyPart)bodyPart);
            for (MimeBodyPart part : bodyParts) {
                body.addBodyPart((BodyPart)part);
            }
            return body;
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectorException("unable to retrieve attachments for the email", (Throwable)e);
        }
    }

    private void handleAttachment(boolean html, StringBuilder messageBody, ProcessAPI processAPI, List<MimeBodyPart> bodyParts, Object attachment) throws ConnectorException, DocumentNotFoundException, MessagingException, UnsupportedEncodingException {
        if (attachment instanceof List) {
            for (Object subAttachment : (List)attachment) {
                this.handleAttachment(html, messageBody, processAPI, bodyParts, subAttachment);
            }
            return;
        }
        Document document = this.getDocument(attachment, processAPI);
        if (document == null) {
            throw new ConnectorException("Document " + attachment + " does not exist");
        }
        if (document.hasContent()) {
            this.addBodyPart(processAPI, bodyParts, document);
        } else if (document.getUrl() != null) {
            if (html) {
                messageBody.append("<br>");
            } else {
                messageBody.append("\n ");
            }
            messageBody.append(document.getName()).append(" : ").append(document.getUrl());
        }
    }

    private void addBodyPart(ProcessAPI processAPI, List<MimeBodyPart> bodyParts, Document document) throws DocumentNotFoundException, MessagingException, UnsupportedEncodingException {
        String fileName = document.getContentFileName();
        byte[] docContent = processAPI.getDocumentContent(document.getContentStorageId());
        if (docContent != null) {
            String mimeType = document.getContentMimeType();
            MimeBodyPart bodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(docContent, mimeType);
            DataHandler dataHandler = new DataHandler((DataSource)source);
            bodyPart.setDataHandler(dataHandler);
            bodyPart.setFileName(MimeUtility.encodeText((String)fileName));
            bodyParts.add(bodyPart);
        }
    }

    private Document getDocument(Object attachment, ProcessAPI processAPI) throws ConnectorException, DocumentNotFoundException {
        if (attachment instanceof String && !((String)attachment).trim().isEmpty()) {
            String docName = (String)attachment;
            long processInstanceId = this.getExecutionContext().getProcessInstanceId();
            return processAPI.getLastDocument(processInstanceId, docName);
        }
        if (attachment instanceof Document) {
            return (Document)attachment;
        }
        throw new ConnectorException("Attachments must be document names or org.bonitasoft.engine.bpm.document.Document");
    }

    protected void executeBusinessLogic() throws ConnectorException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Session session = this.getSession();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            MimeMessage email = this.getEmail(session);
            Transport.send((Message)email);
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

