/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.connectors.google.calendar.common.BuildEventConnector;
import org.bonitasoft.engine.connector.ConnectorException;

public class CreateEventConnector
extends BuildEventConnector {
    @Override
    public List<String> checkParameters() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getAllDay() == null) {
            errors.add("All Day must be set.");
        }
        if (this.getStartDate() == null || this.getStartDate().isEmpty()) {
            errors.add("Start Date must be set.");
        }
        errors.addAll(this.checkStartDate());
        if (this.getEndDate() == null || this.getEndDate().isEmpty()) {
            errors.add("End Date must be set.");
        }
        errors.addAll(this.checkEndDate());
        return errors;
    }

    @Override
    protected void doJobWithCalendarEvents(Calendar.Events events) throws ConnectorException {
        Event eventToInsert = new Event();
        try {
            this.buildEvent(eventToInsert);
            Calendar.Events.Insert insert = events.insert(this.getCalendarId(), eventToInsert);
            this.setCommonInputs((CalendarRequest<Event>)insert);
            this.setSpecificInputs(insert);
            Event insertedEvent = (Event)insert.execute();
            this.setOutputParameters(insertedEvent);
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private void setSpecificInputs(Calendar.Events.Insert insert) {
        if (this.getMaxAttendees() != null) {
            insert.setMaxAttendees(this.getMaxAttendees());
        }
        if (this.getSendNotifications() != null) {
            insert.setSendNotifications(this.getSendNotifications());
        }
    }
}

