/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.bonitasoft.connectors.google.calendar.common.CalendarConnector;
import org.bonitasoft.engine.connector.ConnectorException;

public class GetEventConnector
extends CalendarConnector {
    private static final List<String> AVAILABLE_TZ_IDS = Arrays.asList(TimeZone.getAvailableIDs());
    public static final String INPUT_TIME_ZONE = "timeZone";

    @Override
    protected List<String> checkParameters() {
        ArrayList<String> errors = new ArrayList<String>();
        this.ensureIdInputIsSpecified(errors);
        if (this.getTimeZone() != null && !AVAILABLE_TZ_IDS.contains(this.getTimeZone())) {
            errors.add("Specified Timezone is not supported. It is now: " + this.getTimeZone() + " and should be one of: " + AVAILABLE_TZ_IDS.toString());
        }
        return errors;
    }

    @Override
    protected void doJobWithCalendarEvents(Calendar.Events events) throws ConnectorException {
        try {
            Calendar.Events.Get get = events.get(this.getCalendarId(), this.getId());
            this.setCommonInputs((CalendarRequest<Event>)get);
            this.setSpecificOptionalInputs(get);
            this.setOutputParameters((Event)get.execute());
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private void setSpecificOptionalInputs(Calendar.Events.Get get) {
        if (this.getMaxAttendees() != null) {
            get.setMaxAttendees(this.getMaxAttendees());
        }
        if (this.getTimeZone() != null) {
            get.setTimeZone(this.getTimeZone());
        }
    }

    private String getTimeZone() {
        return (String)this.getInputParameter(INPUT_TIME_ZONE);
    }
}

