/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.google.calendar;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.Event;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.connectors.google.calendar.common.CalendarConnector;
import org.bonitasoft.engine.connector.ConnectorException;

public class MoveEventConnector
extends CalendarConnector {
    public static final String INPUT_DEST_CALENDAR_ID = "destCalendarId";

    @Override
    protected List<String> checkParameters() {
        ArrayList<String> errors = new ArrayList<String>();
        this.ensureIdInputIsSpecified(errors);
        if (this.getDestCalendarId() == null) {
            errors.add("Destination Calendar Id must be set.");
        }
        return errors;
    }

    @Override
    protected void doJobWithCalendarEvents(Calendar.Events events) throws ConnectorException {
        try {
            Calendar.Events.Move move = events.move(this.getCalendarId(), this.getId(), this.getDestCalendarId());
            this.setCommonInputs((CalendarRequest<Event>)move);
            if (this.getSendNotifications() != null) {
                move.setSendNotifications(this.getSendNotifications());
            }
            this.setOutputParameters((Event)move.execute());
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private String getDestCalendarId() {
        return (String)this.getInputParameter(INPUT_DEST_CALENDAR_ID);
    }
}

