/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.connectors.ws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.commons.text.translate.LookupTranslator;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecureWSConnector
extends AbstractConnector {
    private static final String KEY_VALUE_PATTERN = "%s: %s";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String SOCKS_PROXY_PORT = "socksProxyPort";
    private static final String SOCKS_PROXY_HOST = "socksProxyHost";
    private static final String SOCKS = "SOCKS";
    private static final String OUTPUT_RESPONSE_DOCUMENT_BODY = "responseDocumentBody";
    private static final String OUTPUT_RESPONSE_DOCUMENT_ENVELOPE = "responseDocumentEnvelope";
    private static final String OUTPUT_SOURCE_RESPONSE = "sourceResponse";
    private static final String PRINT_REQUEST_AND_RESPONSE = "printRequestAndResponse";
    private static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private static final String ONE_WAY_INVOKE = "oneWayInvoke";
    private static final String BUILD_RESPONSE_DOCUMENT_BODY = "buildResponseDocumentBody";
    private static final String BUILD_RESPONSE_DOCUMENT_ENVELOPE = "buildResponseDocumentEnvelope";
    private static final String BINDING = "binding";
    private static final String SOAP_ACTION = "soapAction";
    private static final String ENDPOINT_ADDRESS = "endpointAddress";
    private static final String ENVELOPE = "envelope";
    private static final String PORT_NAME = "portName";
    private static final String SERVICE_NAME = "serviceName";
    private static final String SERVICE_NS = "serviceNS";
    private static final String HTTP_HEADERS = "httpHeaders";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_PROTOCOL = "proxyProtocol";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final Logger LOGGER = Logger.getLogger(SecureWSConnector.class.getName());
    private Transformer transformer;
    private LookupTranslator lookupTranslator;
    private Map<String, String> saveProxyConfiguration = new HashMap<String, String>();

    public SecureWSConnector() {
        HashMap<String, String> escapeXml10Map = new HashMap<String, String>();
        escapeXml10Map.put("\u0000", "");
        escapeXml10Map.put("\u0001", "");
        escapeXml10Map.put("\u0002", "");
        escapeXml10Map.put("\u0003", "");
        escapeXml10Map.put("\u0004", "");
        escapeXml10Map.put("\u0005", "");
        escapeXml10Map.put("\u0006", "");
        escapeXml10Map.put("\u0007", "");
        escapeXml10Map.put("\b", "");
        escapeXml10Map.put("\u000b", "");
        escapeXml10Map.put("\f", "");
        escapeXml10Map.put("\u000e", "");
        escapeXml10Map.put("\u000f", "");
        escapeXml10Map.put("\u0010", "");
        escapeXml10Map.put("\u0011", "");
        escapeXml10Map.put("\u0012", "");
        escapeXml10Map.put("\u0013", "");
        escapeXml10Map.put("\u0014", "");
        escapeXml10Map.put("\u0015", "");
        escapeXml10Map.put("\u0016", "");
        escapeXml10Map.put("\u0017", "");
        escapeXml10Map.put("\u0018", "");
        escapeXml10Map.put("\u0019", "");
        escapeXml10Map.put("\u001a", "");
        escapeXml10Map.put("\u001b", "");
        escapeXml10Map.put("\u001c", "");
        escapeXml10Map.put("\u001d", "");
        escapeXml10Map.put("\u001e", "");
        escapeXml10Map.put("\u001f", "");
        escapeXml10Map.put("\ufffe", "");
        escapeXml10Map.put("\uffff", "");
        this.lookupTranslator = new LookupTranslator(Collections.unmodifiableMap(escapeXml10Map));
    }

    public void validateInputParameters() throws ConnectorValidationException {
        String serviceNS = (String)this.getInputParameter(SERVICE_NS);
        if (serviceNS == null) {
            throw new ConnectorValidationException("Service NS is required");
        }
        String serviceName = (String)this.getInputParameter(SERVICE_NAME);
        if (serviceName == null) {
            throw new ConnectorValidationException("Service Name is required");
        }
        String portName = (String)this.getInputParameter(PORT_NAME);
        if (portName == null) {
            throw new ConnectorValidationException("Port Name is required");
        }
        String envelope = (String)this.getInputParameter(ENVELOPE);
        if (envelope == null) {
            throw new ConnectorValidationException("Envelope is required");
        }
        String endpointAddress = (String)this.getInputParameter(ENDPOINT_ADDRESS);
        if (endpointAddress == null) {
            throw new ConnectorValidationException("endpointAddress is required");
        }
        String binding = (String)this.getInputParameter(BINDING);
        if (binding == null) {
            throw new ConnectorValidationException("binding is required");
        }
    }

    protected void executeBusinessLogic() throws ConnectorException {
        this.configureProxy();
        Dispatch<Source> dispatch = this.createDispatch();
        this.configureCredentials(dispatch);
        this.configureSoapAction(dispatch);
        this.configureHeaders(dispatch);
        String sanitizedEnvelope = this.retrieveAndSanitizeEnvelope();
        Source sourceResponse = this.invoke(dispatch, sanitizedEnvelope);
        this.restoreConfiguration();
        boolean buildResponseDocumentEnvelope = this.getAndLogOptionalBooleanParameter(BUILD_RESPONSE_DOCUMENT_ENVELOPE);
        boolean buildResponseDocumentBody = this.getAndLogOptionalBooleanParameter(BUILD_RESPONSE_DOCUMENT_BODY);
        Document responseDocumentEnvelope = null;
        Document responseDocumentBody = null;
        if (sourceResponse != null) {
            boolean printRequestAndResponse;
            DOMResult result = new DOMResult();
            try {
                this.getTransformer().transform(sourceResponse, result);
            }
            catch (TransformerException e) {
                throw new ConnectorException((Throwable)e);
            }
            responseDocumentEnvelope = this.buildResponseDocumentEnvelope(result);
            if (buildResponseDocumentBody) {
                responseDocumentBody = this.buildResponseDocumentBody(responseDocumentEnvelope);
            }
            if (printRequestAndResponse = this.getAndLogOptionalBooleanParameter(PRINT_REQUEST_AND_RESPONSE)) {
                this.printRequestAndResponse(this.newSourceFromDOM(result), buildResponseDocumentEnvelope, buildResponseDocumentBody, responseDocumentEnvelope, responseDocumentBody);
            }
            this.setOutputParameter(OUTPUT_SOURCE_RESPONSE, this.newSourceFromDOM(result));
        }
        this.setOutputParameter(OUTPUT_RESPONSE_DOCUMENT_ENVELOPE, buildResponseDocumentEnvelope ? responseDocumentEnvelope : null);
        this.setOutputParameter(OUTPUT_RESPONSE_DOCUMENT_BODY, buildResponseDocumentBody ? responseDocumentBody : null);
    }

    private Source newSourceFromDOM(DOMResult result) {
        return new DOMSource(result.getNode());
    }

    private Dispatch<Source> createDispatch() {
        String serviceNS = (String)this.getAndLogInputParameter(SERVICE_NS);
        String serviceName = (String)this.getAndLogInputParameter(SERVICE_NAME);
        String portName = (String)this.getAndLogInputParameter(PORT_NAME);
        String binding = (String)this.getAndLogInputParameter(BINDING);
        String endpointAddress = (String)this.getAndLogInputParameter(ENDPOINT_ADDRESS);
        QName serviceQName = new QName(serviceNS, serviceName);
        QName portQName = new QName(serviceNS, portName);
        Service service = Service.create((QName)serviceQName);
        service.addPort(portQName, binding, endpointAddress);
        Dispatch dispatch = service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);
        dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
        return dispatch;
    }

    private Source invoke(Dispatch<Source> dispatch, String sanitizedEnvelope) throws ConnectorException {
        boolean oneWayInvoke = this.getAndLogOptionalBooleanParameter(ONE_WAY_INVOKE);
        Source sourceResponse = null;
        try {
            StreamSource message = new StreamSource(new StringReader(sanitizedEnvelope));
            if (oneWayInvoke) {
                dispatch.invokeOneWay((Object)message);
            } else {
                sourceResponse = (Source)dispatch.invoke((Object)message);
            }
        }
        catch (Exception e) {
            throw new ConnectorException("Exception trying to call remote webservice", (Throwable)e);
        }
        return sourceResponse;
    }

    private String retrieveAndSanitizeEnvelope() {
        String sanitizedEnvelope;
        String initialEnvelope = (String)this.getInputParameter(ENVELOPE);
        if (!Objects.equals(initialEnvelope, sanitizedEnvelope = this.sanitizeString(initialEnvelope))) {
            LOGGER.warning("Invalid XML characters have been detected in the envelope, they will be removed.");
        }
        LOGGER.info(() -> String.format(KEY_VALUE_PATTERN, ENVELOPE, sanitizedEnvelope));
        return sanitizedEnvelope;
    }

    private void configureHeaders(Dispatch<Source> dispatch) {
        List httpHeadersList = (List)this.getInputParameter(HTTP_HEADERS);
        if (httpHeadersList != null) {
            HashMap httpHeadersMap = new HashMap();
            httpHeadersList.stream().filter(row -> row.size() == 2).forEach(row -> this.addHeader(httpHeadersMap, (List<Object>)row));
            dispatch.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeadersMap);
        }
    }

    private void addHeader(Map<String, List<String>> httpHeadersMap, List<Object> headerRow) {
        ArrayList<String> parameters = new ArrayList<String>();
        Object value = headerRow.get(1);
        if (value instanceof Collection) {
            ((Collection)value).stream().map(Object::toString).forEach(parameters::add);
        } else {
            parameters.add(value.toString());
        }
        httpHeadersMap.put((String)headerRow.get(0), parameters);
    }

    private void configureSoapAction(Dispatch<Source> dispatch) {
        Object soapAction = this.getAndLogInputParameter(SOAP_ACTION);
        if (soapAction != null) {
            dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
            dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", soapAction);
        }
    }

    private void configureCredentials(Dispatch<Source> dispatch) {
        Object authUserName = this.getInputParameter(USER_NAME);
        if (authUserName != null) {
            LOGGER.info(() -> String.format(KEY_VALUE_PATTERN, USER_NAME, authUserName));
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.username", authUserName);
            Object authPassword = this.getInputParameter(PASSWORD);
            dispatch.getRequestContext().put("javax.xml.ws.security.auth.password", authPassword);
        }
    }

    private boolean getAndLogOptionalBooleanParameter(String parameterName) {
        Object value = this.getAndLogInputParameter(parameterName);
        return value != null && (Boolean)value != false;
    }

    private Object getAndLogInputParameter(String parameterName) {
        Object value = this.getInputParameter(parameterName);
        LOGGER.info(() -> parameterName + ": " + value);
        return value;
    }

    private String sanitizeString(String stringToSanitize) {
        return this.lookupTranslator.translate((CharSequence)stringToSanitize);
    }

    private void restoreConfiguration() {
        for (Map.Entry<String, String> entry : this.saveProxyConfiguration.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.clearProperty(entry.getKey());
        }
        Authenticator.setDefault(null);
    }

    private void configureProxy() {
        this.saveProxyConfiguration = this.saveProxyConfiguration();
        String host = (String)this.getInputParameter(PROXY_HOST);
        if (host == null || host.isEmpty()) {
            return;
        }
        LOGGER.info(() -> String.format(KEY_VALUE_PATTERN, PROXY_HOST, host));
        String protocol = (String)this.getAndLogInputParameter(PROXY_PROTOCOL);
        String port = (String)this.getAndLogInputParameter(PROXY_PORT);
        if (SOCKS.equals(protocol)) {
            System.setProperty(SOCKS_PROXY_HOST, host);
            LOGGER.info(() -> String.format("Setting environment variable: socksProxyHost=%s", host));
            System.setProperty(SOCKS_PROXY_PORT, port);
            LOGGER.info(() -> String.format("Setting environment variable: socksProxyPort=%s", port));
        } else {
            String hostKey = String.format("%s.proxyHost", protocol.toLowerCase());
            System.setProperty(hostKey, host);
            LOGGER.info(() -> String.format("Setting environment variable: %s=%s", hostKey, host));
            String portKey = String.format("%s.proxyPort", protocol.toLowerCase());
            System.setProperty(portKey, port);
            LOGGER.info(() -> String.format("Setting environment variable: %s=%s", portKey, port));
        }
        final String user = (String)this.getAndLogInputParameter(PROXY_USER);
        final String password = (String)this.getInputParameter(PROXY_PASSWORD);
        if (user != null && !user.isEmpty()) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, password != null ? password.toCharArray() : "".toCharArray());
                }
            });
        }
    }

    private Map<String, String> saveProxyConfiguration() {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put(HTTP_PROXY_HOST, System.getProperty(HTTP_PROXY_HOST));
        configuration.put(HTTP_PROXY_PORT, System.getProperty(HTTP_PROXY_PORT));
        configuration.put(HTTPS_PROXY_HOST, System.getProperty(HTTPS_PROXY_HOST));
        configuration.put(HTTPS_PROXY_PORT, System.getProperty(HTTPS_PROXY_PORT));
        configuration.put(SOCKS_PROXY_HOST, System.getProperty(SOCKS_PROXY_HOST));
        configuration.put(SOCKS_PROXY_PORT, System.getProperty(SOCKS_PROXY_PORT));
        return configuration;
    }

    private Document buildResponseDocumentEnvelope(DOMResult result) {
        return result.getNode() instanceof Document ? (Document)result.getNode() : result.getNode().getOwnerDocument();
    }

    private Document buildResponseDocumentBody(Document responseDocumentEnvelope) throws ConnectorException {
        Document responseDocumentBody = null;
        if (responseDocumentEnvelope != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                responseDocumentBody = documentBuilderFactory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new ConnectorException((Throwable)pce);
            }
            Node bodyContent = this.getEnvelopeBodyContent(responseDocumentEnvelope);
            Node clonedBodyContent = bodyContent.cloneNode(true);
            responseDocumentBody.adoptNode(clonedBodyContent);
            responseDocumentBody.importNode(clonedBodyContent, true);
            responseDocumentBody.appendChild(clonedBodyContent);
        }
        return responseDocumentBody;
    }

    private void printRequestAndResponse(Source sourceResponse, boolean buildResponseDocumentEnvelope, boolean buildResponseDocumentBody, Document responseDocumentEnvelope, Document responseDocumentBody) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.getTransformer().transform(sourceResponse, new StreamResult(os));
            if (buildResponseDocumentEnvelope) {
                this.getTransformer().transform(new DOMSource(responseDocumentEnvelope), new StreamResult(os));
            } else if (buildResponseDocumentBody) {
                this.getTransformer().transform(new DOMSource(responseDocumentEnvelope), new StreamResult(os));
                this.getTransformer().transform(new DOMSource(responseDocumentBody), new StreamResult(os));
            }
            LOGGER.info(os::toString);
        }
        catch (IOException | TransformerException e) {
            LOGGER.severe(e.getMessage());
        }
    }

    Node getEnvelopeBodyContent(Document envelope) {
        Node envelopeNode = envelope.getFirstChild();
        NodeList children = envelopeNode.getChildNodes();
        Node envelopeBody = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node child = children.item(i);
            if (!(child instanceof Element) || !"Body".equalsIgnoreCase((element = (Element)child).getLocalName())) continue;
            envelopeBody = child;
            break;
        }
        if (envelopeBody == null) {
            return envelopeNode;
        }
        NodeList bodyChildren = envelopeBody.getChildNodes();
        for (int i = 0; i < bodyChildren.getLength(); ++i) {
            Node child = bodyChildren.item(i);
            if (!(child instanceof Element)) continue;
            return child;
        }
        return envelopeBody;
    }

    Transformer getTransformer() throws TransformerConfigurationException {
        if (this.transformer == null) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            this.transformer = transformerFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        return this.transformer;
    }
}

