/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.bpm.actor.ActorCriterion;
import org.bonitasoft.engine.bpm.actor.ActorInstance;
import org.bonitasoft.engine.bpm.actor.ActorMappingExportException;
import org.bonitasoft.engine.bpm.actor.ActorMappingImportException;
import org.bonitasoft.engine.bpm.actor.ActorMember;
import org.bonitasoft.engine.bpm.actor.ActorNotFoundException;
import org.bonitasoft.engine.bpm.actor.ActorUpdater;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.category.Category;
import org.bonitasoft.engine.bpm.category.CategoryCriterion;
import org.bonitasoft.engine.bpm.category.CategoryNotFoundException;
import org.bonitasoft.engine.bpm.category.CategoryUpdater;
import org.bonitasoft.engine.bpm.connector.ConnectorCriterion;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.bpm.connector.ConnectorNotFoundException;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeployException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoCriterion;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.bpm.process.ProcessEnablementException;
import org.bonitasoft.engine.bpm.process.ProcessExportException;
import org.bonitasoft.engine.bpm.supervisor.ProcessSupervisor;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;

public interface ProcessManagementAPI {
    public ProcessDefinition deploy(BusinessArchive var1) throws AlreadyExistsException, ProcessDeployException;

    public ProcessDefinition deploy(DesignProcessDefinition var1) throws AlreadyExistsException, ProcessDeployException;

    public void enableProcess(long var1) throws ProcessDefinitionNotFoundException, ProcessEnablementException;

    public void disableProcess(long var1) throws ProcessDefinitionNotFoundException, ProcessActivationException;

    public ProcessDefinition getProcessDefinition(long var1) throws ProcessDefinitionNotFoundException;

    @Deprecated
    public void deleteProcess(long var1) throws DeletionException;

    @Deprecated
    public void deleteProcesses(List<Long> var1) throws DeletionException;

    public void deleteProcessDefinition(long var1) throws DeletionException;

    public void deleteProcessDefinitions(List<Long> var1) throws DeletionException;

    public ProcessDefinition deployAndEnableProcess(DesignProcessDefinition var1) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException, InvalidProcessDefinitionException;

    public ProcessDefinition deployAndEnableProcess(BusinessArchive var1) throws ProcessDeployException, ProcessEnablementException, AlreadyExistsException;

    public List<Problem> getProcessResolutionProblems(long var1) throws ProcessDefinitionNotFoundException;

    @Deprecated
    public void disableAndDelete(long var1) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException;

    public long getNumberOfProcessDeploymentInfos();

    public ProcessDeploymentInfo getProcessDeploymentInfo(long var1) throws ProcessDefinitionNotFoundException;

    public void updateProcessDeploymentInfo(long var1, ProcessDeploymentInfoUpdater var3) throws ProcessDefinitionNotFoundException, UpdateException;

    public List<ProcessDeploymentInfo> getProcessDeploymentInfos(int var1, int var2, ProcessDeploymentInfoCriterion var3);

    public int getNumberOfActors(long var1) throws ProcessDefinitionNotFoundException;

    public ActorInstance getActor(long var1) throws ActorNotFoundException;

    public List<ActorInstance> getActors(long var1, int var3, int var4, ActorCriterion var5);

    public List<ActorMember> getActorMembers(long var1, int var3, int var4);

    public long getNumberOfActorMembers(long var1);

    public long getNumberOfUsersOfActor(long var1);

    public long getNumberOfRolesOfActor(long var1);

    public long getNumberOfGroupsOfActor(long var1);

    public long getNumberOfMembershipsOfActor(long var1);

    public ActorInstance updateActor(long var1, ActorUpdater var3) throws ActorNotFoundException, UpdateException;

    public ActorMember addUserToActor(long var1, long var3) throws CreationException, AlreadyExistsException;

    public ActorMember addUserToActor(String var1, ProcessDefinition var2, long var3) throws ActorNotFoundException, CreationException, AlreadyExistsException;

    public ActorMember addGroupToActor(long var1, long var3) throws CreationException, AlreadyExistsException;

    public ActorMember addGroupToActor(String var1, long var2, ProcessDefinition var4) throws ActorNotFoundException, CreationException, AlreadyExistsException;

    public ActorMember addRoleToActor(long var1, long var3) throws CreationException;

    public ActorMember addRoleToActor(String var1, ProcessDefinition var2, long var3) throws ActorNotFoundException, CreationException;

    public ActorMember addRoleAndGroupToActor(long var1, long var3, long var5) throws CreationException;

    public ActorMember addRoleAndGroupToActor(String var1, ProcessDefinition var2, long var3, long var5) throws ActorNotFoundException, CreationException;

    public void removeActorMember(long var1) throws DeletionException;

    public void importActorMapping(long var1, String var3) throws ActorMappingImportException;

    public void importActorMapping(long var1, byte[] var3) throws ActorMappingImportException;

    public String exportActorMapping(long var1) throws ActorMappingExportException;

    public Category createCategory(String var1, String var2) throws AlreadyExistsException, CreationException;

    public long getNumberOfCategories();

    public List<Category> getCategories(int var1, int var2, CategoryCriterion var3);

    public Category getCategory(long var1) throws CategoryNotFoundException;

    public void addProcessDefinitionToCategory(long var1, long var3) throws AlreadyExistsException, CreationException;

    public void addProcessDefinitionsToCategory(long var1, List<Long> var3) throws AlreadyExistsException, CreationException;

    public long getNumberOfCategories(long var1);

    public long getNumberOfProcessDefinitionsOfCategory(long var1);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosOfCategory(long var1, int var3, int var4, ProcessDeploymentInfoCriterion var5);

    public List<Category> getCategoriesOfProcessDefinition(long var1, int var3, int var4, CategoryCriterion var5);

    public void updateCategory(long var1, CategoryUpdater var3) throws CategoryNotFoundException, UpdateException;

    public void deleteCategory(long var1) throws DeletionException;

    @Deprecated
    public void removeAllProcessDefinitionsFromCategory(long var1) throws DeletionException;

    public long removeProcessDefinitionsFromCategory(long var1, int var3, int var4) throws DeletionException;

    @Deprecated
    public void removeAllCategoriesFromProcessDefinition(long var1) throws DeletionException;

    public long removeCategoriesFromProcessDefinition(long var1, int var3, int var4) throws DeletionException;

    public long getNumberOfUncategorizedProcessDefinitions();

    public List<ProcessDeploymentInfo> getUncategorizedProcessDeploymentInfos(int var1, int var2, ProcessDeploymentInfoCriterion var3);

    public List<DataDefinition> getActivityDataDefinitions(long var1, String var3, int var4, int var5) throws ProcessDefinitionNotFoundException, ActivityDefinitionNotFoundException;

    public int getNumberOfActivityDataDefinitions(long var1, String var3) throws ProcessDefinitionNotFoundException, ActivityDefinitionNotFoundException;

    public List<DataDefinition> getProcessDataDefinitions(long var1, int var3, int var4) throws ProcessDefinitionNotFoundException;

    public int getNumberOfProcessDataDefinitions(long var1) throws ProcessDefinitionNotFoundException;

    public Map<String, byte[]> getProcessResources(long var1, String var3) throws RetrieveException;

    public long getLatestProcessDefinitionId(String var1) throws ProcessDefinitionNotFoundException;

    public Set<String> getSupportedStates(FlowNodeType var1);

    public long getProcessDefinitionId(String var1, String var2) throws ProcessDefinitionNotFoundException;

    public List<ProcessDeploymentInfo> getStartableProcessDeploymentInfosForActors(Set<Long> var1, int var2, int var3, ProcessDeploymentInfoCriterion var4);

    public boolean isAllowedToStartProcess(long var1, Set<Long> var3);

    public ActorInstance getActorInitiator(long var1) throws ActorNotFoundException, ProcessDefinitionNotFoundException;

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosStartedBy(long var1, SearchOptions var3) throws SearchException;

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(long var1, SearchOptions var3) throws SearchException;

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfos(SearchOptions var1) throws SearchException;

    public void addCategoriesToProcess(long var1, List<Long> var3) throws AlreadyExistsException, CreationException;

    public void removeCategoriesFromProcess(long var1, List<Long> var3) throws DeletionException;

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfos(SearchOptions var1) throws SearchException;

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosSupervisedBy(long var1, SearchOptions var3) throws SearchException;

    public SearchResult<ProcessDeploymentInfo> searchUncategorizedProcessDeploymentInfosUserCanStart(long var1, SearchOptions var3) throws SearchException;

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromIds(List<Long> var1);

    public ConnectorImplementationDescriptor getConnectorImplementation(long var1, String var3, String var4) throws ConnectorNotFoundException;

    public List<ConnectorImplementationDescriptor> getConnectorImplementations(long var1, int var3, int var4, ConnectorCriterion var5);

    public long getNumberOfConnectorImplementations(long var1);

    public Map<Long, ActorInstance> getActorsFromActorIds(List<Long> var1);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroup(long var1, int var3, int var4, ProcessDeploymentInfoCriterion var5);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForGroups(List<Long> var1, int var2, int var3, ProcessDeploymentInfoCriterion var4);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRole(long var1, int var3, int var4, ProcessDeploymentInfoCriterion var5);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForRoles(List<Long> var1, int var2, int var3, ProcessDeploymentInfoCriterion var4);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUser(long var1, int var3, int var4, ProcessDeploymentInfoCriterion var5);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosWithActorOnlyForUsers(List<Long> var1, int var2, int var3, ProcessDeploymentInfoCriterion var4);

    public DesignProcessDefinition getDesignProcessDefinition(long var1) throws ProcessDefinitionNotFoundException;

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosSupervisedBy(long var1, SearchOptions var3) throws SearchException;

    public SearchResult<ProcessDeploymentInfo> searchProcessDeploymentInfosUsersManagedByCanStart(long var1, SearchOptions var3) throws SearchException;

    public ProcessSupervisor createProcessSupervisorForUser(long var1, long var3) throws CreationException, AlreadyExistsException;

    public ProcessSupervisor createProcessSupervisorForRole(long var1, long var3) throws CreationException, AlreadyExistsException;

    public ProcessSupervisor createProcessSupervisorForGroup(long var1, long var3) throws CreationException, AlreadyExistsException;

    public ProcessSupervisor createProcessSupervisorForMembership(long var1, long var3, long var5) throws CreationException, AlreadyExistsException;

    public boolean isUserProcessSupervisor(long var1, long var3);

    public void deleteSupervisor(long var1) throws DeletionException;

    public void deleteSupervisor(Long var1, Long var2, Long var3, Long var4) throws DeletionException;

    public SearchResult<ProcessSupervisor> searchProcessSupervisors(SearchOptions var1) throws SearchException;

    public List<Category> getCategoriesUnrelatedToProcessDefinition(long var1, int var3, int var4, CategoryCriterion var5);

    public long getNumberOfProcessDeploymentInfosUnrelatedToCategory(long var1);

    public List<ProcessDeploymentInfo> getProcessDeploymentInfosUnrelatedToCategory(long var1, int var3, int var4, ProcessDeploymentInfoCriterion var5);

    public SearchResult<User> searchUsersWhoCanStartProcessDefinition(long var1, SearchOptions var3) throws SearchException;

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromProcessInstanceIds(List<Long> var1);

    public Map<Long, ProcessDeploymentInfo> getProcessDeploymentInfosFromArchivedProcessInstanceIds(List<Long> var1);

    public byte[] exportBarProcessContentUnderHome(long var1) throws ProcessExportException;

    public void disableAndDeleteProcessDefinition(long var1) throws ProcessDefinitionNotFoundException, ProcessActivationException, DeletionException;

    public List<User> getPossibleUsersOfHumanTask(long var1, String var3, int var4, int var5);
}

