/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.util.ArrayList;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BarResource;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.InvalidBusinessArchiveFormatException;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;

public class BusinessArchiveBuilder {
    private BusinessArchive entity;

    public BusinessArchiveBuilder createNewBusinessArchive() {
        this.entity = new BusinessArchive();
        return this;
    }

    public BusinessArchiveBuilder setProcessDefinition(DesignProcessDefinition processDefinition) {
        this.entity.setProcessDefinition(processDefinition);
        return this;
    }

    public BusinessArchiveBuilder setParameters(Map<String, String> parameters) {
        this.entity.setParameters(parameters);
        return this;
    }

    public BusinessArchiveBuilder addClasspathResource(BarResource resource) {
        this.addBarResourceInPath(resource, "classpath/");
        return this;
    }

    public BusinessArchiveBuilder addConnectorImplementation(BarResource resource) {
        this.addBarResourceInPath(resource, "connector/");
        return this;
    }

    public BusinessArchiveBuilder addUserFilters(BarResource resource) {
        this.addBarResourceInPath(resource, "userFilters/");
        return this;
    }

    public BusinessArchiveBuilder setActorMapping(byte[] xmlContent) {
        this.entity.addResource("actorMapping.xml", xmlContent);
        return this;
    }

    public BusinessArchiveBuilder addExternalResource(BarResource resource) {
        this.addBarResourceInPath(resource, "resources/");
        return this;
    }

    public BusinessArchiveBuilder addDocumentResource(BarResource resource) {
        this.addBarResourceInPath(resource, "documents/");
        return this;
    }

    protected void addBarResourceInPath(BarResource resource, String path) {
        this.entity.addResource(path + resource.getName(), resource.getContent());
    }

    public BusinessArchive done() throws InvalidBusinessArchiveFormatException {
        if (this.entity.getProcessDefinition() == null) {
            throw new InvalidBusinessArchiveFormatException("missing process definition");
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (DocumentDefinition document : this.entity.getProcessDefinition().getProcessContainer().getDocumentDefinitions()) {
            byte[] resources;
            if (document.getFile() == null || (resources = this.entity.getResource("documents/" + document.getFile())) != null) continue;
            errors.add("missing document in the business archive that is present in the process definition " + document.getFile());
        }
        if (!errors.isEmpty()) {
            throw new InvalidBusinessArchiveFormatException(errors);
        }
        return this.entity;
    }
}

