/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bonitasoft.engine.bpm.NamedElementImpl;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.expression.Expression;

public abstract class FlowNodeDefinitionImpl
extends NamedElementImpl
implements FlowNodeDefinition {
    private static final long serialVersionUID = 429640943678358154L;
    private final List<TransitionDefinition> incomings = new ArrayList<TransitionDefinition>();
    private final List<TransitionDefinition> outgoings = new ArrayList<TransitionDefinition>();
    private final List<ConnectorDefinition> connectors = new ArrayList<ConnectorDefinition>();
    private String description;
    private Expression displayDescription;
    private Expression displayName;
    private Expression displayDescriptionAfterCompletion;
    private TransitionDefinition defaultTransition;

    public FlowNodeDefinitionImpl(long id, String name) {
        super(name);
        this.setId(id);
    }

    public FlowNodeDefinitionImpl(String name) {
        this(UUID.randomUUID().getLeastSignificantBits(), name);
    }

    @Override
    public TransitionDefinition getDefaultTransition() {
        return this.defaultTransition;
    }

    public void setDefaultTransition(TransitionDefinition defaultTransition) {
        this.defaultTransition = defaultTransition;
    }

    @Override
    public List<TransitionDefinition> getOutgoingTransitions() {
        return Collections.unmodifiableList(this.outgoings);
    }

    @Override
    public List<TransitionDefinition> getIncomingTransitions() {
        return Collections.unmodifiableList(this.incomings);
    }

    @Override
    public List<ConnectorDefinition> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public void addIncomingTransition(TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(transition);
        }
    }

    public void addIncomingTransition(int index, TransitionDefinition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(index, transition);
        }
    }

    public void removeIncomingTransition(TransitionDefinition transition) {
        this.incomings.remove(transition);
    }

    public void addOutgoingTransition(TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(transition);
        }
    }

    public void addOutgoingTransition(int index, TransitionDefinition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(index, transition);
        }
    }

    public void removeOutgoingTransition(TransitionDefinition transition) {
        this.outgoings.remove(transition);
    }

    @Override
    public void addConnector(ConnectorDefinition connectorDefinition) {
        this.connectors.add(connectorDefinition);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayDescription(Expression displayDescription) {
        this.displayDescription = displayDescription;
    }

    public void setDisplayName(Expression displayName) {
        this.displayName = displayName;
    }

    public void setDisplayDescriptionAfterCompletion(Expression displayDescriptionAfterCompletion) {
        this.displayDescriptionAfterCompletion = displayDescriptionAfterCompletion;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Expression getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public Expression getDisplayName() {
        return this.displayName;
    }

    @Override
    public Expression getDisplayDescriptionAfterCompletion() {
        return this.displayDescriptionAfterCompletion;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.connectors == null ? 0 : this.connectors.hashCode());
        result = 31 * result + (this.defaultTransition == null ? 0 : this.defaultTransition.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayDescription == null ? 0 : this.displayDescription.hashCode());
        result = 31 * result + (this.displayDescriptionAfterCompletion == null ? 0 : this.displayDescriptionAfterCompletion.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.incomings == null ? 0 : this.incomings.hashCode());
        result = 31 * result + (this.outgoings == null ? 0 : this.outgoings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowNodeDefinitionImpl other = (FlowNodeDefinitionImpl)obj;
        if (this.connectors == null ? other.connectors != null : !this.connectors.equals(other.connectors)) {
            return false;
        }
        if (this.defaultTransition == null ? other.defaultTransition != null : !this.defaultTransition.equals(other.defaultTransition)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayDescription == null ? other.displayDescription != null : !this.displayDescription.equals(other.displayDescription)) {
            return false;
        }
        if (this.displayDescriptionAfterCompletion == null ? other.displayDescriptionAfterCompletion != null : !this.displayDescriptionAfterCompletion.equals(other.displayDescriptionAfterCompletion)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.incomings == null ? other.incomings != null : !this.incomings.equals(other.incomings)) {
            return false;
        }
        return !(this.outgoings == null ? other.outgoings != null : !this.outgoings.equals(other.outgoings));
    }

    @Override
    public String toString() {
        int maxLen = 5;
        StringBuilder builder = new StringBuilder();
        builder.append("FlowNodeDefinitionImpl [incomings=");
        builder.append(this.incomings != null ? this.incomings.subList(0, Math.min(this.incomings.size(), 5)) : null);
        builder.append(", outgoings=");
        builder.append(this.outgoings != null ? this.outgoings.subList(0, Math.min(this.outgoings.size(), 5)) : null);
        builder.append(", connectors=");
        builder.append(this.connectors != null ? this.connectors.subList(0, Math.min(this.connectors.size(), 5)) : null);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", displayDescription=");
        builder.append(this.displayDescription);
        builder.append(", displayName=");
        builder.append(this.displayName);
        builder.append(", displayDescriptionAfterCompletion=");
        builder.append(this.displayDescriptionAfterCompletion);
        builder.append(", defaultTransition=");
        builder.append(this.defaultTransition);
        builder.append("]");
        return builder.toString();
    }
}

