/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.FlowElementContainerBuilder;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionBuilder;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationBuilder;
import org.bonitasoft.engine.operation.OperatorType;

public class ConnectorDefinitionBuilder
extends FlowElementContainerBuilder {
    private final ConnectorDefinitionImpl connectorDefinition;
    private final ProcessDefinitionBuilder processDefinitionBuilder;

    ConnectorDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String name, String connectorId, String version, ConnectorEvent activationEvent) {
        super(container, processDefinitionBuilder);
        this.processDefinitionBuilder = processDefinitionBuilder;
        this.connectorDefinition = new ConnectorDefinitionImpl(name, connectorId, version, activationEvent);
        container.addConnector(this.connectorDefinition);
    }

    ConnectorDefinitionBuilder(ProcessDefinitionBuilder processDefinitionBuilder, FlowElementContainerDefinitionImpl container, String name, String connectorId, String version, ConnectorEvent activationEvent, ActivityDefinition activity) {
        super(container, processDefinitionBuilder);
        this.processDefinitionBuilder = processDefinitionBuilder;
        this.connectorDefinition = new ConnectorDefinitionImpl(name, connectorId, version, activationEvent);
        activity.addConnector(this.connectorDefinition);
    }

    public ConnectorDefinitionBuilder addInput(String name, Expression value) {
        if (value == null) {
            this.processDefinitionBuilder.addError("The input " + name + " of connector " + this.connectorDefinition.getName() + " is null");
        } else {
            this.connectorDefinition.addInput(name, value);
        }
        return this;
    }

    public ConnectorDefinitionBuilder addOutput(Operation operation) {
        this.connectorDefinition.addOutput(operation);
        if (operation.getRightOperand() == null) {
            this.getProcessBuilder().addError("operation on connector " + this.connectorDefinition.getName() + " has no expression in left operand");
        }
        return this;
    }

    public ConnectorDefinitionBuilder addOutput(LeftOperand leftOperand, OperatorType type, String operator, String operatorInputType, Expression rightOperand) {
        this.connectorDefinition.addOutput(new OperationBuilder().createNewInstance().setRightOperand(rightOperand).setType(type).setOperator(operator).setOperatorInputType(operatorInputType).setLeftOperand(leftOperand).done());
        if (rightOperand == null) {
            this.getProcessBuilder().addError("operation on connector " + this.connectorDefinition.getName() + " has no expression in left operand");
        }
        return this;
    }

    public ConnectorDefinitionBuilder ignoreError() {
        this.connectorDefinition.setFailAction(FailAction.IGNORE);
        return this;
    }

    public ConnectorDefinitionBuilder throwErrorEventWhenFailed(String errorCode) {
        this.connectorDefinition.setFailAction(FailAction.ERROR_EVENT);
        this.connectorDefinition.setErrorCode(errorCode);
        return this;
    }
}

