/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

public class DesignProcessDefinitionImpl
extends ProcessDefinitionImpl
implements DesignProcessDefinition {
    private static final long serialVersionUID = -4719128363958199300L;
    private String displayName;
    private String displayDescription;
    private final Set<ParameterDefinition> parameters = new HashSet<ParameterDefinition>();
    private final List<ActorDefinition> actors = new ArrayList<ActorDefinition>();
    private ActorDefinition actorInitiator;
    private FlowElementContainerDefinition flowElementContainer;
    private String stringIndexLabel1;
    private String stringIndexLabel2;
    private String stringIndexLabel3;
    private String stringIndexLabel4;
    private String stringIndexLabel5;
    private Expression stringIndexValue1;
    private Expression stringIndexValue2;
    private Expression stringIndexValue3;
    private Expression stringIndexValue4;
    private Expression stringIndexValue5;

    public DesignProcessDefinitionImpl(String name, String version) {
        super(name, version);
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setDisplayDescription(String description) {
        this.displayDescription = description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public List<ActorDefinition> getActorsList() {
        return this.actors;
    }

    @Override
    @Deprecated
    public Set<ActorDefinition> getActors() {
        return new HashSet<ActorDefinition>(this.actors);
    }

    @Override
    public Set<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void addParameter(ParameterDefinition parameter) {
        this.parameters.add(parameter);
    }

    public void addActor(ActorDefinition actor) {
        this.actors.add(actor);
    }

    @Override
    public ActorDefinition getActorInitiator() {
        return this.actorInitiator;
    }

    public void setActorInitiator(ActorDefinition actorInitiator) {
        this.actorInitiator = actorInitiator;
    }

    @Override
    public FlowElementContainerDefinition getProcessContainer() {
        return this.flowElementContainer;
    }

    public void setProcessContainer(FlowElementContainerDefinition processContainer) {
        this.flowElementContainer = processContainer;
    }

    @Override
    public String getStringIndexLabel(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexLabel1;
            }
            case 2: {
                return this.stringIndexLabel2;
            }
            case 3: {
                return this.stringIndexLabel3;
            }
            case 4: {
                return this.stringIndexLabel4;
            }
            case 5: {
                return this.stringIndexLabel5;
            }
        }
        throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
    }

    @Override
    public Expression getStringIndexValue(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexValue1;
            }
            case 2: {
                return this.stringIndexValue2;
            }
            case 3: {
                return this.stringIndexValue3;
            }
            case 4: {
                return this.stringIndexValue4;
            }
            case 5: {
                return this.stringIndexValue5;
            }
        }
        throw new IndexOutOfBoundsException("string index value must be between 1 and 5 (included)");
    }

    public ActorDefinition getActor(String actorName) {
        Iterator<ActorDefinition> iterator = this.actors.iterator();
        ActorDefinition actorDefinition = null;
        boolean found = false;
        while (!found && iterator.hasNext()) {
            ActorDefinition next = iterator.next();
            if (!next.getName().equals(actorName)) continue;
            found = true;
            actorDefinition = next;
        }
        return actorDefinition;
    }

    public void setStringIndex(int index, String label, Expression initialValue) {
        switch (index) {
            case 1: {
                this.stringIndexLabel1 = label;
                this.stringIndexValue1 = initialValue;
                break;
            }
            case 2: {
                this.stringIndexLabel2 = label;
                this.stringIndexValue2 = initialValue;
                break;
            }
            case 3: {
                this.stringIndexLabel3 = label;
                this.stringIndexValue3 = initialValue;
                break;
            }
            case 4: {
                this.stringIndexLabel4 = label;
                this.stringIndexValue4 = initialValue;
                break;
            }
            case 5: {
                this.stringIndexLabel5 = label;
                this.stringIndexValue5 = initialValue;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actorInitiator == null ? 0 : this.actorInitiator.hashCode());
        result = 31 * result + (this.actors == null ? 0 : this.actors.hashCode());
        result = 31 * result + (this.displayDescription == null ? 0 : this.displayDescription.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.flowElementContainer == null ? 0 : this.flowElementContainer.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.stringIndexLabel1 == null ? 0 : this.stringIndexLabel1.hashCode());
        result = 31 * result + (this.stringIndexLabel2 == null ? 0 : this.stringIndexLabel2.hashCode());
        result = 31 * result + (this.stringIndexLabel3 == null ? 0 : this.stringIndexLabel3.hashCode());
        result = 31 * result + (this.stringIndexLabel4 == null ? 0 : this.stringIndexLabel4.hashCode());
        result = 31 * result + (this.stringIndexLabel5 == null ? 0 : this.stringIndexLabel5.hashCode());
        result = 31 * result + (this.stringIndexValue1 == null ? 0 : this.stringIndexValue1.hashCode());
        result = 31 * result + (this.stringIndexValue2 == null ? 0 : this.stringIndexValue2.hashCode());
        result = 31 * result + (this.stringIndexValue3 == null ? 0 : this.stringIndexValue3.hashCode());
        result = 31 * result + (this.stringIndexValue4 == null ? 0 : this.stringIndexValue4.hashCode());
        result = 31 * result + (this.stringIndexValue5 == null ? 0 : this.stringIndexValue5.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DesignProcessDefinitionImpl)) {
            return false;
        }
        DesignProcessDefinitionImpl other = (DesignProcessDefinitionImpl)obj;
        if (this.actorInitiator == null ? other.actorInitiator != null : !this.actorInitiator.equals(other.actorInitiator)) {
            return false;
        }
        if (this.actors == null ? other.actors != null : !this.actors.equals(other.actors)) {
            return false;
        }
        if (this.displayDescription == null ? other.displayDescription != null : !this.displayDescription.equals(other.displayDescription)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.flowElementContainer == null ? other.flowElementContainer != null : !this.flowElementContainer.equals(other.flowElementContainer)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.stringIndexLabel1 == null ? other.stringIndexLabel1 != null : !this.stringIndexLabel1.equals(other.stringIndexLabel1)) {
            return false;
        }
        if (this.stringIndexLabel2 == null ? other.stringIndexLabel2 != null : !this.stringIndexLabel2.equals(other.stringIndexLabel2)) {
            return false;
        }
        if (this.stringIndexLabel3 == null ? other.stringIndexLabel3 != null : !this.stringIndexLabel3.equals(other.stringIndexLabel3)) {
            return false;
        }
        if (this.stringIndexLabel4 == null ? other.stringIndexLabel4 != null : !this.stringIndexLabel4.equals(other.stringIndexLabel4)) {
            return false;
        }
        if (this.stringIndexLabel5 == null ? other.stringIndexLabel5 != null : !this.stringIndexLabel5.equals(other.stringIndexLabel5)) {
            return false;
        }
        if (this.stringIndexValue1 == null ? other.stringIndexValue1 != null : !this.stringIndexValue1.equals(other.stringIndexValue1)) {
            return false;
        }
        if (this.stringIndexValue2 == null ? other.stringIndexValue2 != null : !this.stringIndexValue2.equals(other.stringIndexValue2)) {
            return false;
        }
        if (this.stringIndexValue3 == null ? other.stringIndexValue3 != null : !this.stringIndexValue3.equals(other.stringIndexValue3)) {
            return false;
        }
        if (this.stringIndexValue4 == null ? other.stringIndexValue4 != null : !this.stringIndexValue4.equals(other.stringIndexValue4)) {
            return false;
        }
        return !(this.stringIndexValue5 == null ? other.stringIndexValue5 != null : !this.stringIndexValue5.equals(other.stringIndexValue5));
    }

    @Override
    public String toString() {
        return "DesignProcessDefinitionImpl [displayName=" + this.displayName + ", displayDescription=" + this.displayDescription + ", parameters=" + this.parameters + ", actors=" + this.actors + ", actorInitiator=" + this.actorInitiator + ", flowElementContainer=" + this.flowElementContainer + ", stringIndexLabel1=" + this.stringIndexLabel1 + ", stringIndexLabel2=" + this.stringIndexLabel2 + ", stringIndexLabel3=" + this.stringIndexLabel3 + ", stringIndexLabel4=" + this.stringIndexLabel4 + ", stringIndexLabel5=" + this.stringIndexLabel5 + ", stringIndexValue1=" + this.stringIndexValue1 + ", stringIndexValue2=" + this.stringIndexValue2 + ", stringIndexValue3=" + this.stringIndexValue3 + ", stringIndexValue4=" + this.stringIndexValue4 + ", stringIndexValue5=" + this.stringIndexValue5 + "]";
    }
}

