/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.exception;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.bonitasoft.engine.api.internal.ServerWrappedException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;

public class StackTraceTransformer {
    private final ServerWrappedException e;
    static Field field;

    public StackTraceTransformer(ServerWrappedException e) {
        this.e = e;
    }

    public static ServerWrappedException mergeStackTraces(ServerWrappedException e) {
        try {
            return new StackTraceTransformer(e).merge();
        }
        catch (Exception e1) {
            System.err.println("Unable to throw the root exception: " + e1.getClass().getName() + ": " + e1.getMessage());
            e1.printStackTrace();
            return new ServerWrappedException(new BonitaRuntimeException("Unable to throw the root exception because of (see log for the original stack trace)", e));
        }
    }

    private ServerWrappedException merge() throws Exception {
        Throwable cause = this.e.getCause();
        if (field != null) {
            this.transfertStack(cause, cause);
            field.set(cause, null);
            return this.e;
        }
        Throwable newCause = cause.getMessage() != null ? (Throwable)cause.getClass().getConstructor(String.class).newInstance(this.e.getMessage()) : (Throwable)cause.getClass().newInstance();
        this.transfertStack(newCause, cause);
        return new ServerWrappedException(newCause);
    }

    private void transfertStack(Throwable newCause, Throwable cause) {
        Throwable subCause = cause.getCause();
        if (subCause == null) {
            return;
        }
        StackTraceElement[] currentStack = cause.getStackTrace();
        ArrayList<StackTraceElement[]> causesStacks = new ArrayList<StackTraceElement[]>();
        ArrayList<Integer> framesInCommons = new ArrayList<Integer>();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        int causeslength = 0;
        StackTraceElement[] lastStack = currentStack;
        do {
            StackTraceElement[] trace = subCause.getStackTrace();
            causesStacks.add(trace);
            exceptions.add(subCause);
            int m = trace.length - 1;
            for (int n = lastStack.length - 1; m >= 0 && n >= 0 && trace[m].equals(lastStack[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            framesInCommons.add(framesInCommon);
            lastStack = trace;
            causeslength += trace.length + 1 - framesInCommon + (framesInCommon == 0 ? 0 : 1);
        } while ((subCause = subCause.getCause()) != null);
        StackTraceElement[] mergedStackTrace = new StackTraceElement[currentStack.length + causeslength + 1];
        System.arraycopy(currentStack, 0, mergedStackTrace, 0, currentStack.length);
        mergedStackTrace[currentStack.length] = new StackTraceElement("\t< ========== Beginning of the server stack trace ========== >", " ", " ", -3);
        int current = currentStack.length + 1;
        int i = 0;
        for (StackTraceElement[] stackTraceElements : causesStacks) {
            Integer framesInCommon = (Integer)framesInCommons.get(i);
            mergedStackTrace[current] = new StackTraceElement("\tCaused by: " + ((Throwable)exceptions.get(i)).getClass().getName(), ": " + ((Throwable)exceptions.get(i)).getMessage() + " ", " ", -3);
            System.arraycopy(stackTraceElements, 0, mergedStackTrace, ++current, stackTraceElements.length - framesInCommon);
            current += stackTraceElements.length - framesInCommon;
            if (framesInCommon != 0) {
                mergedStackTrace[current] = new StackTraceElement("... " + framesInCommon + " more", " ", " ", -3);
                ++current;
            }
            ++i;
        }
        newCause.setStackTrace(mergedStackTrace);
    }

    static {
        try {
            field = Throwable.class.getDeclaredField("cause");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

