/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.home;

import java.io.File;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;

public abstract class BonitaHome {
    public static final String BONITA_HOME = "bonita.home";
    private String home;

    public final String getBonitaHomeFolder() throws BonitaHomeNotSetException {
        if (this.home == null) {
            String path = System.getProperty(BONITA_HOME);
            if (path == null || path.isEmpty()) {
                throw new BonitaHomeNotSetException("You need to set the system property: bonita.home");
            }
            if ((path = path.trim()).charAt(path.length() - 1) == File.separatorChar) {
                path = path.substring(0, path.length() - 1);
            }
            this.home = path;
        }
        return this.home;
    }

    public final void refreshBonitaHome() {
        this.home = null;
        this.refresh();
    }

    protected abstract void refresh();
}

