/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bonitasoft.engine.io.xml.ElementBinding;
import org.bonitasoft.engine.io.xml.ElementBindingsFactory;
import org.bonitasoft.engine.io.xml.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BindingHandler
extends DefaultHandler {
    private final Map<String, Class<? extends ElementBinding>> binders;
    private final ElementBindingsFactory bindingsFactory;
    private final Stack<ElementBinding> model;
    private final Stack<String> elements;
    private StringBuilder tempVal;
    private Map<String, String> tempAttributes;

    public BindingHandler(List<Class<? extends ElementBinding>> binders) {
        this.binders = this.setBinders(binders);
        this.model = new Stack();
        this.elements = new Stack();
        this.tempAttributes = new HashMap<String, String>();
        this.bindingsFactory = null;
    }

    public BindingHandler(ElementBindingsFactory bindingsFactory) {
        this.bindingsFactory = bindingsFactory;
        this.model = new Stack();
        this.elements = new Stack();
        this.tempAttributes = new HashMap<String, String>();
        this.binders = this.setBinders(bindingsFactory);
    }

    private Map<String, Class<? extends ElementBinding>> setBinders(ElementBindingsFactory bindingsFactory) {
        List<ElementBinding> elementBindings = bindingsFactory.getElementBindings();
        HashMap<String, Class<? extends ElementBinding>> temp = new HashMap<String, Class<? extends ElementBinding>>();
        for (int i = 0; i < elementBindings.size(); ++i) {
            ElementBinding elementBinding = elementBindings.get(i);
            try {
                String tag = elementBinding.getElementTag();
                temp.put(tag, elementBinding.getClass());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return temp;
    }

    private Map<String, Class<? extends ElementBinding>> setBinders(List<Class<? extends ElementBinding>> binders) {
        HashMap<String, Class<? extends ElementBinding>> temp = new HashMap<String, Class<? extends ElementBinding>>();
        for (int i = 0; i < binders.size(); ++i) {
            Class<? extends ElementBinding> binderClass = binders.get(i);
            try {
                String tag = binderClass.newInstance().getElementTag();
                temp.put(tag, binderClass);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return temp;
    }

    public Object getModel() {
        ElementBinding root = this.model.peek();
        return root.getObject();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String tempString;
        if (this.tempVal == null) {
            this.tempVal = new StringBuilder();
        }
        if ("".equals((tempString = new String(ch, start, length)).trim())) {
            tempString = "";
        }
        this.tempVal.append(tempString);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Class<? extends ElementBinding> binderClass = this.binders.get(localName);
        if (binderClass != null) {
            HashMap<String, String> elementAttributes = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeLocalName = attributes.getLocalName(i);
                String attributeValue = attributes.getValue(i);
                elementAttributes.put(attributeLocalName, attributeValue);
            }
            ElementBinding binder = this.getBinder(binderClass);
            binder.setBinders(this.model);
            this.model.push(binder);
            this.elements.push(localName);
            try {
                binder.setAttributes(elementAttributes);
            }
            catch (XMLParseException e) {
                throw new SAXException(e);
            }
        } else {
            this.tempAttributes = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeLocalName = attributes.getLocalName(i);
                String attributeValue = attributes.getValue(i);
                this.tempAttributes.put(attributeLocalName, attributeValue);
            }
        }
    }

    private ElementBinding getBinder(Class<? extends ElementBinding> binderClass) throws SAXException {
        try {
            if (this.bindingsFactory != null) {
                return this.bindingsFactory.createNewInstance(binderClass);
            }
            return binderClass.newInstance();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentElement = this.elements.peek();
        if (localName.equals(currentElement)) {
            ElementBinding child = this.model.pop();
            currentElement = this.elements.pop();
            Object object = child.getObject();
            if (!this.model.isEmpty()) {
                ElementBinding parent = this.model.peek();
                try {
                    parent.setChildObject(localName, object);
                }
                catch (XMLParseException e) {
                    throw new SAXException(e);
                }
            } else {
                this.model.push(child);
                this.elements.push(currentElement);
            }
        } else {
            ElementBinding binder = this.model.peek();
            try {
                if (this.tempVal != null) {
                    binder.setChildElement(localName, this.tempVal.toString(), this.tempAttributes);
                } else {
                    binder.setChildElement(localName, "", this.tempAttributes);
                }
                this.tempVal = null;
            }
            catch (XMLParseException e) {
                throw new SAXException(e);
            }
        }
    }
}

