/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.AESFastEngine;
import org.bouncycastle.crypto.fips.BlockCipherUtils;
import org.bouncycastle.crypto.fips.CipherKeyGenerator;
import org.bouncycastle.crypto.fips.FipsAEADOperatorFactory;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsInputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsInputDecryptor;
import org.bouncycastle.crypto.fips.FipsKeyUnwrapper;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.crypto.fips.FipsKeyWrapper;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputAEADDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputAEADEncryptor;
import org.bouncycastle.crypto.fips.FipsOutputDecryptor;
import org.bouncycastle.crypto.fips.FipsOutputEncryptor;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;
import org.bouncycastle.crypto.internal.macs.AEADCipherMac;
import org.bouncycastle.crypto.internal.macs.CMac;
import org.bouncycastle.crypto.internal.macs.GMac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapWithPaddingEngine;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsAES {
    static final FipsEngineProvider<BlockCipher> ENGINE_PROVIDER;
    public static final FipsAlgorithm ALGORITHM;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB128;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters GCM;
    public static final AuthParameters CCM;
    public static final AuthParameters CMAC;
    public static final AuthParameters GMAC;
    public static final WrapParameters KW;
    public static final WrapParameters KWP;

    private FipsAES() {
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm fipsAlgorithm) {
        FipsEngineProvider<Mac> fipsEngineProvider;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CMAC: {
                fipsEngineProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new CMac((BlockCipher)ENGINE_PROVIDER.createEngine());
                    }
                };
                break;
            }
            case GMAC: {
                fipsEngineProvider = new FipsEngineProvider<Mac>(){

                    @Override
                    public Mac createEngine() {
                        return new GMac(new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES MAC Provider: " + fipsAlgorithm);
            }
        }
        return fipsEngineProvider;
    }

    static Mac makeMAC(AuthParameters authParameters) {
        Mac mac;
        switch ((Mode)authParameters.getAlgorithm().basicVariation()) {
            case CCM: {
                mac = new AEADCipherMac(new CCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()), authParameters.macLenInBits);
                break;
            }
            case CMAC: {
                mac = new CMac((BlockCipher)ENGINE_PROVIDER.createEngine(), authParameters.macLenInBits);
                break;
            }
            case GMAC: {
                mac = new GMac(new GCMBlockCipher((BlockCipher)ENGINE_PROVIDER.createEngine()), authParameters.macLenInBits);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.OperatorFactory.createMACCalculator: " + authParameters.getAlgorithm());
            }
        }
        return mac;
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, FipsAlgorithm fipsAlgorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n = validatedSymmetricKey.getKeySizeInBits();
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalKeyException("AES key must be of length 128, 192, or 256");
        }
        Algorithm algorithm = validatedSymmetricKey.getAlgorithm();
        if (algorithm != ALGORITHM && algorithm != fipsAlgorithm) {
            throw new IllegalKeyException("FIPS Key not for specified algorithm");
        }
        return validatedSymmetricKey;
    }

    private static void ccmStartUpTest(EngineProvider engineProvider) {
        SelfTestExecutor.validate(CCM.getAlgorithm(), engineProvider, new VariantKatTest<EngineProvider>(){

            @Override
            public void evaluate(EngineProvider engineProvider) throws Exception {
                byte[] byArray = Hex.decode("404142434445464748494a4b4c4d4e4f");
                byte[] byArray2 = Hex.decode("10111213141516");
                byte[] byArray3 = Hex.decode("0001020304050607");
                byte[] byArray4 = Hex.decode("20212223");
                byte[] byArray5 = Hex.decode("7162015b4dac255d");
                byte[] byArray6 = Hex.decode("6084341b");
                CCMBlockCipher cCMBlockCipher = new CCMBlockCipher(engineProvider.createEngine());
                CCMBlockCipher cCMBlockCipher2 = new CCMBlockCipher(engineProvider.createEngine());
                int n = byArray6.length * 8;
                KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray);
                cCMBlockCipher.init(true, new AEADParameters(keyParameterImpl, n, byArray2, byArray3));
                byte[] byArray7 = new byte[byArray5.length];
                int n2 = cCMBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray7, 0);
                cCMBlockCipher.doFinal(byArray7, n2);
                if (!Arrays.areEqual(byArray5, byArray7)) {
                    this.fail("Encrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(byArray6, cCMBlockCipher.getMac())) {
                    this.fail("MAC fails to match in self test encrypt");
                }
                cCMBlockCipher2.init(false, new AEADParameters(keyParameterImpl, n, byArray2, byArray3));
                byte[] byArray8 = new byte[byArray7.length];
                n2 = cCMBlockCipher2.processBytes(byArray7, 0, byArray7.length, byArray8, 0);
                n2 += cCMBlockCipher2.doFinal(byArray8, n2);
                byte[] byArray9 = new byte[n2];
                System.arraycopy(byArray8, 0, byArray9, 0, n2);
                if (!Arrays.areEqual(byArray4, byArray9)) {
                    this.fail("Decrypted stream fails to match in self test");
                }
                if (!Arrays.areEqual(byArray6, cCMBlockCipher2.getMac())) {
                    this.fail("MAC fails to match in self test");
                }
            }
        });
    }

    private static void cmacStartUpTest(final EngineProvider engineProvider) {
        SelfTestExecutor.validate(CMAC.getAlgorithm(), engineProvider, new BasicKatTest<EngineProvider>(){

            @Override
            public boolean hasTestPassed(EngineProvider engineProvider2) {
                byte[] byArray = Hex.decode("2b7e151628aed2a6abf7158809cf4f3c");
                byte[] byArray2 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
                byte[] byArray3 = Hex.decode("070a16b46b4d4144f79bdd9dd04a287c");
                CMac cMac = new CMac(engineProvider.createEngine(), 128);
                KeyParameterImpl keyParameterImpl = new KeyParameterImpl(byArray);
                cMac.init(keyParameterImpl);
                cMac.update(byArray2, 0, byArray2.length);
                byte[] byArray4 = new byte[16];
                cMac.doFinal(byArray4, 0);
                return Arrays.areEqual(byArray4, byArray3);
            }
        });
    }

    private static void gcmStartUpTest(EngineProvider engineProvider) {
        SelfTestExecutor.validate(GCM.getAlgorithm(), engineProvider, new VariantKatTest<EngineProvider>(){

            @Override
            public void evaluate(EngineProvider engineProvider) throws Exception {
                GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(engineProvider.createEngine());
                GCMBlockCipher gCMBlockCipher2 = new GCMBlockCipher(engineProvider.createEngine());
                byte[] byArray = Hex.decode("feffe9928665731c6d6a8f9467308308");
                byte[] byArray2 = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39");
                byte[] byArray3 = Hex.decode("feedfacedeadbeeffeedfacedeadbeefabaddad2");
                byte[] byArray4 = Hex.decode("cafebabefacedbaddecaf888");
                byte[] byArray5 = Hex.decode("42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091");
                byte[] byArray6 = Hex.decode("5bc94fbc3221a5db94fae95ae7121a47");
                AEADParameters aEADParameters = new AEADParameters(new KeyParameterImpl(byArray), byArray6.length * 8, byArray4, byArray3);
                gCMBlockCipher.init(true, aEADParameters);
                gCMBlockCipher2.init(false, aEADParameters);
                byte[] byArray7 = new byte[gCMBlockCipher.getOutputSize(byArray2.length)];
                int n = gCMBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray7, 0);
                n += gCMBlockCipher.doFinal(byArray7, n);
                if (byArray7.length != n) {
                    this.fail("Encryption reported incorrect length");
                }
                byte[] byArray8 = gCMBlockCipher.getMac();
                byte[] byArray9 = new byte[byArray2.length];
                System.arraycopy(byArray7, 0, byArray9, 0, byArray9.length);
                byte[] byArray10 = new byte[byArray7.length - byArray2.length];
                System.arraycopy(byArray7, byArray2.length, byArray10, 0, byArray10.length);
                if (!Arrays.areEqual(byArray5, byArray9)) {
                    this.fail("Incorrect encrypt");
                }
                if (!Arrays.areEqual(byArray6, byArray8)) {
                    this.fail("getMac() returned wrong MAC");
                }
                if (!Arrays.areEqual(byArray6, byArray10)) {
                    this.fail("Stream contained wrong MAC");
                }
                byte[] byArray11 = new byte[gCMBlockCipher2.getOutputSize(byArray7.length)];
                n = gCMBlockCipher2.processBytes(byArray7, 0, byArray7.length, byArray11, 0);
                gCMBlockCipher2.doFinal(byArray11, n);
                byArray8 = gCMBlockCipher2.getMac();
                byArray9 = new byte[byArray5.length];
                System.arraycopy(byArray11, 0, byArray9, 0, byArray9.length);
                if (!Arrays.areEqual(byArray2, byArray9)) {
                    this.fail("Incorrect decrypt");
                }
                if (!Arrays.areEqual(byArray6, byArray8)) {
                    this.fail("Incorrect MAC on decrypt");
                }
            }
        });
    }

    static {
        ALGORITHM = new FipsAlgorithm("AES");
        ECB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB128 = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CFB128));
        OFB = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.OFB128));
        CTR = new Parameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        GCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GCM));
        CCM = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CCM));
        CMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GMAC = new AuthParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.GMAC));
        KW = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAP));
        KWP = new WrapParameters(new FipsAlgorithm(ALGORITHM, (Enum)Mode.WRAPPAD));
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        FipsAES.ccmStartUpTest(engineProvider);
        FipsAES.cmacStartUpTest(engineProvider);
        FipsAES.gcmStartUpTest(engineProvider);
        ENGINE_PROVIDER = engineProvider;
        FipsRegister.registerEngineProvider(ALGORITHM, engineProvider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends FipsAEADOperatorFactory<AuthParameters> {
        @Override
        public FipsOutputAEADEncryptor<AuthParameters> createOutputAEADEncryptor(SymmetricKey symmetricKey, AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            return new OutEncryptor(validatedSymmetricKey, authParameters);
        }

        @Override
        public FipsOutputAEADDecryptor<AuthParameters> createOutputAEADDecryptor(SymmetricKey symmetricKey, final AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            final AEADBlockCipher aEADBlockCipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
            if (authParameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            aEADBlockCipher.init(false, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            return new FipsOutputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return authParameters;
                }

                @Override
                public int getMaxOutputSize(int n) {
                    return aEADBlockCipher.getOutputSize(n);
                }

                @Override
                public int getUpdateOutputSize(int n) {
                    return aEADBlockCipher.getUpdateOutputSize(n);
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(aEADBlockCipher);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream outputStream) {
                    return new CipherOutputStreamImpl(outputStream, aEADBlockCipher);
                }

                @Override
                public byte[] getMAC() {
                    return aEADBlockCipher.getMac();
                }
            };
        }

        @Override
        public FipsInputAEADDecryptor<AuthParameters> createInputAEADDecryptor(SymmetricKey symmetricKey, final AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            final AEADBlockCipher aEADBlockCipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
            if (authParameters.iv == null) {
                throw new IllegalArgumentException("AEAD decryption requires an iv/nonce to be provided.");
            }
            aEADBlockCipher.init(false, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            return new FipsInputAEADDecryptor<AuthParameters>(){

                @Override
                public AuthParameters getParameters() {
                    return authParameters;
                }

                @Override
                public UpdateOutputStream getAADStream() {
                    return new AADStream(aEADBlockCipher);
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream) {
                    return new CipherInputStream(inputStream, aEADBlockCipher);
                }

                @Override
                public byte[] getMAC() {
                    return aEADBlockCipher.getMac();
                }
            };
        }

        private static class AADStream
        extends UpdateOutputStream {
            private AEADBlockCipher cipher;

            public AADStream(AEADBlockCipher aEADBlockCipher) {
                this.cipher = aEADBlockCipher;
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.cipher.processAADBytes(byArray, n, n2);
            }

            public void write(int n) throws IOException {
                this.cipher.processAADByte((byte)n);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class OutEncryptor
        extends FipsOutputAEADEncryptor<AuthParameters> {
            private final AuthParameters parameters;
            private final AEADBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey validatedSymmetricKey, AuthParameters authParameters) {
                this.parameters = authParameters;
                this.cipher = BlockCipherUtils.createAEADCipher(authParameters.getAlgorithm(), ENGINE_PROVIDER);
                if (authParameters.iv == null) {
                    throw new IllegalArgumentException("AEAD encryption requires an iv/nonce to be provided.");
                }
                this.cipher.init(true, Utils.getAEADParameters(validatedSymmetricKey, authParameters.iv, authParameters.macLenInBits));
            }

            @Override
            public AuthParameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.cipher.getUpdateOutputSize(n);
            }

            @Override
            public UpdateOutputStream getAADStream() {
                return new AADStream(this.cipher);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
                return new CipherOutputStreamImpl(outputStream, this.cipher);
            }

            @Override
            public byte[] getMAC() {
                return this.cipher.getMac();
            }
        }
    }

    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParametersWithIV {
        private final byte[] iv;
        private final int macLenInBits;

        AuthParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null, Utils.getDefaultMacSize(fipsAlgorithm, 128));
        }

        private AuthParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, int n) {
            super(fipsAlgorithm);
            this.iv = byArray;
            this.macLenInBits = n;
        }

        public int getMACSizeInBits() {
            return this.macLenInBits;
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public AuthParameters withIV(byte[] byArray) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(byArray), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(secureRandom, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, secureRandom), this.macLenInBits);
        }

        public AuthParameters withIV(SecureRandom secureRandom, int n) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && this.getAlgorithm().equals(GCM.getAlgorithm())) {
                Utils.validateRandom(secureRandom, GCM.getAlgorithm(), "GCM IV can only be generated by an approved DRGB");
                if (n < 12) {
                    throw new FipsUnapprovedOperationError("GCM IV must be at least 96 bits", GCM.getAlgorithm());
                }
            }
            return new AuthParameters(this.getAlgorithm(), this.getAlgorithm().createIvIfNecessary(n, secureRandom), this.macLenInBits);
        }

        public AuthParameters withMACSize(int n) {
            return new AuthParameters(this.getAlgorithm(), Arrays.clone(this.iv), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    extends FipsEngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new AESFastEngine(), new VariantKatTest<AESFastEngine>(){

                @Override
                public void evaluate(AESFastEngine aESFastEngine) {
                    byte[] byArray = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] byArray2 = Hex.decode("8ea2b7ca516745bfeafc49904b496089");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    aESFastEngine.init(true, keyParameterImpl);
                    aESFastEngine.processBlock(byArray, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    aESFastEngine.init(false, keyParameterImpl);
                    aESFastEngine.processBlock(byArray3, 0, byArray3, 0);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator<SymmetricSecretKey> {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(int n, SecureRandom secureRandom) {
            this(ALGORITHM, n, secureRandom);
        }

        public KeyGenerator(FipsParameters fipsParameters, int n, SecureRandom secureRandom) {
            this(fipsParameters.getAlgorithm(), n, secureRandom);
        }

        private KeyGenerator(FipsAlgorithm fipsAlgorithm, int n, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                Utils.validateKeyGenRandom(secureRandom, n, fipsAlgorithm);
            }
            if (n != 128 && n != 192 && n != 256) {
                throw new IllegalArgumentException("Attempt to create key with invalid key size [" + n + "]: " + fipsAlgorithm.getName());
            }
            this.algorithm = fipsAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        @Override
        public SymmetricSecretKey generateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends FipsKeyWrapOperatorFactory<WrapParameters, SymmetricKey> {
        private Wrapper createWrapper(FipsAlgorithm fipsAlgorithm, boolean bl) {
            SP80038FWrapper sP80038FWrapper;
            switch ((Mode)fipsAlgorithm.basicVariation()) {
                case WRAP: {
                    sP80038FWrapper = new SP80038FWrapEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), bl);
                    break;
                }
                case WRAPPAD: {
                    sP80038FWrapper = new SP80038FWrapWithPaddingEngine((BlockCipher)ENGINE_PROVIDER.createEngine(), bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm passed to FipsAES.KeyWrapOperatorFactory: " + fipsAlgorithm.getName());
                }
            }
            return sP80038FWrapper;
        }

        @Override
        public FipsKeyWrapper<WrapParameters> createKeyWrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, wrapParameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(true, Utils.getKeyParameter(validatedSymmetricKey));
            return new FipsKeyWrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                    try {
                        return wrapper.wrap(byArray, n, n2);
                    }
                    catch (Exception exception) {
                        throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                    }
                }
            };
        }

        @Override
        public FipsKeyUnwrapper<WrapParameters> createKeyUnwrapper(SymmetricKey symmetricKey, final WrapParameters wrapParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, wrapParameters.getAlgorithm());
            final Wrapper wrapper = this.createWrapper(wrapParameters.getAlgorithm(), wrapParameters.useInverse);
            wrapper.init(false, Utils.getKeyParameter(validatedSymmetricKey));
            return new FipsKeyUnwrapper<WrapParameters>(){

                @Override
                public WrapParameters getParameters() {
                    return wrapParameters;
                }

                @Override
                public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                    try {
                        return wrapper.unwrap(byArray, n, n2);
                    }
                    catch (InvalidCipherTextException invalidCipherTextException) {
                        throw new InvalidWrappingException("Unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return FipsAES.makeMAC(authParameters).getMacSize();
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = FipsAES.makeMAC(authParameters);
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, authParameters.getAlgorithm());
            if (authParameters.getIV() != null) {
                mac.init(Utils.getParametersWithIV(validatedSymmetricKey, authParameters.getIV()));
            } else {
                mac.init(Utils.getKeyParameter(validatedSymmetricKey));
            }
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends FipsSymmetricOperatorFactory<Parameters> {
        private final SecureRandom random;

        public OperatorFactory() {
            this(null);
        }

        private OperatorFactory(SecureRandom secureRandom) {
            this.random = secureRandom;
        }

        @Override
        public FipsOutputEncryptor<Parameters> createOutputEncryptor(SymmetricKey symmetricKey, Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters.getAlgorithm());
            return new OutEncryptor(validatedSymmetricKey, parameters, null);
        }

        @Override
        public FipsOutputDecryptor<Parameters> createOutputDecryptor(SymmetricKey symmetricKey, final Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters.getAlgorithm());
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters, this.random);
            return new FipsOutputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public int getMaxOutputSize(int n) {
                    return bufferedBlockCipher.getOutputSize(n);
                }

                @Override
                public int getUpdateOutputSize(int n) {
                    return bufferedBlockCipher.getUpdateOutputSize(n);
                }

                @Override
                public CipherOutputStream getDecryptingStream(OutputStream outputStream) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherOutputStreamImpl(outputStream, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return new CipherOutputStreamImpl(outputStream, bufferedBlockCipher);
                }
            };
        }

        @Override
        public FipsInputDecryptor<Parameters> createInputDecryptor(SymmetricKey symmetricKey, final Parameters parameters) {
            ValidatedSymmetricKey validatedSymmetricKey = FipsAES.validateKey(symmetricKey, parameters.getAlgorithm());
            final BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createStandardCipher(false, validatedSymmetricKey, ENGINE_PROVIDER, parameters, this.random);
            return new FipsInputDecryptor<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public InputStream getDecryptingStream(InputStream inputStream) {
                    if (bufferedBlockCipher.getUnderlyingCipher() instanceof StreamCipher) {
                        return new CipherInputStream(inputStream, (StreamCipher)((Object)bufferedBlockCipher.getUnderlyingCipher()));
                    }
                    return new CipherInputStream(inputStream, bufferedBlockCipher);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class OutEncryptor
        extends FipsOutputEncryptor<Parameters>
        implements OperatorUsingSecureRandom<OutputEncryptor<Parameters>> {
            private final Parameters parameters;
            private final ValidatedSymmetricKey key;
            private final BufferedBlockCipher cipher;

            public OutEncryptor(ValidatedSymmetricKey validatedSymmetricKey, Parameters parameters, SecureRandom secureRandom) {
                this.key = validatedSymmetricKey;
                this.parameters = parameters;
                this.cipher = BlockCipherUtils.createStandardCipher(true, validatedSymmetricKey, ENGINE_PROVIDER, parameters, secureRandom);
            }

            @Override
            public CipherOutputStream getEncryptingStream(OutputStream outputStream) {
                if (this.cipher.getUnderlyingCipher() instanceof StreamCipher) {
                    return new CipherOutputStreamImpl(outputStream, (StreamCipher)((Object)this.cipher.getUnderlyingCipher()));
                }
                return new CipherOutputStreamImpl(outputStream, this.cipher);
            }

            @Override
            public OutputEncryptor<Parameters> withSecureRandom(SecureRandom secureRandom) {
                return new OutEncryptor(this.key, this.parameters, secureRandom);
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getMaxOutputSize(int n) {
                return this.cipher.getOutputSize(n);
            }

            @Override
            public int getUpdateOutputSize(int n) {
                return this.cipher.getUpdateOutputSize(n);
            }
        }
    }

    public static final class Parameters
    extends FipsParameters
    implements ParametersWithIV {
        private final byte[] iv;

        Parameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null);
        }

        private Parameters(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            super(fipsAlgorithm);
            ((Mode)fipsAlgorithm.basicVariation()).checkIv(byArray, 16);
            this.iv = byArray;
        }

        public Parameters withIV(byte[] byArray) {
            return new Parameters(this.getAlgorithm(), Arrays.clone(byArray));
        }

        public Parameters withIV(SecureRandom secureRandom) {
            return new Parameters(this.getAlgorithm(), this.getAlgorithm().createDefaultIvIfNecessary(16, secureRandom));
        }

        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }

    public static final class WrapParameters
    extends FipsParameters {
        private final boolean useInverse;

        WrapParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, false);
        }

        private WrapParameters(FipsAlgorithm fipsAlgorithm, boolean bl) {
            super(fipsAlgorithm);
            this.useInverse = bl;
        }

        public boolean isUsingInverseFunction() {
            return this.useInverse;
        }

        public WrapParameters withUsingInverseFunction(boolean bl) {
            return new WrapParameters(this.getAlgorithm(), bl);
        }
    }
}

