/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.lang.reflect.Constructor;
import javax.crypto.BadPaddingException;

class ClassUtil {
    private static final Constructor aeadBadTagConstructor;
    private static final Constructor vimIDConstructor;

    ClassUtil() {
    }

    private static Constructor findConstructor(Class clazz) {
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Constructor findExceptionConstructor(Class clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Class lookup(String string) {
        try {
            Class<?> clazz = ClassUtil.class.getClassLoader().loadClass(string);
            return clazz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void throwBadTagException(String string) throws BadPaddingException {
        if (aeadBadTagConstructor != null) {
            BadPaddingException badPaddingException = null;
            try {
                badPaddingException = (BadPaddingException)aeadBadTagConstructor.newInstance(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (badPaddingException != null) {
                throw badPaddingException;
            }
        }
        throw new BadPaddingException(string);
    }

    public static String getVIMID() {
        if (vimIDConstructor != null) {
            Object object = null;
            try {
                object = vimIDConstructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                return object.toString();
            }
        }
        return "No VIM ID";
    }

    static {
        Class clazz = ClassUtil.lookup("javax.crypto.AEADBadTagException");
        aeadBadTagConstructor = clazz != null ? ClassUtil.findExceptionConstructor(clazz) : null;
        Class clazz2 = ClassUtil.lookup("java.rmi.dgc.VMID");
        vimIDConstructor = clazz2 != null ? ClassUtil.findConstructor(clazz2) : null;
    }
}

