/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.ECImplicitDomainParameters;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEC;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.EC;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvECPrivateKey;
import org.bouncycastle.jcajce.provider.ProvECPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.provider.X509AlgorithmParameters;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Properties;

class ProvEC
extends AsymmetricAlgorithmProvider {
    private static final AgreementFactory fipsDHFactory = new FipsEC.DHAgreementFactory();
    private static final AgreementFactory fipsMQVFactory = new FipsEC.MQVAgreementFactory();
    private static final SignatureOperatorFactory fipsDsaFactory = new FipsEC.DSAOperatorFactory();
    private static final Map<String, String> generalEcAttributes = new HashMap<String, String>();
    private static final String PREFIX = ProvEC.class.getName() + ".";
    private static SignatureOperatorFactory genDsaFactory;
    private static final PublicKeyConverter<AsymmetricECPublicKey> publicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricECPrivateKey> privateKeyConverter;

    ProvEC() {
    }

    private static SignatureOperatorFactory getGeneralDSAFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (genDsaFactory == null) {
            genDsaFactory = new EC.DSAOperatorFactory();
        }
        return genDsaFactory;
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.EC", PREFIX + "AlgorithmParametersSpi$EC", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECAlgParams();
            }
        });
        final ParametersCreator parametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.DH;
            }
        };
        final ParametersCreator parametersCreator2 = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("ECCDH can only take a UserKeyingMaterialSpec");
                }
                return FipsEC.CDH;
            }
        };
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.EC", PREFIX + "KeyFactorySpi$EC", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyFactory(FipsEC.ALGORITHM);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECDSA", PREFIX + "KeyFactorySpi$ECDSA", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyFactory(FipsEC.DSA);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECDH", PREFIX + "KeyFactorySpi$ECDH", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyFactory(FipsEC.DH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECCDH", PREFIX + "KeyFactorySpi$ECCDH", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyFactory(FipsEC.CDH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.ECMQV", PREFIX + "KeyFactorySpi$ECMQV", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyFactory(FipsEC.MQV);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.EC", PREFIX + "KeyPairGeneratorSpi$EC", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.ALGORITHM);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECDSA", PREFIX + "KeyPairGeneratorSpi$ECDSA", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.DSA);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECDH", PREFIX + "KeyPairGeneratorSpi$ECDH", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.DH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECCDH", PREFIX + "KeyPairGeneratorSpi$ECCDH", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.CDH);
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.ECMQV", PREFIX + "KeyPairGeneratorSpi$ECMQV", new EngineCreator(){

            public Object createInstance(Object object) {
                return new ECKeyPairGenerator(bouncyCastleFipsProvider, FipsEC.MQV);
            }
        });
        this.registerOid(bouncyCastleFipsProvider, X9ObjectIdentifiers.id_ecPublicKey, "EC", new ECKeyFactory(FipsEC.DSA.getAlgorithm()));
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECDH", PREFIX + "KeyAgreementSpi$DH", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator);
            }
        });
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECCDH", PREFIX + "KeyAgreementSpi$CDH", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator2);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyAgreement.ECDHC", "ECCDH");
        ECKeyFactory eCKeyFactory = new ECKeyFactory(FipsEC.DH);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_stdDH_sha224kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_stdDH_sha256kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_stdDH_sha384kdf_scheme, eCKeyFactory, parametersCreator);
        this.addDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_stdDH_sha512kdf_scheme, eCKeyFactory, parametersCreator);
        eCKeyFactory = new ECKeyFactory(FipsEC.CDH);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.dhSinglePass_cofactorDH_sha1kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha224kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha256kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha384kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.dhSinglePass_cofactorDH_sha512kdf_scheme, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, eCKeyFactory, parametersCreator2);
        this.addCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, eCKeyFactory, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, parametersCreator2);
        this.addConcatCDHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, parametersCreator2);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.NONEWITHECDSA", PREFIX + "SignatureSpi$ecDSAwithNONE", generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(null));
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "NONEWITHECDSA", "RAWECDSA");
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA1WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA224WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA256WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA384WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA384", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(224)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_224", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
                }
            }));
            bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.SHA512(256)WITHECDDSA", PREFIX + "SignatureSpi$ecDetDSA512_256", generalEcAttributes, (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DDSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
                }
            }));
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.ECDDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.DETECDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA1WITHDETECDSA", "SHA1WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA224WITHDETECDSA", "SHA224WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA256WITHDETECDSA", "SHA256WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA384WITHDETECDSA", "SHA384WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512WITHDETECDSA", "SHA512WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512(224)WITHDETECDSA", "SHA512(224)WITHECDDSA");
            bouncyCastleFipsProvider.addAlias("Alg.Alias.Signature.SHA512(256)WITHDETECDSA", "SHA512(256)WITHECDDSA");
        }
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA1", "ECDSA", PREFIX + "SignatureSpi$ecDSA1", X9ObjectIdentifiers.ecdsa_with_SHA1, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA1));
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHECDSA", "ECDSA");
        bouncyCastleFipsProvider.addAlias("Signature", "SHA1WITHECDSA", TeleTrusTObjectIdentifiers.ecSignWithSha1);
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA224", "ECDSA", PREFIX + "SignatureSpi$ecDSA224", X9ObjectIdentifiers.ecdsa_with_SHA224, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA256", "ECDSA", PREFIX + "SignatureSpi$ecDSA256", X9ObjectIdentifiers.ecdsa_with_SHA256, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA256));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA384", "ECDSA", PREFIX + "SignatureSpi$ecDSA384", X9ObjectIdentifiers.ecdsa_with_SHA384, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA384));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512", "ECDSA", PREFIX + "SignatureSpi$ecDSA512", X9ObjectIdentifiers.ecdsa_with_SHA512, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_224", null, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_224));
            }
        });
        this.addSignatureAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", "ECDSA", PREFIX + "SignatureSpi$ecDSA512_256", null, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSignature(bouncyCastleFipsProvider, fipsDsaFactory, publicKeyConverter, privateKeyConverter, FipsEC.DSA.withDigestAlgorithm(FipsSHS.Algorithm.SHA512_256));
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.addSignatureAlgorithm(bouncyCastleFipsProvider, "RIPEMD160", "ECDSA", PREFIX + "SignatureSpi$ecDSARipeMD160", TeleTrusTObjectIdentifiers.ecSignWithRipemd160, generalEcAttributes, new GuardedEngineCreator(new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSignature(bouncyCastleFipsProvider, ProvEC.getGeneralDSAFactory(), publicKeyConverter, privateKeyConverter, EC.DSA.withDigestAlgorithm(SecureHash.Algorithm.RIPEMD160));
                }
            }));
        }
        if (!Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv")) {
            eCKeyFactory = new ECKeyFactory(FipsEC.MQV.getAlgorithm());
            final ParametersCreator parametersCreator3 = new ParametersCreator(){

                public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                    try {
                        if (!(algorithmParameterSpec instanceof MQVParameterSpec)) {
                            throw new InvalidAlgorithmParameterException("ECMQV can only take an MQVParameterSpec");
                        }
                        MQVParameterSpec mQVParameterSpec = (MQVParameterSpec)algorithmParameterSpec;
                        if (mQVParameterSpec.getEphemeralPublicKey() != null) {
                            return FipsEC.MQV.using((AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPublicKey()), (AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
                        }
                        return FipsEC.MQV.using((AsymmetricECPrivateKey)privateKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), (AsymmetricECPublicKey)publicKeyConverter.convertKey(FipsEC.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + invalidKeyException.getMessage(), invalidKeyException);
                    }
                }
            };
            this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "ECMQV", PREFIX + "KeyAgreementSpi$ECMQV", generalEcAttributes, new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, parametersCreator3);
                }
            });
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, SECObjectIdentifiers.mqvSinglePass_sha224kdf_scheme, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, SECObjectIdentifiers.mqvSinglePass_sha256kdf_scheme, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, SECObjectIdentifiers.mqvSinglePass_sha384kdf_scheme, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, SECObjectIdentifiers.mqvSinglePass_sha512kdf_scheme, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, null, eCKeyFactory, parametersCreator3);
            this.addMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, null, eCKeyFactory, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224, parametersCreator3);
            this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256, parametersCreator3);
        }
    }

    private void addDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECDHWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "ECDH", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "ECCDH", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addConcatCDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECCDHWITH" + string + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter, final ParametersCreator parametersCreator) {
        String string2 = "ECMQVWITH" + string + "KDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("KeyAgreement", string2, aSN1ObjectIdentifier);
            this.registerOid(bouncyCastleFipsProvider, aSN1ObjectIdentifier, "EC", asymmetricKeyInfoConverter);
            bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "EC", aSN1ObjectIdentifier);
        }
    }

    private void addConcatMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF, final ParametersCreator parametersCreator) {
        String string2 = "ECMQVWITH" + string + "CKDF";
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, string2, PREFIX + "KeyAgreementSpi$" + string2, generalEcAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private static ECDomainParameters getDomainParametersFromGenSpec(ECGenParameterSpec eCGenParameterSpec) {
        NamedECDomainParameters namedECDomainParameters;
        String string = eCGenParameterSpec.getName();
        try {
            if (string.charAt(0) >= '0' && string.charAt(0) <= '2') {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters(aSN1ObjectIdentifier);
            } else if (string.indexOf(32) > 0) {
                string = string.substring(string.indexOf(32) + 1);
                namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
            } else {
                namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            namedECDomainParameters = ProvEC.getNamedECDomainParametersFromName(string);
        }
        return namedECDomainParameters;
    }

    private static NamedECDomainParameters getNamedECDomainParametersFromName(final String string) {
        return ECDomainParametersIndex.lookupDomainParameters(new ECDomainParametersID(){

            public String getCurveName() {
                return string;
            }
        });
    }

    static {
        generalEcAttributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        generalEcAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        publicKeyConverter = new PublicKeyConverter<AsymmetricECPublicKey>(){

            @Override
            public AsymmetricECPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ECPublicKey) {
                    if (publicKey instanceof ProvECPublicKey) {
                        return ((ProvECPublicKey)publicKey).getBaseKey();
                    }
                    return new ProvECPublicKey(algorithm, (ECPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricECPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EC public key: " + exception.getMessage(), exception);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricECPrivateKey>(){

            @Override
            public AsymmetricECPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ECPrivateKey) {
                    if (privateKey instanceof ProvECPrivateKey) {
                        return ((ProvECPrivateKey)privateKey).getBaseKey();
                    }
                    return new ProvECPrivateKey(algorithm, (ECPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricECPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify EC private key: " + exception.getMessage(), exception);
                }
            }
        };
    }

    static class ECAlgParams
    extends X509AlgorithmParameters {
        private ECDomainParameters domainParameters = ECDomainParametersIndex.lookupDomainParameters(SECObjectIdentifiers.secp521r1);

        ECAlgParams() {
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (ECParameterSpec.class.isAssignableFrom(clazz) || clazz == AlgorithmParameterSpec.class) {
                return ECUtil.convertToSpec(this.domainParameters);
            }
            if (ECGenParameterSpec.class.isAssignableFrom(clazz)) {
                if (this.domainParameters instanceof NamedECDomainParameters) {
                    return new ECGenParameterSpec(((NamedECDomainParameters)this.domainParameters).getID().getId());
                }
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECDomainParametersIndex.lookupOID(this.domainParameters);
                if (aSN1ObjectIdentifier != null) {
                    return new ECGenParameterSpec(aSN1ObjectIdentifier.getId());
                }
                throw new InvalidParameterSpecException("Cannot identify curve in AlgorithmParameters by name");
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
                this.domainParameters = ProvEC.getDomainParametersFromGenSpec(eCGenParameterSpec);
                if (this.domainParameters == null) {
                    throw new InvalidParameterSpecException("EC AlgorithmParameters cannot recognize curve " + eCGenParameterSpec.getName());
                }
            } else if (algorithmParameterSpec instanceof ECDomainParameterSpec) {
                this.domainParameters = ((ECDomainParameterSpec)algorithmParameterSpec).getDomainParameters();
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                this.domainParameters = ECUtil.convertFromSpec((ECParameterSpec)algorithmParameterSpec);
            } else {
                throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
            }
        }

        protected void localInit(byte[] byArray) throws IOException {
            this.domainParameters = ECAlgParams.decodeCurveParameters(byArray);
        }

        protected byte[] localGetEncoded() throws IOException {
            X962Parameters x962Parameters;
            if (this.domainParameters instanceof NamedECDomainParameters) {
                x962Parameters = new X962Parameters(((NamedECDomainParameters)this.domainParameters).getID());
            } else if (this.domainParameters instanceof ECImplicitDomainParameters) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                X9ECParameters x9ECParameters = new X9ECParameters(this.domainParameters.getCurve(), this.domainParameters.getG(), this.domainParameters.getN(), this.domainParameters.getH(), this.domainParameters.getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters.getEncoded();
        }

        private static ECDomainParameters decodeCurveParameters(byte[] byArray) throws IOException {
            X962Parameters x962Parameters = X962Parameters.getInstance(byArray);
            if (x962Parameters.isNamedCurve()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
                return ECDomainParametersIndex.lookupDomainParameters(aSN1ObjectIdentifier);
            }
            if (!x962Parameters.isImplicitlyCA()) {
                X9ECParameters x9ECParameters = X9ECParameters.getInstance(x962Parameters.getParameters());
                return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
            }
            ECDomainParameters eCDomainParameters = (ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA);
            if (eCDomainParameters == null) {
                throw new IOException("Encoding indicates implicitlyCA but CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA) returns null");
            }
            return new ECImplicitDomainParameters(eCDomainParameters);
        }

        protected String engineToString() {
            return "EC AlgorithmParameters " + this.domainParameters;
        }
    }

    static class ECKeyFactory
    extends BaseKeyFactory
    implements AsymmetricKeyInfoConverter {
        private final Algorithm algorithm;

        ECKeyFactory(Algorithm algorithm) {
            this.algorithm = algorithm;
        }

        ECKeyFactory(Parameters parameters) {
            this.algorithm = parameters.getAlgorithm();
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvECPublicKey((AsymmetricECPublicKey)publicKeyConverter.convertKey(this.algorithm, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvECPrivateKey((AsymmetricECPrivateKey)privateKeyConverter.convertKey(this.algorithm, (PrivateKey)key));
            }
            throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
        }

        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            ECPrivateKey eCPrivateKey;
            if (clazz.isAssignableFrom(ECPublicKeySpec.class) && key instanceof ECPublicKey) {
                ECPublicKey eCPublicKey = (ECPublicKey)key;
                if (eCPublicKey.getParams() != null) {
                    return new ECPublicKeySpec(eCPublicKey.getW(), eCPublicKey.getParams());
                }
            } else if (clazz.isAssignableFrom(ECPrivateKeySpec.class) && key instanceof ECPrivateKey && (eCPrivateKey = (ECPrivateKey)key).getParams() != null) {
                return new ECPrivateKeySpec(eCPrivateKey.getS(), eCPrivateKey.getParams());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPrivateKeySpec) {
                try {
                    return new ProvECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidKeySpecException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECPublicKeySpec) {
                try {
                    return new ProvECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidKeySpecException(illegalArgumentException.getMessage(), illegalArgumentException);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvECPrivateKey(new AsymmetricECPrivateKey(this.algorithm, privateKeyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvECPublicKey(new AsymmetricECPublicKey(this.algorithm, subjectPublicKeyInfo));
        }
    }

    static class ECKeyPairGenerator
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm algorithmType;
        private final Parameters parameters;
        private AsymmetricKeyPairGenerator engine;
        private int strength = 224;
        private boolean initialised = false;
        private static Hashtable ecParameters = new Hashtable();

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm algorithm) {
            this(bouncyCastleFipsProvider, algorithm, null);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters parameters) {
            this(bouncyCastleFipsProvider, parameters.getAlgorithm(), parameters);
        }

        public ECKeyPairGenerator(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm algorithm, Parameters parameters) {
            super(algorithm.getName());
            this.fipsProvider = bouncyCastleFipsProvider;
            this.algorithmType = algorithm;
            this.parameters = parameters;
        }

        public void initialize(int n) {
            this.initialize(n, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(n));
            if (eCGenParameterSpec != null) {
                try {
                    this.initialize(eCGenParameterSpec, secureRandom);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("Key size " + n + " bits not available");
            }
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            ECDomainParameters eCDomainParameters;
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCDomainParameters = ECUtil.convertFromSpec((ECParameterSpec)algorithmParameterSpec);
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                eCDomainParameters = ProvEC.getDomainParametersFromGenSpec((ECGenParameterSpec)algorithmParameterSpec);
            } else if (algorithmParameterSpec == null) {
                eCDomainParameters = new ECImplicitDomainParameters((ECDomainParameters)CryptoServicesRegistrar.getProperty(CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA));
                if (eCDomainParameters == null) {
                    throw new InvalidAlgorithmParameterException("null AlgorithmParameterSpec passed but no implicit CA set");
                }
            } else {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            this.engine = this.algorithmType instanceof FipsAlgorithm ? (this.parameters != null ? (this.parameters instanceof FipsEC.DSAParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.DSAParameters)this.parameters, eCDomainParameters), secureRandom) : (this.parameters instanceof FipsEC.AgreementParameters ? new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.AgreementParameters)this.parameters, eCDomainParameters), secureRandom) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters((FipsEC.MQVAgreementParametersBuilder)this.parameters, eCDomainParameters), secureRandom))) : new FipsEC.KeyPairGenerator(new FipsEC.KeyGenParameters(eCDomainParameters), secureRandom)) : (this.parameters != null ? new EC.KeyPairGenerator(new EC.KeyGenParameters((EC.DSAParameters)this.parameters, eCDomainParameters), secureRandom) : new EC.KeyPairGenerator(new EC.KeyGenParameters(eCDomainParameters), secureRandom));
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, this.fipsProvider.getDefaultSecureRandom());
            }
            AsymmetricKeyPair asymmetricKeyPair = this.engine.generateKeyPair();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey();
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey();
            return new KeyPair(new ProvECPublicKey(asymmetricECPublicKey), new ProvECPrivateKey(asymmetricECPrivateKey));
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }
    }
}

