/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMSIVModeCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

public class AESNativeGCMSIV
implements GCMSIVModeCipher {
    private GCMSIVRefWrapper refWrapper;
    private byte[] keptMac;
    private GCMSIVCache theEncData = new GCMSIVCache();
    private boolean forEncryption;
    private byte[] theInitialAEAD;
    private byte[] theNonce;
    private byte[] lastKey;

    @Override
    public BlockCipher getUnderlyingCipher() {
        MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
        if (this.lastKey != null) {
            multiBlockCipher.init(true, new KeyParameter(this.lastKey));
        }
        return multiBlockCipher;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        byte[] byArray;
        this.forEncryption = bl;
        this.keptMac = null;
        this.theEncData.reset();
        byte[] byArray2 = null;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            byArray2 = aEADParameters.getAssociatedText();
            byArray = aEADParameters.getNonce();
            keyParameter = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray = parametersWithIV.getIV();
            keyParameter = (KeyParameter)parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
        }
        this.theInitialAEAD = byArray2;
        this.theNonce = byArray;
        this.lastKey = keyParameter.getKey();
        switch (this.lastKey.length) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalStateException("key must be only 16, 24 or 32 bytes long");
            }
        }
        this.initRef();
        AESNativeGCMSIV.initNative(this.refWrapper.getReference(), bl, this.lastKey, this.theNonce, this.theInitialAEAD);
    }

    private void initRef() {
        this.refWrapper = new GCMSIVRefWrapper(AESNativeGCMSIV.makeInstance());
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM-SIV";
    }

    @Override
    public void processAADByte(byte by) {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        AESNativeGCMSIV.processAADByte(this.refWrapper.getReference(), by);
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        AESNativeGCMSIV.processAADBytes(this.refWrapper.getReference(), byArray, n, n2);
    }

    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        this.theEncData.write(by);
        return 0;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        this.theEncData.write(byArray, n, n2);
        return 0;
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        int n2 = AESNativeGCMSIV.doFinal(this.refWrapper.getReference(), this.theEncData.getBuffer(), this.theEncData.size(), byArray, n);
        this.keptMac = this.getMac();
        this.reset();
        return n2;
    }

    @Override
    public byte[] getMac() {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        if (this.keptMac != null) {
            return Arrays.clone(this.keptMac);
        }
        return AESNativeGCMSIV.getMac(this.refWrapper.getReference());
    }

    @Override
    public int getUpdateOutputSize(int n) {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        return AESNativeGCMSIV.getUpdateOutputSize(this.refWrapper.getReference(), n, this.theEncData.size());
    }

    @Override
    public int getOutputSize(int n) {
        if (this.refWrapper == null) {
            throw new IllegalStateException("GCM-SIV is uninitialized");
        }
        return AESNativeGCMSIV.getOutputSize(this.refWrapper.getReference(), n);
    }

    @Override
    public void reset() {
        this.theEncData.clearBuffer();
        if (this.refWrapper == null) {
            return;
        }
        this.reset(this.refWrapper.getReference());
    }

    public String toString() {
        if (this.lastKey != null) {
            return "GCMSIV[Native](AES[Native](" + this.lastKey.length * 8 + "))";
        }
        return "GCMSIV[Native](AES[Native](not initialized))";
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5);

    static native long makeInstance();

    static native void dispose(long var0);

    static native void processAADByte(long var0, byte var2);

    static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3, byte[] var4, int var5);

    static native int getUpdateOutputSize(long var0, int var2, int var3);

    static native int getOutputSize(long var0, int var2);

    static native byte[] getMac(long var0);

    static native void test_set_max_dl(long var0, long var2);

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeGCMSIV.dispose(l);
        }
    }

    private static class GCMSIVCache
    extends ByteArrayOutputStream {
        GCMSIVCache() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        void clearBuffer() {
            Arrays.fill(this.getBuffer(), (byte)0);
            this.reset();
        }
    }

    private static class GCMSIVRefWrapper
    extends NativeReference {
        public GCMSIVRefWrapper(long l) {
            super(l, "GCM-SIV");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

