/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.Token;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinkedInImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -6141448721085510813L;
    private static final String REQUEST_TOKEN_URL = "https://api.linkedin.com/uas/oauth/requestToken";
    private static final String AUTHORIZATION_URL = "https://api.linkedin.com/uas/oauth/authenticate";
    private static final String ACCESS_TOKEN_URL = "https://api.linkedin.com/uas/oauth/accessToken";
    private static final String CONNECTION_URL = "http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)";
    private static final String UPDATE_STATUS_URL = "http://api.linkedin.com/v1/people/~/shares";
    private static final String PROFILE_URL = "http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,location:(name))";
    private static final String STATUS_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><share><comment>%1$s</comment><visibility><code>anyone</code></visibility></share>";
    private static final String PROPERTY_DOMAIN = "api.linkedin.com";
    private final Log LOG = LogFactory.getLog(LinkedInImpl.class);
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private Token requestToken;
    private Token accessToken;
    private OAuthConsumer oauth;
    private OAuthConfig config;

    public LinkedInImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("api.linkedin.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("api.linkedin.com.consumer_key value is null");
        }
        this.oauth = new OAuthConsumer(this.config);
    }

    @Override
    public String getLoginRedirectURL(String returnTo) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.LOG.debug((Object)"Call to fetch Request Token");
        this.requestToken = this.oauth.getRequestToken(REQUEST_TOKEN_URL, returnTo);
        StringBuilder urlBuffer = this.oauth.buildAuthUrl(AUTHORIZATION_URL, this.requestToken, returnTo);
        this.LOG.info((Object)("Redirection to following URL should happen : " + urlBuffer.toString()));
        return urlBuffer.toString();
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (this.requestToken == null) {
            throw new SocialAuthException("Request token is null");
        }
        String verifier = request.getParameter("oauth_verifier");
        if (verifier != null) {
            this.requestToken.setAttribute("oauth_verifier", verifier);
        }
        this.LOG.debug((Object)"Call to fetch Access Token");
        this.accessToken = this.oauth.getAccessToken(ACCESS_TOKEN_URL, this.requestToken);
        this.isVerify = true;
        return this.getUserProfile();
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        this.LOG.info((Object)"Fetching contacts from http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)");
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(CONNECTION_URL, null, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)", ie);
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the profile from response.http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)", e);
        }
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        if (root != null) {
            NodeList pList = root.getElementsByTagName("person");
            if (pList != null && pList.getLength() > 0) {
                this.LOG.debug((Object)("Found contacts : " + pList.getLength()));
                for (int i = 0; i < pList.getLength(); ++i) {
                    Element p = (Element)pList.item(i);
                    String fname = XMLParseUtil.getElementData(p, "first-name");
                    String lname = XMLParseUtil.getElementData(p, "last-name");
                    String id = XMLParseUtil.getElementData(p, "id");
                    String profileUrl = XMLParseUtil.getElementData(p, "public-profile-url");
                    if (id == null) continue;
                    Contact cont = new Contact();
                    if (fname != null) {
                        cont.setFirstName(fname);
                    }
                    if (lname != null) {
                        cont.setLastName(lname);
                    }
                    if (profileUrl != null) {
                        cont.setProfileUrl(profileUrl);
                    }
                    contactList.add(cont);
                }
            } else {
                this.LOG.debug((Object)"No connections were obtained from : http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)");
            }
        }
        return contactList;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        if (msg.length() > 700) {
            throw new ServerDataException("Status cannot be more than 700 characters.");
        }
        this.LOG.info((Object)("Updating status " + msg + " on " + UPDATE_STATUS_URL));
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Type", "text/xml");
        String msgBody = String.format(STATUS_BODY, msg);
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpPost(UPDATE_STATUS_URL, null, headerParams, msgBody, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on http://api.linkedin.com/v1/people/~/shares", ie);
        }
        this.LOG.debug((Object)("Status Updated and return status code is : " + serviceResponse.getStatus()));
    }

    @Override
    public void logout() {
        this.requestToken = null;
        this.accessToken = null;
    }

    private Profile getUserProfile() throws Exception {
        Element root;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(PROFILE_URL, null, this.accessToken);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,location:(name))");
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,location:(name)). Staus :" + serviceResponse.getStatus());
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the profile from response.http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,location:(name))", e);
        }
        if (root != null) {
            Element locationEl;
            String loc;
            NodeList location;
            Element dobel;
            String fname = XMLParseUtil.getElementData(root, "first-name");
            String lname = XMLParseUtil.getElementData(root, "last-name");
            NodeList dob = root.getElementsByTagName("date-of-birth");
            if (dob != null && dob.getLength() > 0 && (dobel = (Element)dob.item(0)) != null) {
                String y = XMLParseUtil.getElementData(dobel, "year");
                String m = XMLParseUtil.getElementData(dobel, "month");
                String d = XMLParseUtil.getElementData(dobel, "day");
                if (m == null) {
                    m = "";
                }
                if (d != null) {
                    m = m + "-" + d;
                }
                if (y != null) {
                    m = m + "-" + y;
                }
                if (m.length() > 0) {
                    profile.setDob(m);
                }
            }
            String picUrl = XMLParseUtil.getElementData(root, "picture-url");
            String id = XMLParseUtil.getElementData(root, "id");
            if (picUrl != null) {
                profile.setProfileImageURL(picUrl);
            }
            if ((location = root.getElementsByTagName("location")) != null && location.getLength() > 0 && (loc = XMLParseUtil.getElementData(locationEl = (Element)location.item(0), "name")) != null) {
                profile.setLocation(loc);
            }
            profile.setFirstName(fname);
            profile.setLastName(lname);
            profile.setValidatedId(id);
            this.LOG.debug((Object)("User Profile :" + profile.toString()));
        }
        return profile;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = this.oauth.httpGet(url, headerParams, this.accessToken);
            }
            catch (Exception ie) {
                throw new SocialAuthException("Error while making request to URL : " + url, ie);
            }
        }
        if (MethodType.PUT.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPut(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        if (MethodType.POST.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPost(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        return response;
    }
}

