/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.Token;
import org.json.JSONArray;
import org.json.JSONObject;

public class TwitterImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 1908393649053616794L;
    private static final String REQUEST_TOKEN_URL = "http://api.twitter.com/oauth/request_token";
    private static final String AUTHORIZATION_URL = "https://api.twitter.com/oauth/authorize";
    private static final String ACCESS_TOKEN_URL = "https://api.twitter.com/oauth/access_token";
    private static final String PROFILE_URL = "http://api.twitter.com/1/users/show.json?screen_name=";
    private static final String CONTACTS_URL = "http://api.twitter.com/1/friends/ids.json?screen_name=%1$s&cursor=-1";
    private static final String LOOKUP_URL = "http://api.twitter.com/1/users/lookup.json?user_id=";
    private static final String UPDATE_STATUS_URL = "http://api.twitter.com/1/statuses/update.json?status=";
    private static final String PROPERTY_DOMAIN = "twitter.com";
    private final Log LOG = LogFactory.getLog(TwitterImpl.class);
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private Token requestToken;
    private Token accessToken;
    private OAuthConfig config;
    private OAuthConsumer oauth;

    public TwitterImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("twitter.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("twitter.com.consumer_key value is null");
        }
        this.oauth = new OAuthConsumer(this.config);
    }

    @Override
    public String getLoginRedirectURL(String returnTo) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.LOG.debug((Object)"Call to fetch Request Token");
        try {
            this.requestToken = this.oauth.getRequestToken(REQUEST_TOKEN_URL, returnTo);
        }
        catch (SocialAuthException ex) {
            String msg = ex.getMessage() + "OR you have not set any scope while registering your application. You will have to select atlest read public profile scope while registering your application";
            throw new SocialAuthException(msg, ex);
        }
        StringBuilder urlBuffer = this.oauth.buildAuthUrl(AUTHORIZATION_URL, this.requestToken, returnTo);
        this.LOG.info((Object)("Redirection to following URL should happen : " + urlBuffer.toString()));
        return urlBuffer.toString();
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (this.requestToken == null) {
            throw new SocialAuthException("Request token is null");
        }
        String verifier = request.getParameter("oauth_verifier");
        if (verifier != null) {
            this.requestToken.setAttribute("oauth_verifier", verifier);
        }
        this.LOG.debug((Object)"Call to fetch Access Token");
        this.accessToken = this.oauth.getAccessToken(ACCESS_TOKEN_URL, this.requestToken);
        this.isVerify = true;
        return this.getUserProfile();
    }

    private Profile getUserProfile() throws Exception {
        String result;
        Profile profile = new Profile();
        String url = PROFILE_URL + this.accessToken.getAttribute("screen_name");
        this.LOG.debug((Object)("Obtaining user profile. Profile URL : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(url, null, this.accessToken);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url + ". Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url);
        }
        try {
            JSONObject pObj = new JSONObject(result);
            if (pObj.has("id_str")) {
                profile.setValidatedId(pObj.getString("id_str"));
            }
            if (pObj.has("name")) {
                profile.setFullName(pObj.getString("name"));
            }
            if (pObj.has("location")) {
                profile.setLocation(pObj.getString("location"));
            }
            if (pObj.has("screen_name")) {
                profile.setDisplayName(pObj.getString("screen_name"));
            }
            if (pObj.has("lang")) {
                profile.setLanguage(pObj.getString("lang"));
            }
            if (pObj.has("profile_image_url")) {
                profile.setProfileImageURL(pObj.getString("profile_image_url"));
            }
            return profile;
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + result);
        }
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updatting status " + msg));
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        String url = UPDATE_STATUS_URL + URLEncoder.encode(msg, "UTF-8");
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpPost(url, null, null, null, this.accessToken);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to update status on " + url, e);
        }
        System.out.println(serviceResponse.getStatus());
        System.out.println(serviceResponse.getResponseBodyAsString("UTF-8"));
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to update status on " + url + ". Staus :" + serviceResponse.getStatus());
        }
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String result;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String url = String.format(CONTACTS_URL, this.accessToken.getAttribute("screen_name"));
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)("Fetching contacts from " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(url, null, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url);
        }
        this.LOG.debug((Object)("User friends ids : " + result));
        try {
            JSONObject jobj = new JSONObject(result);
            if (jobj.has("ids")) {
                int i;
                JSONArray idList = jobj.getJSONArray("ids");
                int flength = idList.length();
                int[] ids = new int[flength];
                for (i = 0; i < idList.length(); ++i) {
                    ids[i] = idList.getInt(i);
                }
                if (flength > 0) {
                    if (flength > 100) {
                        int[] temparr;
                        i = flength / 100;
                        for (int j = 1; j <= i; ++j) {
                            temparr = new int[100];
                            int k = (j - 1) * 100;
                            int c = 0;
                            while (k < j * 100) {
                                temparr[c] = ids[k];
                                ++k;
                                ++c;
                            }
                            plist.addAll(this.lookupUsers(temparr));
                        }
                        if (flength > i * 100) {
                            temparr = new int[flength - i * 100];
                            int k = i * 100;
                            int c = 0;
                            while (k < flength) {
                                temparr[c] = ids[k];
                                ++k;
                                ++c;
                            }
                            plist.addAll(this.lookupUsers(temparr));
                        }
                    } else {
                        plist.addAll(this.lookupUsers(ids));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user friends json : " + result, e);
        }
        return plist;
    }

    private List<Contact> lookupUsers(int[] fids) throws Exception {
        String result;
        StringBuilder strb = new StringBuilder();
        ArrayList<Contact> plist = new ArrayList<Contact>();
        for (int value : fids) {
            if (strb.length() != 0) {
                strb.append(",");
            }
            strb.append(value);
        }
        String url = LOOKUP_URL + strb.toString();
        this.LOG.debug((Object)("Fetching info of following users : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.oauth.httpGet(url, null, this.accessToken);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url);
        }
        this.LOG.debug((Object)("Users info : " + result));
        JSONArray jarr = new JSONArray(result);
        for (int i = 0; i < jarr.length(); ++i) {
            JSONObject jobj = jarr.getJSONObject(i);
            Contact cont = new Contact();
            if (jobj.has("name")) {
                cont.setFirstName(jobj.getString("name"));
            }
            if (jobj.has("screen_name")) {
                cont.setDisplayName(jobj.getString("screen_name"));
                cont.setProfileUrl("http://twitter.com/" + jobj.getString("screen_name"));
            }
            plist.add(cont);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.requestToken = null;
        this.accessToken = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = this.oauth.httpGet(url, headerParams, this.accessToken);
            }
            catch (Exception ie) {
                throw new SocialAuthException("Error while making request to URL : " + url, ie);
            }
        }
        if (MethodType.PUT.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPut(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        if (MethodType.POST.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPost(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        return response;
    }
}

