/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.exception.SignatureException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.Base64;
import org.brickred.socialauth.util.Constants;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;

public class OAuthConsumer
implements Serializable,
Constants {
    private static final long serialVersionUID = -4560115102581632124L;
    private static final Pattern AMPERSAND = Pattern.compile("&");
    private final Log LOG = LogFactory.getLog(OAuthConsumer.class);
    private OAuthConfig config;

    public OAuthConsumer(OAuthConfig config) {
        this.config = config;
    }

    public String generateSignature(String signatureType, String method, String url, Map<String, String> args, AccessGrant token) throws Exception {
        this.LOG.debug((Object)"Generating OAUTH Signature");
        this.LOG.debug((Object)("Given Signature Type : " + signatureType));
        this.LOG.debug((Object)("Given Method Type : " + method));
        this.LOG.debug((Object)("Given URL : " + url));
        this.LOG.debug((Object)("Given Parameters : " + args));
        if ("HMAC-SHA1".equals(signatureType)) {
            return this.getHMACSHA1(method, url, args, token);
        }
        throw new SignatureException("Signature type not implemented :" + signatureType);
    }

    private String getHMACSHA1(String method, String url, Map<String, String> args, AccessGrant token) throws Exception {
        boolean valid;
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SignatureException("Please check consumer secret");
        }
        boolean bl = valid = MethodType.GET.toString().equals(method) || MethodType.PUT.toString().equals(method) || MethodType.POST.toString().equals(method);
        if (!valid) {
            throw new SignatureException("Invalid method type :" + method);
        }
        if (url.length() == 0) {
            throw new SignatureException("Please check URL");
        }
        String key = HttpUtil.encodeURIComponent(this.config.get_consumerSecret()) + "&";
        if (token != null && token.getSecret() != null) {
            key = key + HttpUtil.encodeURIComponent(token.getSecret());
        }
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes("UTF-8"), "HMAC-SHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            String data = HttpUtil.encodeURIComponent(method) + "&" + HttpUtil.encodeURIComponent(url) + "&" + HttpUtil.encodeURIComponent(HttpUtil.buildParams(args));
            this.LOG.debug((Object)("Signature data : " + data));
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            this.LOG.debug((Object)"Encoding raw HMAC to Base64");
            String sig = Base64.encodeBytes(rawHmac);
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException("Unable to generate HMAC-SHA1", e);
        }
    }

    public AccessGrant getRequestToken(String reqTokenURL, String callbackURL) throws Exception {
        this.LOG.debug((Object)"Preparing to get Request Token");
        this.LOG.debug((Object)("Given Request Token URL : " + reqTokenURL));
        this.LOG.debug((Object)("Given CallBack URL : " + callbackURL));
        AccessGrant token = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oauth_callback", callbackURL);
        this.putOauthParams(params);
        String reqURL = reqTokenURL;
        String sig = this.generateSignature(this.config.get_signatureMethod(), this.config.get_transportName(), reqURL, params, null);
        this.LOG.debug((Object)(this.config.get_signatureMethod() + " Signature for request token : " + sig));
        params.put("oauth_signature", sig);
        reqURL = reqURL + "?" + HttpUtil.buildParams(params);
        this.LOG.debug((Object)("URL to get Request Token : " + reqURL));
        Response response = HttpUtil.doHttpRequest(reqURL, this.config.get_transportName(), null, null);
        if (response.getStatus() != 200) {
            this.LOG.debug((Object)"Error while fetching Request Token");
            throw new SocialAuthConfigurationException("Application keys are not correct. The server running the application should be same that was registered to get the keys.");
        }
        token = new AccessGrant();
        this.parse(response.getInputStream(), token);
        return token;
    }

    public AccessGrant getAccessToken(String accessTokenURL, AccessGrant reqToken) throws Exception {
        this.LOG.debug((Object)"Preparing to get Access Token");
        this.LOG.debug((Object)("Given Access Token URL : " + accessTokenURL));
        this.LOG.debug((Object)("Given Request Token : " + reqToken.toString()));
        if (reqToken.getKey() == null || reqToken.getKey().length() == 0) {
            throw new SocialAuthException("Key in Request Token is null or blank");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        AccessGrant accessToken = null;
        if (reqToken.getAttribute("oauth_verifier") != null) {
            params.put("oauth_verifier", reqToken.getAttribute("oauth_verifier").toString());
        }
        params.put("oauth_token", reqToken.getKey());
        this.putOauthParams(params);
        String reqURL = accessTokenURL;
        String sig = this.generateSignature(this.config.get_signatureMethod(), this.config.get_transportName(), reqURL, params, reqToken);
        this.LOG.debug((Object)(this.config.get_signatureMethod() + " Signature for access token : " + sig));
        params.put("oauth_signature", sig);
        String body = null;
        if (MethodType.GET.toString().equals(this.config.get_transportName())) {
            reqURL = reqURL + "?" + HttpUtil.buildParams(params);
        } else {
            body = HttpUtil.buildParams(params);
        }
        this.LOG.debug((Object)("Access Token URL : " + reqURL));
        Response response = null;
        try {
            response = HttpUtil.doHttpRequest(reqURL, this.config.get_transportName(), body, null);
        }
        catch (Exception e) {
            this.LOG.debug((Object)"Error while getting Access Token");
            throw new SocialAuthException("Error while getting Access Token", e);
        }
        if (response.getStatus() != 200) {
            throw new SocialAuthException("Unable to retrieve the access token. Status: " + response.getStatus());
        }
        accessToken = new AccessGrant();
        this.parse(response.getInputStream(), accessToken);
        return accessToken;
    }

    private void putOauthParams(Map<String, String> params) {
        params.put("oauth_consumer_key", this.config.get_consumerKey());
        params.put("oauth_signature_method", this.config.get_signatureMethod());
        params.put("oauth_version", "1.0");
        this.putNonceAndTimestamp(params);
    }

    public Response httpGet(String reqURL, Map<String, String> headerParams, AccessGrant token) throws Exception {
        return this.send(reqURL, null, headerParams, null, MethodType.GET.toString(), token, true);
    }

    public Response httpPost(String reqURL, Map<String, String> params, Map<String, String> headerParams, String body, AccessGrant token) throws Exception {
        return this.send(reqURL, params, headerParams, body, MethodType.POST.toString(), token, true);
    }

    public Response httpPut(String reqURL, Map<String, String> params, Map<String, String> headerParams, String body, AccessGrant token) throws Exception {
        return this.send(reqURL, params, headerParams, body, MethodType.PUT.toString(), token, true);
    }

    public Response httpPut(String reqURL, Map<String, String> params, Map<String, String> headerParams, String body, AccessGrant token, boolean isHeaderRequired) throws Exception {
        return this.send(reqURL, params, headerParams, body, MethodType.PUT.toString(), token, isHeaderRequired);
    }

    private Response send(String reqURL, Map<String, String> paramsMap, Map<String, String> headerParams, String body, String methodName, AccessGrant token, boolean isHeaderRequired) throws Exception {
        String url;
        Map<String, String> params = paramsMap != null ? paramsMap : new HashMap<String, String>();
        params.put("oauth_token", token.getKey());
        this.putOauthParams(params);
        int idx = reqURL.indexOf(63);
        if (idx != -1) {
            String[] pairs;
            for (String pair : pairs = AMPERSAND.split(reqURL.substring(idx + 1))) {
                int eq = pair.indexOf(61);
                if (eq == -1) {
                    params.put(pair, "");
                    continue;
                }
                params.put(pair.substring(0, eq), HttpUtil.decodeURIComponent(pair.substring(eq + 1)));
            }
            url = reqURL.substring(0, idx);
        } else {
            url = reqURL;
        }
        String sig = this.generateSignature(this.config.get_signatureMethod(), methodName, url, params, token);
        params.put("oauth_signature", sig);
        HashMap<String, String> headerMap = null;
        if (isHeaderRequired) {
            String headerVal = this.getAuthHeaderValue(params);
            headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", headerVal);
            if (headerParams != null) {
                for (String key : headerParams.keySet()) {
                    headerMap.put(key, headerParams.get(key));
                }
            }
            url = reqURL;
        } else {
            url = url + "?" + HttpUtil.buildParams(params);
        }
        return HttpUtil.doHttpRequest(url, methodName, body, headerMap);
    }

    private void parse(InputStream in, AccessGrant token) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to parse response");
        }
        String[] pairs = sb.toString().split("&");
        String key = null;
        String secret = null;
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) continue;
            String k = pair.substring(0, idx);
            String v = HttpUtil.decodeURIComponent(pair.substring(idx + 1));
            if (key == null && "oauth_token".equals(k)) {
                key = v;
                this.LOG.debug((Object)("KEY : " + key));
                continue;
            }
            if (secret == null && "oauth_token_secret".equals(k)) {
                secret = v;
                this.LOG.debug((Object)("SECRET : " + secret));
                continue;
            }
            token.setAttribute(k, v);
        }
        if (key != null && secret != null) {
            token.setKey(key);
            token.setSecret(secret);
        }
    }

    public void putNonceAndTimestamp(Map<String, String> params) {
        long ts = System.currentTimeMillis();
        params.put("oauth_timestamp", String.valueOf(ts / 1000L));
        params.put("oauth_nonce", String.valueOf(ts));
    }

    public StringBuilder buildAuthUrl(String authUrl, AccessGrant token, String callbackUrl) throws Exception {
        char separator = authUrl.indexOf(63) == -1 ? (char)'?' : '&';
        return new StringBuilder().append(authUrl).append(separator).append("oauth_token").append('=').append(HttpUtil.encodeURIComponent(token.getKey())).append('&').append("oauth_callback").append('=').append(callbackUrl == null ? "oob" : HttpUtil.encodeURIComponent(callbackUrl));
    }

    public String getAuthHeaderValue(Map<String, String> params) throws Exception {
        String[] REQUIRED_OAUTH_HEADERS_TO_SIGN;
        this.LOG.debug((Object)("Genrating Authorization header for given parameters : " + params));
        StringBuilder headerStr = new StringBuilder();
        for (String key : REQUIRED_OAUTH_HEADERS_TO_SIGN = new String[]{"oauth_consumer_key", "oauth_nonce", "oauth_timestamp", "oauth_signature_method"}) {
            String value = HttpUtil.encodeURIComponent(params.get(key));
            headerStr.append(',').append(key).append('=').append('\"').append(value).append('\"');
        }
        if (params.get("oauth_version") != null) {
            headerStr.append(',').append("oauth_version").append('=').append('\"').append(HttpUtil.encodeURIComponent(params.get("oauth_version"))).append('\"');
        }
        if (params.get("oauth_token") != null) {
            headerStr.append(',').append("oauth_token").append('=').append('\"').append(HttpUtil.encodeURIComponent(params.get("oauth_token"))).append('\"');
        }
        if (params.get("oauth_signature") != null) {
            headerStr.append(',').append("oauth_signature").append('=').append('\"').append(HttpUtil.encodeURIComponent(params.get("oauth_signature"))).append('\"');
        }
        headerStr.setCharAt(0, ' ');
        headerStr.insert(0, "OAuth");
        this.LOG.debug((Object)("Authorize Header : " + headerStr.toString()));
        return headerStr.toString();
    }
}

