/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationProcessorMojo
extends AbstractMojo {
    protected MavenProject project;
    private List<Artifact> pluginArtifacts;
    private File outputDirectory;
    private String[] processors;
    private String compilerArguments;
    private Map<String, Object> optionMap;
    private Boolean addOutputDirectoryToCompilationSources;
    private Boolean failOnError = true;
    private boolean outputDiagnostics = true;
    private Map<String, String> systemProperties;
    private String[] includes;
    private String[] excludes;
    private ReentrantLock compileLock = new ReentrantLock();

    protected abstract List<File> getSourceDirectories();

    protected abstract File getOutputClassDirectory();

    private String buildProcessor() {
        if (this.processors == null || this.processors.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < this.processors.length - 1; ++i) {
            result.append(this.processors[i]).append(',');
        }
        result.append(this.processors[i]);
        return result.toString();
    }

    protected abstract Set<String> getClasspathElements(Set<String> var1);

    private String buildCompileClasspath() {
        LinkedHashSet<String> pathElements = new LinkedHashSet<String>();
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.pluginArtifacts) {
                File f;
                if (!"compile".equalsIgnoreCase(a.getScope()) && !"runtime".equalsIgnoreCase(a.getScope()) || (f = a.getFile()) == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        this.getClasspathElements(pathElements);
        StringBuilder result = new StringBuilder();
        for (String elem : pathElements) {
            result.append(elem).append(File.pathSeparator);
        }
        return result.toString();
    }

    public void execute() throws MojoExecutionException {
        block3: {
            if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
                return;
            }
            try {
                this.executeWithExceptionsHandled();
            }
            catch (Exception e1) {
                super.getLog().error((CharSequence)("error on execute: " + e1.getMessage()));
                if (!this.failOnError.booleanValue()) break block3;
                throw new MojoExecutionException("Error executing", e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithExceptionsHandled() throws Exception {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getDefaultOutputDirectory();
        }
        this.ensureOutputDirectoryExists();
        this.addOutputToSourcesIfNeeded();
        List<File> sourceDirectories = this.getSourceDirectories();
        for (File sourceDir : sourceDirectories) {
            if (sourceDir == null) {
                this.getLog().warn((CharSequence)"source directory cannot be read (null returned)! Processor task will be skipped");
                return;
            }
            if (!sourceDir.exists()) {
                this.getLog().warn((CharSequence)"source directory doesn't exist! Processor task will be skipped");
                return;
            }
            if (sourceDir.isDirectory()) continue;
            this.getLog().warn((CharSequence)"source directory is invalid! Processor task will be skipped");
            return;
        }
        String includesString = this.includes == null || this.includes.length == 0 ? "**/*.java" : StringUtils.join((Object[])this.includes, (String)",");
        String excludesString = this.excludes == null || this.excludes.length == 0 ? null : StringUtils.join((Object[])this.excludes, (String)",");
        ArrayList files = new ArrayList();
        for (File sourceDir : sourceDirectories) {
            files.addAll(FileUtils.getFiles((File)sourceDir, (String)includesString, (String)excludesString));
        }
        Iterable<? extends JavaFileObject> compilationUnits1 = null;
        String compileClassPath = this.buildCompileClasspath();
        String processor = this.buildProcessor();
        ArrayList<String> options = new ArrayList<String>(10);
        options.add("-cp");
        options.add(compileClassPath);
        options.add("-proc:only");
        this.addCompilerArguments(options);
        if (processor != null) {
            options.add("-processor");
            options.add(processor);
        } else {
            this.getLog().info((CharSequence)"No processors specified. Using default discovery mechanism.");
        }
        options.add("-d");
        options.add(this.getOutputClassDirectory().getPath());
        options.add("-s");
        options.add(this.outputDirectory.getPath());
        DiagnosticListener<JavaFileObject> dl = null;
        if (this.outputDiagnostics) {
            for (String option : options) {
                this.getLog().info((CharSequence)("javac option: " + option));
            }
            dl = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    AbstractAnnotationProcessorMojo.this.getLog().info((CharSequence)("diagnostic " + diagnostic));
                }
            };
        } else {
            dl = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                }
            };
        }
        if (this.systemProperties != null) {
            Set<Map.Entry<String, String>> pSet = this.systemProperties.entrySet();
            for (Map.Entry<String, String> e : pSet) {
                this.getLog().info((CharSequence)String.format("set system property : [%s] = [%s]", e.getKey(), e.getValue()));
                System.setProperty(e.getKey(), e.getValue());
            }
        }
        this.compileLock.lock();
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                this.getLog().error((CharSequence)"JVM is not suitable for processing annotation! ToolProvider.getSystemJavaCompiler() is null.");
                return;
            }
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            if (files == null || files.isEmpty()) {
                this.getLog().warn((CharSequence)"no source file(s) detected! Processor task will be skipped");
                return;
            }
            compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            JavaCompiler.CompilationTask task = compiler.getTask(new PrintWriter(System.out), fileManager, (DiagnosticListener<? super JavaFileObject>)dl, options, null, compilationUnits1);
            if (!task.call().booleanValue()) {
                throw new Exception("error during compilation");
            }
        }
        finally {
            this.compileLock.unlock();
        }
    }

    private void addCompilerArguments(List<String> options) {
        if (!StringUtils.isEmpty((String)this.compilerArguments)) {
            for (String arg : this.compilerArguments.split(" ")) {
                if (StringUtils.isEmpty((String)arg)) continue;
                arg = arg.trim();
                this.getLog().info((CharSequence)("Adding compiler arg: " + arg));
                options.add(arg);
            }
        }
        if (this.optionMap != null && !this.optionMap.isEmpty()) {
            for (Map.Entry<String, Object> e : this.optionMap.entrySet()) {
                if (StringUtils.isEmpty((String)e.getKey()) || e.getValue() == null) continue;
                String opt = String.format("-A%s=%s", e.getKey().trim(), e.getValue().toString().trim());
                options.add(opt);
                this.getLog().info((CharSequence)("Adding compiler arg: " + opt));
            }
        }
    }

    private void addOutputToSourcesIfNeeded() {
        Boolean add = this.addOutputDirectoryToCompilationSources;
        if (add == null || add.booleanValue()) {
            this.getLog().info((CharSequence)("Source directory: " + this.outputDirectory + " added"));
            this.addCompileSourceRoot(this.project, this.outputDirectory.getAbsolutePath());
        }
    }

    protected abstract void addCompileSourceRoot(MavenProject var1, String var2);

    public abstract File getDefaultOutputDirectory();

    private void ensureOutputDirectoryExists() {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!this.getOutputClassDirectory().exists()) {
            this.getOutputClassDirectory().mkdirs();
        }
    }
}

