/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.buni.meldware.mail.util.io.WrappedOutputStream;

public class CountingOutputStream
extends WrappedOutputStream {
    long counter = 0L;

    public CountingOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.counter;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.counter += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.counter += (long)b.length;
    }

    public void resetCounter() {
        this.counter = 0L;
    }

    public long getCounter() {
        return this.counter;
    }
}

