/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4;

import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Request;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class MutableIMAP4Request
implements IMAP4Request,
Request {
    private IMAP4ProtocolInstance protocol;
    private List arguments;
    private String prefix;
    private InputStream stream;
    private AbstractImapCommand command;
    private Socket socket;

    public MutableIMAP4Request(IMAP4ProtocolInstance instance, InputStream stream) {
        this.stream = stream;
        this.protocol = instance;
        this.arguments = new ArrayList(2);
    }

    public AbstractImapCommand getCommand() {
        return this.command;
    }

    public Iterator arguments() {
        return this.arguments.iterator();
    }

    public String[] getArguments() {
        int count = 0;
        if (this.arguments != null) {
            count = this.arguments.size();
        }
        String[] argumentsArray = new String[count];
        if (count > 0) {
            this.arguments.toArray(argumentsArray);
        }
        return argumentsArray;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public String getRemoteAddr() {
        return String.valueOf(this.socket.getInetAddress().getHostName()) + " (" + this.socket.getInetAddress().getHostAddress() + ")";
    }

    public void setCommand(AbstractImapCommand command) {
        this.command = command;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void addArgument(String argument) {
        this.arguments.add(argument);
    }

    public String getTag() {
        return this.prefix;
    }

    public void setTag(String prefix) {
        this.prefix = prefix;
    }
}

