/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.parser;

import antlr.CharStreamException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import java.io.StringReader;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.commands.BadSyntaxCommand;
import org.buni.meldware.mail.imap4.parser.ImapCommandLexer;
import org.buni.meldware.mail.imap4.parser.ImapCommandParser;

public class ImapLineParser {
    private static final Log log = Log.getLog(ImapLineParser.class);

    void lexEatUnknowns(ImapCommandLexer lexer) throws RecognitionException, TokenStreamException {
        try {
            lexer.mUNKNOWN(true);
            lexer.expectingCommand = true;
        }
        catch (CharStreamException cse) {
            RecognitionException re = new RecognitionException(cse.toString());
            re.initCause((Throwable)cse);
            throw re;
        }
    }

    public AbstractImapCommand parseCommand(String line) {
        ImapCommandLexer lexer = new ImapCommandLexer(new StringReader(line));
        ImapCommandParser parser = new ImapCommandParser(lexer);
        try {
            return this.parseCommand(parser, lexer);
        }
        catch (TokenStreamException tokenStreamException) {
            return new BadSyntaxCommand();
        }
    }

    public AbstractImapCommand parseCommand(ImapCommandParser parser, ImapCommandLexer lexer) throws TokenStreamException {
        try {
            try {
                parser.command_line();
            }
            catch (TokenStreamRecognitionException tsre) {
                parser.resetState();
                this.lexEatUnknowns(lexer);
                log.warn("BAD command - class: %s, message: %s", new Object[]{((Object)((Object)tsre)).getClass().getName(), tsre.getMessage()});
                return new BadSyntaxCommand();
            }
            catch (NoViableAltException nvae) {
                parser.unknown();
                log.warn("BAD command - class: %s, message: %s", new Object[]{((Object)((Object)nvae)).getClass().getName(), nvae.getMessage()});
                return new BadSyntaxCommand();
            }
        }
        catch (RecognitionException re) {
            log.warn("BAD command - class: %s, message: %s", new Object[]{((Object)((Object)re)).getClass().getName(), re.getMessage()});
            return new BadSyntaxCommand();
        }
        return parser.getCommand();
    }
}

