/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.buni.meldware.mail.api.FolderFilter;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.api.SearchKey;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.FolderSummary;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.message.Body;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.util.Node;
import org.buni.meldware.mail.util.io.Copier;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.system.ServiceMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MailboxService
extends ServiceMBean {
    public void setBodyManager(MailBodyManager var1);

    public MailBodyManager getBodyManager();

    @Tx(value=TxType.REQUIRED)
    public Mailbox getMailboxById(long var1);

    @Tx(value=TxType.REQUIRED)
    public Mailbox getMailboxByAlias(String var1);

    @Tx(value=TxType.REQUIRED)
    public Folder getDefaultInFolderByAlias(String var1);

    @Tx(value=TxType.REQUIRED)
    public Folder getDefaultOutFolderByAlias(String var1);

    @Tx(value=TxType.REQUIRED)
    public Mailbox createMailbox(String var1);

    public long getMailboxIdByAlias(String var1);

    public boolean createAlias(long var1, String var3);

    public Folder createFolder(Folder var1, String var2);

    public Folder createFolder(Folder var1, String[] var2);

    @Tx(value=TxType.REQUIRED)
    public void deleteMailboxById(long var1);

    @Tx(value=TxType.REQUIRED)
    public void deleteMailboxByAlias(String var1);

    public List<MessageBody> getMessageBody(MessageData var1);

    public List<Body> getMailBody(MessageData var1);

    @Tx(value=TxType.REQUIRED)
    public void createMail(Folder var1, MessageData var2);

    @Tx(value=TxType.REQUIRED)
    public boolean lock(String var1, Folder var2, Date var3);

    @Tx(value=TxType.REQUIRED)
    public boolean commit(String var1);

    @Tx(value=TxType.REQUIRESNEW)
    public void release(String var1, Folder var2);

    @Tx(value=TxType.REQUIRED)
    public int getMailCountForFolder(Folder var1);

    public List<MessageData> getMailListForFolder(Folder var1, boolean var2);

    public List<MessageData> getMessages(Folder var1, Range[] var2, boolean var3);

    public int getNextUid(long var1);

    public int getMaxUid(Folder var1);

    public int[] getUids(Folder var1);

    @Tx(value=TxType.REQUIRED)
    public MessageData getMailAt(Folder var1, int var2);

    public boolean markDeleted(Mailbox var1, int var2);

    public boolean deleteMarked(Mailbox var1);

    public boolean unmarkDeleted(Mailbox var1);

    public Folder getSubfolderByName(Folder var1, String var2);

    public List<Folder> getSubfolders(Folder var1);

    public List<Folder> getSubfolders(Folder var1, String[] var2, FolderFilter var3);

    public int getRecentCountForFolder(Folder var1);

    public long getLikelyUID(Folder var1);

    public void updateMessageMetaData(MessageData var1);

    public void copy(MessageData var1, Folder var2, Folder var3);

    public void copy(long var1, MessageData var3);

    public List<Integer> expunge(Folder var1, boolean var2);

    public int getUnseenCountForFolder(Folder var1);

    public long getFirstUnseen(Folder var1);

    public Node<FolderSummary> folderSummary(String var1);

    public MessageData getMail(long var1);

    public Folder moveFolder(Folder var1, Folder var2, String var3);

    public Folder moveFolder(Folder var1, String[] var2);

    public String getPathFor(Folder var1);

    public void deleteMessage(long var1);

    public void deleteFolder(Folder var1);

    public Folder getSubfolderByPath(Folder var1, String[] var2);

    public void setHacks(String var1);

    public String getHacks();

    public MessageBody getMessageBody(MessageData var1, int var2);

    public MessageBody getMessageBody(MessageBody var1, int var2);

    public void mimePrintMessage(long var1, boolean var3, OutputStream var4, Copier var5);

    public void mimePrintBody(long var1, boolean var3, OutputStream var4, Copier var5);

    public List<String> getAliases(String var1);

    public void deleteAlias(String var1, String var2);

    public Collection<Integer> search(SearchKey var1);

    public Mailbox getPostmasterMailbox();
}

