/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.mailbox;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.TemporalType;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.api.FolderExistsException;
import org.buni.meldware.mail.api.FolderFilter;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.api.SearchKey;
import org.buni.meldware.mail.mailbox.Alias;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.FolderSummary;
import org.buni.meldware.mail.mailbox.Lock;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageBody;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.mailbox.MessageDataUtil;
import org.buni.meldware.mail.message.Body;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.util.HibernateUtil;
import org.buni.meldware.mail.util.Node;
import org.buni.meldware.mail.util.io.Copier;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.system.ServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailboxServiceImpl
extends ServiceMBeanSupport
implements MailboxService,
ServiceMBean,
Advised {
    private Log log = Log.getLog(MailboxServiceImpl.class);
    private static final byte[] ENDL;
    EntityManager session = null;
    MailBodyManager mgr;
    private String hacks;
    private String postmaster = "postmaster";
    private static ClassAdvisor aop$classAdvisor$aop;
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_getMailboxById6413698787834252295;
    private static WeakReference aop$MethodInfo_getMailboxByAlias2156355474417312895;
    private static WeakReference aop$MethodInfo_getDefaultInFolderByAlias8116454652142676286;
    private static WeakReference aop$MethodInfo_getDefaultOutFolderByAlias8130789135759618080;
    private static WeakReference aop$MethodInfo_createMailbox_N_3532434502602607002;
    private static WeakReference aop$MethodInfo_createFolder643777264996518006;
    private static WeakReference aop$MethodInfo_createFolder_N_2955346000199661124;
    private static WeakReference aop$MethodInfo_deleteMailboxById_N_6905472812705909935;
    private static WeakReference aop$MethodInfo_deleteMailboxByAlias_N_8077316256977076706;
    private static WeakReference aop$MethodInfo_getMessageBody3911902284142732;
    private static WeakReference aop$MethodInfo_getMailBody3118972756526648425;
    private static WeakReference aop$MethodInfo_getMailBody_N_3229837591794905632;
    private static WeakReference aop$MethodInfo_createMail_N_6532270537506409086;
    private static WeakReference aop$MethodInfo_lock7737480497464535274;
    private static WeakReference aop$MethodInfo_getNextUid6718418978022606846;
    private static WeakReference aop$MethodInfo_getUids_N_2093903315196796937;
    private static WeakReference aop$MethodInfo_createNewLockForFolder_N_8962902594125124229;
    private static WeakReference aop$MethodInfo_commit6802358189941774990;
    private static WeakReference aop$MethodInfo_release1620172324687511804;
    private static WeakReference aop$MethodInfo_getMailCountForFolder_N_6834197920250729137;
    private static WeakReference aop$MethodInfo_getMaxUid_N_1578105451562726499;
    private static WeakReference aop$MethodInfo_getMailListForFolder4138335292392595736;
    private static WeakReference aop$MethodInfo_getMessages1624378364311083764;
    private static WeakReference aop$MethodInfo_getMailAt_N_6648734355302922923;
    private static WeakReference aop$MethodInfo_markDeleted5934752999000964186;
    private static WeakReference aop$MethodInfo_deleteMarked_N_7319567664623845061;
    private static WeakReference aop$MethodInfo_unmarkDeleted1914944057986980756;
    private static WeakReference aop$MethodInfo_getMailboxIdByAlias_N_4145491549460421805;
    private static WeakReference aop$MethodInfo_createAlias968917090120825244;
    private static WeakReference aop$MethodInfo_getSubfolderByName6112040871602112999;
    private static WeakReference aop$MethodInfo_getSubfolders8285920828106536306;
    private static WeakReference aop$MethodInfo_getSubfolders677140112798081686;
    private static WeakReference aop$MethodInfo_getRecentCountForFolder_N_703713320950335564;
    private static WeakReference aop$MethodInfo_getLikelyUID2299057798449282556;
    private static WeakReference aop$MethodInfo_updateMessageMetaData1812264909449898229;
    private static WeakReference aop$MethodInfo_copy_N_5063802630492799710;
    private static WeakReference aop$MethodInfo_copy_N_5706638977282021959;
    private static WeakReference aop$MethodInfo_folderSummary_N_7462638425403645780;
    private static WeakReference aop$MethodInfo_retSummary9179350348051872086;
    private static WeakReference aop$MethodInfo_expunge5409646354199440601;
    private static WeakReference aop$MethodInfo_getMail_N_68618239099411182;
    private static WeakReference aop$MethodInfo_fastExpunge4919076391455760194;
    private static WeakReference aop$MethodInfo_getCountReferencingBody_N_9154764769953758522;
    private static WeakReference aop$MethodInfo_getUnseenCountForFolder_N_6283046278616930205;
    private static WeakReference aop$MethodInfo_getFirstUnseen_N_5587371301290562644;
    private static WeakReference aop$MethodInfo_moveFolder1391768566440483274;
    private static WeakReference aop$MethodInfo_moveFolder_N_2048023763802867480;
    private static WeakReference aop$MethodInfo_getPathFor_N_8886049787943587193;
    private static WeakReference aop$MethodInfo_deleteMessage_N_9198329699081340556;
    private static WeakReference aop$MethodInfo_deleteFolder_N_7601395062060664724;
    private static WeakReference aop$MethodInfo_getSubfolderByPath_N_8428708415463439975;
    private static WeakReference aop$MethodInfo_getMessageBody_N_9074101858728972783;
    private static WeakReference aop$MethodInfo_getMessageBody_N_6809412181622339899;
    private static WeakReference aop$MethodInfo_mimePrintMessage_N_2211963482245601720;
    private static WeakReference aop$MethodInfo_mimePrintBody3264814303130705280;
    private static WeakReference aop$MethodInfo_printMessage2704115281852340060;
    private static WeakReference aop$MethodInfo_getAliases7896895568457778935;
    private static WeakReference aop$MethodInfo_deleteAlias_N_7340062284907121816;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.mailbox.MailboxServiceImpl"));
        ENDL = new byte[]{13, 10};
    }

    public void emInit() {
        if (this.session == null) {
            this.initEM();
        }
    }

    public synchronized void initEM() {
        if (this.session == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.session = (EntityManager)ctx.lookup("java:/EntityManagers/mail");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Tx(value=TxType.REQUIRED)
    public Mailbox org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxById$aop(long id) {
        this.emInit();
        return (Mailbox)this.session.find(Mailbox.class, (Object)id);
    }

    @Tx(value=TxType.REQUIRED)
    public Mailbox org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxByAlias$aop(String alias) {
        this.emInit();
        String query = "from Mailbox as mbox join fetch mbox.defaultInFolder where mbox.aliases.name=:alias";
        return HibernateUtil.singleResult(this.session.createQuery(query).setParameter("alias", (Object)alias.toLowerCase()), Mailbox.class);
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultInFolderByAlias$aop(String alias) {
        this.emInit();
        return this.getMailboxByAlias(alias).getDefaultInFolder();
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultOutFolderByAlias$aop(String alias) {
        this.emInit();
        return this.getMailboxByAlias(alias).getDefaultOutFolder();
    }

    @Tx(value=TxType.REQUIRED)
    public Mailbox org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMailbox$aop(String alias) {
        this.emInit();
        Mailbox box = this.getMailboxByAlias(alias);
        if (box != null) {
            throw new RuntimeException("You cannot create a SECOND mailbox by that name");
        }
        box = new Mailbox();
        Alias aliasObj = new Alias();
        aliasObj.setName(alias.toLowerCase());
        box.addAlias(aliasObj);
        Folder inbox = new Folder();
        inbox.setName("INBOX");
        inbox.setParent((Folder)box);
        Folder sent = new Folder();
        sent.setName("Sent");
        sent.setParent((Folder)box);
        box.setDefaultInFolder(inbox);
        box.setDefaultOutFolder(sent);
        Folder trash = new Folder();
        trash.setName("Trash");
        trash.setParent((Folder)box);
        Folder draft = new Folder();
        draft.setName("Drafts");
        draft.setParent((Folder)box);
        box.addFolder(inbox);
        box.addFolder(sent);
        box.addFolder(trash);
        box.addFolder(draft);
        this.session.persist((Object)box);
        this.session.persist((Object)inbox);
        this.session.persist((Object)sent);
        this.session.persist((Object)trash);
        this.session.persist((Object)draft);
        this.session.persist((Object)aliasObj);
        return box;
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(Folder xfolder, String foldername) {
        this.emInit();
        Folder folder = (Folder)this.session.find(Folder.class, (Object)xfolder.getId());
        Folder newFolder = new Folder();
        newFolder.setName(foldername);
        folder.addFolder(newFolder);
        newFolder.setParent(folder);
        this.session.persist((Object)newFolder);
        return newFolder;
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(Folder xfolder, String[] path) {
        this.emInit();
        Folder parent = (Folder)this.session.find(Folder.class, (Object)xfolder.getId());
        Folder child = null;
        int i = 0;
        while (i < path.length) {
            child = this.getSubfolderByName(parent, path[i]);
            if (child == null) {
                child = this.createFolder(parent, path[i]);
            } else if (i == path.length - 1) {
                String message = String.format("Folder: %s exists", ArrayUtil.join((Object[])path, (String)"/"));
                throw new FolderExistsException(message);
            }
            parent = child;
            ++i;
        }
        return child;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxById$aop(long id) {
        this.emInit();
        this.session.remove(this.session.find(Mailbox.class, (Object)id));
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxByAlias$aop(String alias) {
        this.emInit();
        this.session.remove((Object)this.getMailboxByAlias(alias));
    }

    @Tx(value=TxType.REQUIRED)
    public List<MessageBody> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(MessageData message) {
        this.emInit();
        MessageData md = (MessageData)this.session.merge((Object)message);
        return md.getMessageBodies();
    }

    @Tx(value=TxType.REQUIRED)
    public List<Body> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(MessageData message) {
        this.emInit();
        List bodies = message.getBodyId();
        ArrayList<Body> retval = new ArrayList<Body>(bodies.size());
        int i = 0;
        while (i < bodies.size()) {
            long bid = (Long)bodies.get(i);
            Body body = bid > -1L ? this.mgr.createMailBody(Long.valueOf(bid)) : null;
            retval.add(body);
            ++i;
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public List<Body> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(List<MessageBody> bodies) {
        this.emInit();
        ArrayList<Body> retval = new ArrayList<Body>(bodies.size());
        int i = 0;
        while (i < bodies.size()) {
            MessageBody body = bodies.get(i);
            long bid = !body.getBodyless() ? body.getBodyId() : -1L;
            Body mailbody = bid > -1L ? this.mgr.createMailBody(Long.valueOf(bid)) : null;
            retval.add(mailbody);
            ++i;
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMail$aop(Folder xfolder, MessageData mail) {
        this.emInit();
        Folder folder = (Folder)this.session.find(Folder.class, (Object)xfolder.getId());
        folder.addMessage(mail);
        mail.setFolder(folder);
        this.session.persist((Object)mail);
    }

    @Tx(value=TxType.REQUIRESNEW)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$lock$aop(String user, Folder folder, Date expiration) {
        Lock lock;
        block3: {
            this.emInit();
            try {
                lock = this.findUnexpiredLock(folder);
                if (lock == null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        lock = this.createNewLockForFolder(user, folder, expiration);
        return true;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getNextUid$aop(long folderId) {
        this.emInit();
        String queryStr = "hsqldb".equals(this.hacks) ? "SELECT nextuid FROM folder_seq WHERE id = :folderId" : "SELECT nextuid FROM folder_seq WHERE id = :folderId FOR UPDATE";
        javax.persistence.Query getQ = this.session.createNativeQuery(queryStr);
        getQ.setParameter("folderId", (Object)new Long(folderId));
        int uid = (Integer)getQ.getSingleResult();
        int nextUid = uid + 1;
        String updateStr = "UPDATE folder_seq SET nextuid = :uid WHERE id = :folderId";
        javax.persistence.Query updateQ = this.session.createNativeQuery(updateStr);
        updateQ.setParameter("uid", (Object)nextUid);
        updateQ.setParameter("folderId", (Object)folderId);
        updateQ.executeUpdate();
        return uid;
    }

    @Tx(value=TxType.REQUIRED)
    public int[] org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUids$aop(Folder folder) {
        this.emInit();
        String query = "SELECT m.id FROM MessageData m WHERE m.folder.id = :folderId ORDER BY m.id";
        javax.persistence.Query q = this.session.createQuery(query);
        q.setParameter("folderId", (Object)folder.getId());
        List results = q.getResultList();
        int[] uids = new int[results.size()];
        int i = 0;
        while (i < results.size()) {
            Long l = (Long)results.get(i);
            uids[i] = l.intValue();
            ++i;
        }
        return uids;
    }

    @Tx(value=TxType.REQUIRED)
    private Lock org$buni$meldware$mail$mailbox$MailboxServiceImpl$createNewLockForFolder$aop(String user, Folder folder, Date expiration) {
        this.emInit();
        Lock lock = new Lock();
        lock.setFolder((Folder)this.session.find(Folder.class, (Object)folder.getId()));
        lock.setExpiration(expiration);
        lock.setThreadId("" + Thread.currentThread().getId());
        lock.setUsername(user);
        this.session.persist((Object)lock);
        return lock;
    }

    private Lock findUnexpiredLock(Folder folder) {
        this.emInit();
        String query = "from Lock lock where lock.folder.id = :folder and lock.expiration > :currentDate";
        List locklist = this.session.createQuery(query).setParameter("folder", (Object)folder.getId()).setParameter("currentDate", new Date(), TemporalType.TIMESTAMP).getResultList();
        if (locklist.size() == 0) {
            return null;
        }
        return (Lock)locklist.get(0);
    }

    private Lock findLockForUser(String username, Folder folder) {
        this.emInit();
        String query = "from Lock lock where lock.folder.id = :folder";
        Lock lock = HibernateUtil.singleResult(this.session.createQuery(query).setParameter("folder", (Object)folder.getId()), Lock.class);
        return lock;
    }

    @Tx(value=TxType.REQUIRED)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$commit$aop(String username) {
        this.emInit();
        try {
            String query = "delete from Lock lock where lock.username = :user";
            this.session.createQuery(query).setParameter("user", (Object)username).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$release$aop(String username, Folder folder) {
        this.emInit();
        try {
            Lock lock = this.findLockForUser(username, folder);
            this.session.remove((Object)lock);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailCountForFolder$aop(Folder folder) {
        this.emInit();
        String query = "select count(m) from MessageData m where m.folder.id = :folder";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        int count = (int)((Long)q.getSingleResult()).longValue();
        return count;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMaxUid$aop(Folder folder) {
        this.emInit();
        String query = "select max(m.id) from MessageData m where m.folder.id = :folder";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        int count = (int)((Long)q.getSingleResult()).longValue();
        return count;
    }

    @Tx(value=TxType.REQUIRED)
    public List<MessageData> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailListForFolder$aop(Folder folder, boolean includeFlags) {
        this.emInit();
        String fetchpart = includeFlags ? "left outer join fetch m.flags " : "";
        fetchpart = String.valueOf(fetchpart) + "left outer join fetch m.bodies ";
        String query = "Select distinct m from MessageData m " + fetchpart + "where m.folder.id = :folder order by m.id";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        List result = q.getResultList();
        return result;
    }

    @Tx(value=TxType.REQUIRED)
    public List<MessageData> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessages$aop(Folder folder, Range[] ranges, boolean includeFlags) {
        this.emInit();
        StringBuilder queryB = new StringBuilder();
        queryB.append("SELECT DISTINCT m ");
        queryB.append("FROM MessageData m ");
        if (includeFlags) {
            queryB.append("LEFT OUTER JOIN FETCH m.flags ");
        }
        queryB.append("WHERE m.folder.id = :folderId ");
        if (ranges.length > 0) {
            queryB.append("AND (");
            int i = 0;
            while (i < ranges.length) {
                queryB.append("(m.id >= :min");
                queryB.append(i);
                queryB.append(" AND ");
                queryB.append("m.id <= :max");
                queryB.append(i);
                queryB.append(")");
                if (i < ranges.length - 1) {
                    queryB.append(" OR ");
                }
                ++i;
            }
            queryB.append(") ");
        }
        queryB.append("ORDER BY m.id");
        javax.persistence.Query query = this.session.createQuery(queryB.toString());
        query.setParameter("folderId", (Object)folder.getId());
        int i = 0;
        while (i < ranges.length) {
            query.setParameter("min" + i, (Object)ranges[i].getMin());
            query.setParameter("max" + i, (Object)ranges[i].getMax());
            ++i;
        }
        List result = query.getResultList();
        return result;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailAt$aop(Folder folder, int id) {
        ScrollableResults res = null;
        try {
            this.emInit();
            MessageData data = null;
            Session hs = ((HibernateSession)this.session).getHibernateSession();
            String query = "from MessageData m where m.folder.id = :folder order by m.id";
            Query q = hs.createQuery(query).setParameter("folder", (Object)folder.getId());
            res = q.scroll(ScrollMode.SCROLL_SENSITIVE);
            res.scroll(id);
            MessageData messageData = data = (MessageData)res.get(0);
            return messageData;
        }
        finally {
            res.close();
        }
    }

    @Override
    public void setBodyManager(MailBodyManager bodymgr) {
        this.mgr = bodymgr;
    }

    @Override
    public MailBodyManager getBodyManager() {
        return this.mgr;
    }

    @Tx(value=TxType.REQUIRED)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$markDeleted$aop(Mailbox mailbox, int i) {
        this.emInit();
        MessageData m = this.getMailAt(mailbox.getDefaultInFolder(), i);
        if (m != null) {
            m.setDeleted(true);
            return true;
        }
        return false;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMarked$aop(Mailbox mailbox) {
        this.emInit();
        Folder folder = mailbox.getDefaultInFolder();
        this.fastExpunge(folder);
        return true;
    }

    @Tx(value=TxType.REQUIRESNEW)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$unmarkDeleted$aop(Mailbox mailbox) {
        this.emInit();
        Folder folder = mailbox.getDefaultInFolder();
        String query = "update MessageData m set m.deleted = false where m.folder.id = :folderid";
        this.session.createQuery(query).setParameter("folderid", (Object)folder.getId()).executeUpdate();
        return true;
    }

    @Tx(value=TxType.REQUIRED)
    public long org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxIdByAlias$aop(String alias) {
        this.emInit();
        String thealias = alias.toLowerCase();
        String query = "select mbox.id from Mailbox mbox where mbox.aliases.name=:alias";
        Long l = HibernateUtil.singleResult(this.session.createQuery(query).setParameter("alias", (Object)thealias), Long.class);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    @Tx(value=TxType.REQUIRED)
    public boolean org$buni$meldware$mail$mailbox$MailboxServiceImpl$createAlias$aop(long id, String aliasName) {
        this.emInit();
        Mailbox m = (Mailbox)this.session.find(Mailbox.class, (Object)id);
        Alias alias = new Alias();
        alias.setName(aliasName.toLowerCase());
        m.addAlias(alias);
        this.session.persist((Object)alias);
        this.session.persist((Object)m);
        return true;
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByName$aop(Folder folder, String name) {
        this.emInit();
        String query = "from Folder f where f.parent.id = :folderid and f.name = :name";
        List result = this.session.createQuery(query).setParameter("folderid", (Object)folder.getId()).setParameter("name", (Object)name).getResultList();
        if (result.size() == 0) {
            return null;
        }
        return (Folder)result.get(0);
    }

    @Tx(value=TxType.REQUIRED)
    public List<Folder> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(Folder folder) {
        this.emInit();
        String query = "from Folder f where f.parent.id = :folderid";
        List result = this.session.createQuery(query).setParameter("folderid", (Object)folder.getId()).getResultList();
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Tx(value=TxType.REQUIRED)
    public List<Folder> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(Folder reference, String[] path, FolderFilter filter) {
        this.emInit();
        ArrayList<Folder> subfolders = new ArrayList<Folder>();
        Folder parent = this.getSubfolderByPath(reference, path);
        this.appendSubfolders(parent, subfolders, filter);
        return subfolders;
    }

    private void appendSubfolders(Folder parent, List<Folder> subfolders, FolderFilter filter) {
        List childFolders = this.getSubfolders(parent);
        if (childFolders != null) {
            for (Folder f : childFolders) {
                if (filter.match(f.getName())) {
                    subfolders.add(f);
                }
                if (!filter.isRecursive()) continue;
                this.appendSubfolders(f, subfolders, filter);
            }
        }
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getRecentCountForFolder$aop(Folder folder) {
        this.emInit();
        String query = "select count(m) from MessageData m where m.recent = true and m.folder.id = :folder";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        int count = (int)((Long)q.getSingleResult()).longValue();
        return count;
    }

    @Tx(value=TxType.REQUIRED)
    public long org$buni$meldware$mail$mailbox$MailboxServiceImpl$getLikelyUID$aop(Folder folder) {
        this.emInit();
        String query = "select max(id) from MessageData m";
        List list = this.session.createQuery(query).getResultList();
        long uid = 0L;
        if (list != null && list.size() > 0 && list.get(0) != null) {
            uid = (Long)list.get(0);
        }
        return uid + 1L;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$updateMessageMetaData$aop(MessageData md) {
        this.emInit();
        this.session.merge((Object)md);
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(MessageData m, Folder source, Folder target) {
        this.emInit();
        MessageData loaded = (MessageData)this.session.find(MessageData.class, (Object)m.getId());
        Folder loadedTarget = (Folder)this.session.find(Folder.class, (Object)target.getId());
        MessageData cloned = new MessageData(loaded);
        cloned.setFolder(loadedTarget);
        this.session.persist((Object)cloned);
        this.saveBodyTree(this.session, cloned);
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(long folderId, MessageData m) {
        this.emInit();
        MessageData loaded = (MessageData)this.session.find(MessageData.class, (Object)m.getId());
        Folder loadedTarget = (Folder)this.session.find(Folder.class, (Object)folderId);
        MessageData cloned = new MessageData(loaded);
        cloned.setFolder(loadedTarget);
        this.session.persist((Object)cloned);
        this.saveBodyTree(this.session, cloned);
    }

    private void saveBodyTree(EntityManager session, MessageData data) {
        List bodies = data.getMessageBodies();
        int i = 0;
        while (i < bodies.size()) {
            this.saveBodyTree(session, (MessageBody)bodies.get(i));
            ++i;
        }
    }

    private void saveBodyTree(EntityManager session, MessageBody body) {
        session.persist((Object)body);
        List bodies = body.getChildren();
        int i = 0;
        while (i < bodies.size()) {
            this.saveBodyTree(session, (MessageBody)bodies.get(i));
            ++i;
        }
    }

    @Tx(value=TxType.REQUIRED)
    public Node<FolderSummary> org$buni$meldware$mail$mailbox$MailboxServiceImpl$folderSummary$aop(String alias) {
        Mailbox mbox = this.getMailboxByAlias(alias);
        FolderSummary fs = new FolderSummary();
        fs.setId(mbox.getId());
        fs.setName(mbox.getName());
        fs.setParentId(-1L);
        Node retval = new Node((Object)fs);
        this.retSummary(retval);
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    private void org$buni$meldware$mail$mailbox$MailboxServiceImpl$retSummary$aop(Node<FolderSummary> parent) {
        long pid = ((FolderSummary)parent.getValue()).getId();
        String qTotal = "select f.id, f.name, f.parent.id, count(m.id) from Folder as f left join f.messages m where f.parent.id = :pid group by f.id, f.name, f.parent.id";
        List rTotal = this.session.createQuery(qTotal).setParameter("pid", (Object)pid).getResultList();
        HashMap<Object, FolderSummary> folders = new HashMap<Object, FolderSummary>();
        for (Object[] row : rTotal) {
            FolderSummary fs = new FolderSummary();
            fs.setId(((Long)row[0]).longValue());
            fs.setName((String)row[1]);
            fs.setParentId(((Long)row[2]).longValue());
            fs.setTotal(((Long)row[3]).longValue());
            folders.put(row[0], fs);
        }
        String qUnread = "select f.id, count(m.id) from Folder as f left join f.messages m with m.seen = false where f.parent.id = :pid group by f.id";
        List rUnread = this.session.createQuery(qUnread).setParameter("pid", (Object)pid).getResultList();
        for (Object[] row : rUnread) {
            FolderSummary fs = (FolderSummary)folders.get(row[0]);
            if (fs == null) continue;
            Node n = new Node((Object)fs);
            parent.addChild(n);
            fs.setUnread(((Long)row[1]).longValue());
            this.retSummary(n);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public List<Integer> org$buni$meldware$mail$mailbox$MailboxServiceImpl$expunge$aop(Folder folder, boolean returnMessages) {
        if (!returnMessages) {
            this.fastExpunge(folder);
            return null;
        }
        List mails = this.getMailListForFolder(folder, true);
        ArrayList<Integer> retval = new ArrayList<Integer>();
        int i = mails.size();
        while (i > 0) {
            int idx = i - 1;
            MessageData mail = (MessageData)mails.get(idx);
            if (mail.isDeleted()) {
                retval.add(i);
                this.session.remove((Object)mail);
                List bodies = mail.getBodyId();
                int x = 0;
                while (x < bodies.size()) {
                    long id = (Long)bodies.get(x);
                    if (this.getCountReferencingBody(id) < 1) {
                        this.mgr.getStore().delete(Long.valueOf(id));
                    }
                    ++x;
                }
            }
            --i;
        }
        return retval;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageData org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMail$aop(long uid) {
        MessageData data = (MessageData)this.session.find(MessageData.class, (Object)uid);
        return data;
    }

    @Tx(value=TxType.REQUIRED)
    private void org$buni$meldware$mail$mailbox$MailboxServiceImpl$fastExpunge$aop(Folder f) {
        this.emInit();
        this.session.createQuery("delete from MessageData m where m.deleted = true and m.folder.id = :folder").setParameter("folder", (Object)f.getId()).executeUpdate();
    }

    @Tx(value=TxType.REQUIRED)
    private int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getCountReferencingBody$aop(long bodyId) {
        String query = "select count(msg) from MessageData msg where msg.bodies.bodyId = :bodyId";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("bodyId", (Object)bodyId);
        int count = (int)((Long)q.getSingleResult()).longValue();
        return count;
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUnseenCountForFolder$aop(Folder folder) {
        this.emInit();
        String query = "select count(m) from MessageData m where m.seen = false and m.folder.id = :folder";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        int count = (int)((Long)q.getSingleResult()).longValue();
        return count;
    }

    @Tx(value=TxType.REQUIRED)
    public long org$buni$meldware$mail$mailbox$MailboxServiceImpl$getFirstUnseen$aop(Folder folder) {
        this.emInit();
        String query = "select min(m.id) from MessageData m where m.seen = false and m.folder.id = :folder";
        javax.persistence.Query q = this.session.createQuery(query).setParameter("folder", (Object)folder.getId());
        long id = (Long)q.getSingleResult();
        return id;
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(Folder folder, Folder target, String name) {
        Folder f = (Folder)this.session.find(Folder.class, (Object)folder.getId());
        Folder t = (Folder)this.session.find(Folder.class, (Object)target.getId());
        f.setName(name);
        if (folder.getId() != t.getId()) {
            f.getParent().getFolders().remove(f);
            t.addFolder(f);
            f.setParent(t);
        }
        this.session.persist((Object)f);
        return f;
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(Folder source, String[] path) {
        this.emInit();
        Folder parent = (Folder)this.session.find(Folder.class, (Object)source.getParent().getId());
        Folder child = null;
        int i = 0;
        while (i < path.length) {
            child = this.getSubfolderByName(parent, path[i]);
            if (i != path.length - 1) {
                if (child == null) {
                    child = this.createFolder(parent, path[i]);
                }
            } else if (child == null) {
                source.setParent(parent);
                source.setName(path[i]);
                this.session.merge((Object)source);
                child = source;
            } else {
                String message = String.format("Folder: %s exists", ArrayUtil.join((Object[])path, (String)"/"));
                throw new FolderExistsException(message);
            }
            parent = child;
            ++i;
        }
        return child;
    }

    @Tx(value=TxType.REQUIRED)
    public String org$buni$meldware$mail$mailbox$MailboxServiceImpl$getPathFor$aop(Folder folder) {
        String result;
        if (folder.getParent() == null) {
            result = "/";
        } else {
            ArrayList<String> pathArr = new ArrayList<String>();
            Folder current = folder;
            while (current.getParent() != null) {
                pathArr.add(0, current.getName());
                current = current.getParent();
            }
            result = ArrayUtil.join(pathArr, (String)"/");
        }
        return result;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMessage$aop(long uid) {
        MessageData data = this.getMail(uid);
        this.session.remove((Object)data);
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteFolder$aop(Folder folder) {
        Folder f = (Folder)this.session.find(Folder.class, (Object)folder.getId());
        f.getParent().getFolders().remove(f);
        this.session.remove((Object)f);
    }

    @Tx(value=TxType.REQUIRED)
    public Folder org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByPath$aop(Folder parent, String[] path) {
        Folder f = parent;
        int i = 0;
        while (i < path.length && f != null) {
            f = this.getSubfolderByName(f, path[i]);
            ++i;
        }
        return f;
    }

    @Override
    public void setHacks(String dbName) {
        this.hacks = dbName;
    }

    @Override
    public String getHacks() {
        return this.hacks;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageBody org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(MessageData message, int position) {
        this.emInit();
        message = (MessageData)this.session.merge((Object)message);
        MessageBody body = null;
        if (position < message.getBody().size()) {
            body = (MessageBody)message.getBody().get(position);
        }
        return body;
    }

    @Tx(value=TxType.REQUIRED)
    public MessageBody org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(MessageBody part, int position) {
        this.emInit();
        part = (MessageBody)this.session.merge((Object)part);
        MessageBody body = null;
        if (position < part.getChildren().size()) {
            body = (MessageBody)part.getChildren().get(position);
        }
        return body;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintMessage$aop(long id, boolean includeHeaders, OutputStream out, Copier copier) {
        this.emInit();
        MessageData message = this.getMail(id);
        MessageDataUtil mdu = new MessageDataUtil(this.getBodyManager());
        try {
            mdu.printMessage(message, includeHeaders, out, copier);
        }
        catch (IOException e) {
            throw new MailException((Throwable)e);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintBody$aop(long id, boolean includeHeaders, OutputStream out, Copier copier) {
        this.emInit();
        MessageBody body = (MessageBody)this.session.find(MessageBody.class, (Object)id);
        MessageDataUtil mdu = new MessageDataUtil(this.getBodyManager());
        try {
            mdu.printBodyPart(body, includeHeaders, out, copier);
        }
        catch (IOException e) {
            throw new MailException((Throwable)e);
        }
    }

    @Tx(value=TxType.REQUIRESNEW)
    private void org$buni$meldware$mail$mailbox$MailboxServiceImpl$printMessage$aop(long id, boolean includeHeaders, OutputStream out, Copier copier) {
        this.emInit();
        try {
            MessageData message = this.getMail(id);
            if (includeHeaders) {
                out.write(message.getHeader().getBytes());
                out.write(ENDL);
            }
            if (message.isMime()) {
                this.writeln(message.getMimePreamble(), out);
                String boundary = message.getBoundary();
                for (MessageBody body : message.getBody()) {
                    out.write((String.valueOf(boundary) + "\r\n").getBytes("US-ASCII"));
                    this.printBodyPart(body, out, copier);
                }
                out.write((String.valueOf(boundary) + "--" + "\r\n").getBytes("US-ASCII"));
                this.writeln(message.getEpilogue(), out);
            } else if (message.getBody().size() > 0) {
                this.mgr.write((Body)message.getBody().get(0), out, copier);
            } else {
                throw new MailException("Message has no body");
            }
            out.write(ENDL);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printBodyPart(MessageBody body, OutputStream out, Copier c) throws IOException {
        out.write(body.getMimeheader().getBytes("US-ASCII"));
        out.write(ENDL);
        String header = body.getHeader();
        if (header != null && header.length() > 0) {
            out.write(header.getBytes("US-ASCII"));
            out.write(ENDL);
        }
        if (body.getBodyless() && body.getChildren().size() > 0) {
            this.writeln(body.getPreamble(), out);
            for (MessageBody child : body.getChildren()) {
                out.write(("--" + body.getBoundary() + "\r\n").getBytes("US-ASCII"));
                this.printBodyPart(child, out, c);
            }
            out.write(("--" + body.getBoundary() + "--" + "\r\n").getBytes("US-ASCII"));
            this.writeln(body.getEpilogue(), out);
        } else {
            Body b = this.mgr.createMailBody(new Long(body.getBodyId()));
            this.mgr.write(b, out, c);
            out.write(ENDL);
        }
    }

    private void writeln(String value, OutputStream out) throws IOException {
        if (value != null) {
            out.write(value.getBytes("US-ASCII"));
        }
        out.write(ENDL);
    }

    @Tx(value=TxType.REQUIRED)
    public List<String> org$buni$meldware$mail$mailbox$MailboxServiceImpl$getAliases$aop(String user) {
        this.emInit();
        String query = "select b.name from Alias a, Alias b where b.folder_id = a.folder_id and a.name=:alias";
        List result = this.session.createNativeQuery(query).setParameter("alias", (Object)user.toLowerCase()).getResultList();
        return result;
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteAlias$aop(String username, String alias) {
        this.emInit();
        long folder = this.getMailboxIdByAlias(username);
        String deleteQuery = "delete from Alias a where a.name= :alias and a.folder_id=:folder";
        this.session.createNativeQuery(deleteQuery).setParameter("alias", (Object)alias.toLowerCase()).setParameter("folder", (Object)folder).executeUpdate();
    }

    @Override
    public Mailbox getPostmasterMailbox() {
        Mailbox mbox = this.getMailboxByAlias(this.postmaster);
        if (mbox == null) {
            this.log.info("Creating postmaster mailbox: %s", new Object[]{this.postmaster});
            try {
                mbox = this.createMailbox(this.postmaster);
            }
            catch (RuntimeException e) {
                this.log.warn("Error creating postmaster mailbox: %s", new Object[]{e.getMessage()});
                mbox = this.getMailboxByAlias(this.postmaster);
            }
        }
        return this.getMailboxByAlias(this.postmaster);
    }

    public void start() {
        this.getPostmasterMailbox();
    }

    public String getPostmaster() {
        return this.postmaster;
    }

    public void setPostmaster(String postmaster) {
        this.postmaster = postmaster;
    }

    @Override
    public Collection<Integer> search(SearchKey searchKey) {
        return new ArrayList<Integer>(0);
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        MailboxServiceImpl mailboxServiceImpl = this;
        synchronized (mailboxServiceImpl) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor((Object)this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        MailboxServiceImpl mailboxServiceImpl = this;
        synchronized (mailboxServiceImpl) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Mailbox getMailboxById(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailboxById6413698787834252295.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailboxById_6413698787834252295 getMailboxById_64136987878342522952 = new getMailboxById_6413698787834252295(methodInfo, interceptorArray);
            getMailboxById_64136987878342522952.arg0 = l;
            getMailboxById_64136987878342522952.setTargetObject(this);
            getMailboxById_64136987878342522952.typedTargetObject = this;
            getMailboxById_64136987878342522952.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Mailbox)getMailboxById_64136987878342522952.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxById$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Mailbox getMailboxByAlias(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailboxByAlias2156355474417312895.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailboxByAlias_2156355474417312895 getMailboxByAlias_21563554744173128952 = new getMailboxByAlias_2156355474417312895(methodInfo, interceptorArray);
            getMailboxByAlias_21563554744173128952.arg0 = string;
            getMailboxByAlias_21563554744173128952.setTargetObject(this);
            getMailboxByAlias_21563554744173128952.typedTargetObject = this;
            getMailboxByAlias_21563554744173128952.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Mailbox)getMailboxByAlias_21563554744173128952.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxByAlias$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder getDefaultInFolderByAlias(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getDefaultInFolderByAlias8116454652142676286.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getDefaultInFolderByAlias_8116454652142676286 getDefaultInFolderByAlias_81164546521426762862 = new getDefaultInFolderByAlias_8116454652142676286(methodInfo, interceptorArray);
            getDefaultInFolderByAlias_81164546521426762862.arg0 = string;
            getDefaultInFolderByAlias_81164546521426762862.setTargetObject(this);
            getDefaultInFolderByAlias_81164546521426762862.typedTargetObject = this;
            getDefaultInFolderByAlias_81164546521426762862.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)getDefaultInFolderByAlias_81164546521426762862.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultInFolderByAlias$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder getDefaultOutFolderByAlias(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getDefaultOutFolderByAlias8130789135759618080.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getDefaultOutFolderByAlias_8130789135759618080 getDefaultOutFolderByAlias_81307891357596180802 = new getDefaultOutFolderByAlias_8130789135759618080(methodInfo, interceptorArray);
            getDefaultOutFolderByAlias_81307891357596180802.arg0 = string;
            getDefaultOutFolderByAlias_81307891357596180802.setTargetObject(this);
            getDefaultOutFolderByAlias_81307891357596180802.typedTargetObject = this;
            getDefaultOutFolderByAlias_81307891357596180802.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)getDefaultOutFolderByAlias_81307891357596180802.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultOutFolderByAlias$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Mailbox createMailbox(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createMailbox_N_3532434502602607002.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createMailbox_N3532434502602607002 createMailbox_N35324345026026070022 = new createMailbox_N3532434502602607002(methodInfo, interceptorArray);
            createMailbox_N35324345026026070022.arg0 = string;
            createMailbox_N35324345026026070022.setTargetObject(this);
            createMailbox_N35324345026026070022.typedTargetObject = this;
            createMailbox_N35324345026026070022.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Mailbox)createMailbox_N35324345026026070022.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMailbox$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder createFolder(Folder folder, String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createFolder643777264996518006.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createFolder_643777264996518006 createFolder_6437772649965180062 = new createFolder_643777264996518006(methodInfo, interceptorArray);
            createFolder_6437772649965180062.arg0 = folder;
            createFolder_6437772649965180062.arg1 = string;
            createFolder_6437772649965180062.setTargetObject(this);
            createFolder_6437772649965180062.typedTargetObject = this;
            createFolder_6437772649965180062.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)createFolder_6437772649965180062.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(folder, string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder createFolder(Folder folder, String[] stringArray) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createFolder_N_2955346000199661124.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createFolder_N2955346000199661124 createFolder_N29553460001996611242 = new createFolder_N2955346000199661124(methodInfo, interceptorArray);
            createFolder_N29553460001996611242.arg0 = folder;
            createFolder_N29553460001996611242.arg1 = stringArray;
            createFolder_N29553460001996611242.setTargetObject(this);
            createFolder_N29553460001996611242.typedTargetObject = this;
            createFolder_N29553460001996611242.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)createFolder_N29553460001996611242.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(folder, stringArray);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteMailboxById(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteMailboxById_N_6905472812705909935.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteMailboxById_N6905472812705909935 deleteMailboxById_N69054728127059099352 = new deleteMailboxById_N6905472812705909935(methodInfo, interceptorArray);
            deleteMailboxById_N69054728127059099352.arg0 = l;
            deleteMailboxById_N69054728127059099352.setTargetObject(this);
            deleteMailboxById_N69054728127059099352.typedTargetObject = this;
            deleteMailboxById_N69054728127059099352.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteMailboxById_N69054728127059099352.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxById$aop(l);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteMailboxByAlias(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteMailboxByAlias_N_8077316256977076706.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteMailboxByAlias_N8077316256977076706 deleteMailboxByAlias_N80773162569770767062 = new deleteMailboxByAlias_N8077316256977076706(methodInfo, interceptorArray);
            deleteMailboxByAlias_N80773162569770767062.arg0 = string;
            deleteMailboxByAlias_N80773162569770767062.setTargetObject(this);
            deleteMailboxByAlias_N80773162569770767062.typedTargetObject = this;
            deleteMailboxByAlias_N80773162569770767062.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteMailboxByAlias_N80773162569770767062.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxByAlias$aop(string);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public List getMessageBody(MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMessageBody3911902284142732.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMessageBody_3911902284142732 getMessageBody_39119022841427322 = new getMessageBody_3911902284142732(methodInfo, interceptorArray);
            getMessageBody_39119022841427322.arg0 = messageData;
            getMessageBody_39119022841427322.setTargetObject(this);
            getMessageBody_39119022841427322.typedTargetObject = this;
            getMessageBody_39119022841427322.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMessageBody_39119022841427322.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(messageData);
    }

    @Tx(value=TxType.REQUIRED)
    public List getMailBody(MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailBody3118972756526648425.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailBody_3118972756526648425 getMailBody_31189727565266484252 = new getMailBody_3118972756526648425(methodInfo, interceptorArray);
            getMailBody_31189727565266484252.arg0 = messageData;
            getMailBody_31189727565266484252.setTargetObject(this);
            getMailBody_31189727565266484252.typedTargetObject = this;
            getMailBody_31189727565266484252.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMailBody_31189727565266484252.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(messageData);
    }

    @Tx(value=TxType.REQUIRED)
    public List getMailBody(List list) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailBody_N_3229837591794905632.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailBody_N3229837591794905632 getMailBody_N32298375917949056322 = new getMailBody_N3229837591794905632(methodInfo, interceptorArray);
            getMailBody_N32298375917949056322.arg0 = list;
            getMailBody_N32298375917949056322.setTargetObject(this);
            getMailBody_N32298375917949056322.typedTargetObject = this;
            getMailBody_N32298375917949056322.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMailBody_N32298375917949056322.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(list);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void createMail(Folder folder, MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createMail_N_6532270537506409086.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createMail_N6532270537506409086 createMail_N65322705375064090862 = new createMail_N6532270537506409086(methodInfo, interceptorArray);
            createMail_N65322705375064090862.arg0 = folder;
            createMail_N65322705375064090862.arg1 = messageData;
            createMail_N65322705375064090862.setTargetObject(this);
            createMail_N65322705375064090862.typedTargetObject = this;
            createMail_N65322705375064090862.setAdvisor((Advisor)aop$classAdvisor$aop);
            createMail_N65322705375064090862.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMail$aop(folder, messageData);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public boolean lock(String string, Folder folder, Date date) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_lock7737480497464535274.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            lock_7737480497464535274 lock_77374804974645352742 = new lock_7737480497464535274(methodInfo, interceptorArray);
            lock_77374804974645352742.arg0 = string;
            lock_77374804974645352742.arg1 = folder;
            lock_77374804974645352742.arg2 = date;
            lock_77374804974645352742.setTargetObject(this);
            lock_77374804974645352742.typedTargetObject = this;
            lock_77374804974645352742.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)lock_77374804974645352742.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$lock$aop(string, folder, date);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public int getNextUid(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getNextUid6718418978022606846.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getNextUid_6718418978022606846 getNextUid_67184189780226068462 = new getNextUid_6718418978022606846(methodInfo, interceptorArray);
            getNextUid_67184189780226068462.arg0 = l;
            getNextUid_67184189780226068462.setTargetObject(this);
            getNextUid_67184189780226068462.typedTargetObject = this;
            getNextUid_67184189780226068462.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getNextUid_67184189780226068462.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getNextUid$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int[] getUids(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getUids_N_2093903315196796937.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getUids_N2093903315196796937 getUids_N20939033151967969372 = new getUids_N2093903315196796937(methodInfo, interceptorArray);
            getUids_N20939033151967969372.arg0 = folder;
            getUids_N20939033151967969372.setTargetObject(this);
            getUids_N20939033151967969372.typedTargetObject = this;
            getUids_N20939033151967969372.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (int[])getUids_N20939033151967969372.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUids$aop(folder);
    }

    @Tx(value=TxType.REQUIRED)
    private Lock createNewLockForFolder(String string, Folder folder, Date date) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createNewLockForFolder_N_8962902594125124229.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createNewLockForFolder_N8962902594125124229 createNewLockForFolder_N89629025941251242292 = new createNewLockForFolder_N8962902594125124229(methodInfo, interceptorArray);
            createNewLockForFolder_N89629025941251242292.arg0 = string;
            createNewLockForFolder_N89629025941251242292.arg1 = folder;
            createNewLockForFolder_N89629025941251242292.arg2 = date;
            createNewLockForFolder_N89629025941251242292.setTargetObject(this);
            createNewLockForFolder_N89629025941251242292.typedTargetObject = this;
            createNewLockForFolder_N89629025941251242292.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Lock)createNewLockForFolder_N89629025941251242292.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createNewLockForFolder$aop(string, folder, date);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public boolean commit(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_commit6802358189941774990.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            commit_6802358189941774990 commit_68023581899417749902 = new commit_6802358189941774990(methodInfo, interceptorArray);
            commit_68023581899417749902.arg0 = string;
            commit_68023581899417749902.setTargetObject(this);
            commit_68023581899417749902.typedTargetObject = this;
            commit_68023581899417749902.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)commit_68023581899417749902.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$commit$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public void release(String string, Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_release1620172324687511804.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            release_1620172324687511804 release_16201723246875118042 = new release_1620172324687511804(methodInfo, interceptorArray);
            release_16201723246875118042.arg0 = string;
            release_16201723246875118042.arg1 = folder;
            release_16201723246875118042.setTargetObject(this);
            release_16201723246875118042.typedTargetObject = this;
            release_16201723246875118042.setAdvisor((Advisor)aop$classAdvisor$aop);
            release_16201723246875118042.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$release$aop(string, folder);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int getMailCountForFolder(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailCountForFolder_N_6834197920250729137.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailCountForFolder_N6834197920250729137 getMailCountForFolder_N68341979202507291372 = new getMailCountForFolder_N6834197920250729137(methodInfo, interceptorArray);
            getMailCountForFolder_N68341979202507291372.arg0 = folder;
            getMailCountForFolder_N68341979202507291372.setTargetObject(this);
            getMailCountForFolder_N68341979202507291372.typedTargetObject = this;
            getMailCountForFolder_N68341979202507291372.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getMailCountForFolder_N68341979202507291372.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailCountForFolder$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int getMaxUid(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMaxUid_N_1578105451562726499.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMaxUid_N1578105451562726499 getMaxUid_N15781054515627264992 = new getMaxUid_N1578105451562726499(methodInfo, interceptorArray);
            getMaxUid_N15781054515627264992.arg0 = folder;
            getMaxUid_N15781054515627264992.setTargetObject(this);
            getMaxUid_N15781054515627264992.typedTargetObject = this;
            getMaxUid_N15781054515627264992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getMaxUid_N15781054515627264992.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMaxUid$aop(folder);
    }

    @Tx(value=TxType.REQUIRED)
    public List getMailListForFolder(Folder folder, boolean bl) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailListForFolder4138335292392595736.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailListForFolder_4138335292392595736 getMailListForFolder_41383352923925957362 = new getMailListForFolder_4138335292392595736(methodInfo, interceptorArray);
            getMailListForFolder_41383352923925957362.arg0 = folder;
            getMailListForFolder_41383352923925957362.arg1 = bl;
            getMailListForFolder_41383352923925957362.setTargetObject(this);
            getMailListForFolder_41383352923925957362.typedTargetObject = this;
            getMailListForFolder_41383352923925957362.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMailListForFolder_41383352923925957362.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailListForFolder$aop(folder, bl);
    }

    @Tx(value=TxType.REQUIRED)
    public List getMessages(Folder folder, Range[] rangeArray, boolean bl) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMessages1624378364311083764.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMessages_1624378364311083764 getMessages_16243783643110837642 = new getMessages_1624378364311083764(methodInfo, interceptorArray);
            getMessages_16243783643110837642.arg0 = folder;
            getMessages_16243783643110837642.arg1 = rangeArray;
            getMessages_16243783643110837642.arg2 = bl;
            getMessages_16243783643110837642.setTargetObject(this);
            getMessages_16243783643110837642.typedTargetObject = this;
            getMessages_16243783643110837642.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getMessages_16243783643110837642.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessages$aop(folder, rangeArray, bl);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageData getMailAt(Folder folder, int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailAt_N_6648734355302922923.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailAt_N6648734355302922923 getMailAt_N66487343553029229232 = new getMailAt_N6648734355302922923(methodInfo, interceptorArray);
            getMailAt_N66487343553029229232.arg0 = folder;
            getMailAt_N66487343553029229232.arg1 = n;
            getMailAt_N66487343553029229232.setTargetObject(this);
            getMailAt_N66487343553029229232.typedTargetObject = this;
            getMailAt_N66487343553029229232.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)getMailAt_N66487343553029229232.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailAt$aop(folder, n);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public boolean markDeleted(Mailbox mailbox, int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_markDeleted5934752999000964186.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            markDeleted_5934752999000964186 markDeleted_59347529990009641862 = new markDeleted_5934752999000964186(methodInfo, interceptorArray);
            markDeleted_59347529990009641862.arg0 = mailbox;
            markDeleted_59347529990009641862.arg1 = n;
            markDeleted_59347529990009641862.setTargetObject(this);
            markDeleted_59347529990009641862.typedTargetObject = this;
            markDeleted_59347529990009641862.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)markDeleted_59347529990009641862.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$markDeleted$aop(mailbox, n);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public boolean deleteMarked(Mailbox mailbox) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteMarked_N_7319567664623845061.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteMarked_N7319567664623845061 deleteMarked_N73195676646238450612 = new deleteMarked_N7319567664623845061(methodInfo, interceptorArray);
            deleteMarked_N73195676646238450612.arg0 = mailbox;
            deleteMarked_N73195676646238450612.setTargetObject(this);
            deleteMarked_N73195676646238450612.typedTargetObject = this;
            deleteMarked_N73195676646238450612.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)deleteMarked_N73195676646238450612.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMarked$aop(mailbox);
    }

    @Override
    @Tx(value=TxType.REQUIRESNEW)
    public boolean unmarkDeleted(Mailbox mailbox) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_unmarkDeleted1914944057986980756.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            unmarkDeleted_1914944057986980756 unmarkDeleted_19149440579869807562 = new unmarkDeleted_1914944057986980756(methodInfo, interceptorArray);
            unmarkDeleted_19149440579869807562.arg0 = mailbox;
            unmarkDeleted_19149440579869807562.setTargetObject(this);
            unmarkDeleted_19149440579869807562.typedTargetObject = this;
            unmarkDeleted_19149440579869807562.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)unmarkDeleted_19149440579869807562.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$unmarkDeleted$aop(mailbox);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public long getMailboxIdByAlias(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMailboxIdByAlias_N_4145491549460421805.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMailboxIdByAlias_N4145491549460421805 getMailboxIdByAlias_N41454915494604218052 = new getMailboxIdByAlias_N4145491549460421805(methodInfo, interceptorArray);
            getMailboxIdByAlias_N41454915494604218052.arg0 = string;
            getMailboxIdByAlias_N41454915494604218052.setTargetObject(this);
            getMailboxIdByAlias_N41454915494604218052.typedTargetObject = this;
            getMailboxIdByAlias_N41454915494604218052.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)getMailboxIdByAlias_N41454915494604218052.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxIdByAlias$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public boolean createAlias(long l, String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createAlias968917090120825244.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createAlias_968917090120825244 createAlias_9689170901208252442 = new createAlias_968917090120825244(methodInfo, interceptorArray);
            createAlias_9689170901208252442.arg0 = l;
            createAlias_9689170901208252442.arg1 = string;
            createAlias_9689170901208252442.setTargetObject(this);
            createAlias_9689170901208252442.typedTargetObject = this;
            createAlias_9689170901208252442.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Boolean)createAlias_9689170901208252442.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createAlias$aop(l, string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder getSubfolderByName(Folder folder, String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getSubfolderByName6112040871602112999.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getSubfolderByName_6112040871602112999 getSubfolderByName_61120408716021129992 = new getSubfolderByName_6112040871602112999(methodInfo, interceptorArray);
            getSubfolderByName_61120408716021129992.arg0 = folder;
            getSubfolderByName_61120408716021129992.arg1 = string;
            getSubfolderByName_61120408716021129992.setTargetObject(this);
            getSubfolderByName_61120408716021129992.typedTargetObject = this;
            getSubfolderByName_61120408716021129992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)getSubfolderByName_61120408716021129992.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByName$aop(folder, string);
    }

    @Tx(value=TxType.REQUIRED)
    public List getSubfolders(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getSubfolders8285920828106536306.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getSubfolders_8285920828106536306 getSubfolders_82859208281065363062 = new getSubfolders_8285920828106536306(methodInfo, interceptorArray);
            getSubfolders_82859208281065363062.arg0 = folder;
            getSubfolders_82859208281065363062.setTargetObject(this);
            getSubfolders_82859208281065363062.typedTargetObject = this;
            getSubfolders_82859208281065363062.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getSubfolders_82859208281065363062.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(folder);
    }

    @Tx(value=TxType.REQUIRED)
    public List getSubfolders(Folder folder, String[] stringArray, FolderFilter folderFilter) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getSubfolders677140112798081686.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getSubfolders_677140112798081686 getSubfolders_6771401127980816862 = new getSubfolders_677140112798081686(methodInfo, interceptorArray);
            getSubfolders_6771401127980816862.arg0 = folder;
            getSubfolders_6771401127980816862.arg1 = stringArray;
            getSubfolders_6771401127980816862.arg2 = folderFilter;
            getSubfolders_6771401127980816862.setTargetObject(this);
            getSubfolders_6771401127980816862.typedTargetObject = this;
            getSubfolders_6771401127980816862.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getSubfolders_6771401127980816862.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(folder, stringArray, folderFilter);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int getRecentCountForFolder(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getRecentCountForFolder_N_703713320950335564.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getRecentCountForFolder_N703713320950335564 getRecentCountForFolder_N7037133209503355642 = new getRecentCountForFolder_N703713320950335564(methodInfo, interceptorArray);
            getRecentCountForFolder_N7037133209503355642.arg0 = folder;
            getRecentCountForFolder_N7037133209503355642.setTargetObject(this);
            getRecentCountForFolder_N7037133209503355642.typedTargetObject = this;
            getRecentCountForFolder_N7037133209503355642.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getRecentCountForFolder_N7037133209503355642.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getRecentCountForFolder$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public long getLikelyUID(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getLikelyUID2299057798449282556.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getLikelyUID_2299057798449282556 getLikelyUID_22990577984492825562 = new getLikelyUID_2299057798449282556(methodInfo, interceptorArray);
            getLikelyUID_22990577984492825562.arg0 = folder;
            getLikelyUID_22990577984492825562.setTargetObject(this);
            getLikelyUID_22990577984492825562.typedTargetObject = this;
            getLikelyUID_22990577984492825562.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)getLikelyUID_22990577984492825562.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getLikelyUID$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void updateMessageMetaData(MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_updateMessageMetaData1812264909449898229.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            updateMessageMetaData_1812264909449898229 updateMessageMetaData_18122649094498982292 = new updateMessageMetaData_1812264909449898229(methodInfo, interceptorArray);
            updateMessageMetaData_18122649094498982292.arg0 = messageData;
            updateMessageMetaData_18122649094498982292.setTargetObject(this);
            updateMessageMetaData_18122649094498982292.typedTargetObject = this;
            updateMessageMetaData_18122649094498982292.setAdvisor((Advisor)aop$classAdvisor$aop);
            updateMessageMetaData_18122649094498982292.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$updateMessageMetaData$aop(messageData);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void copy(MessageData messageData, Folder folder, Folder folder2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_copy_N_5063802630492799710.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            copy_N5063802630492799710 copy_N50638026304927997102 = new copy_N5063802630492799710(methodInfo, interceptorArray);
            copy_N50638026304927997102.arg0 = messageData;
            copy_N50638026304927997102.arg1 = folder;
            copy_N50638026304927997102.arg2 = folder2;
            copy_N50638026304927997102.setTargetObject(this);
            copy_N50638026304927997102.typedTargetObject = this;
            copy_N50638026304927997102.setAdvisor((Advisor)aop$classAdvisor$aop);
            copy_N50638026304927997102.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(messageData, folder, folder2);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void copy(long l, MessageData messageData) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_copy_N_5706638977282021959.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            copy_N5706638977282021959 copy_N57066389772820219592 = new copy_N5706638977282021959(methodInfo, interceptorArray);
            copy_N57066389772820219592.arg0 = l;
            copy_N57066389772820219592.arg1 = messageData;
            copy_N57066389772820219592.setTargetObject(this);
            copy_N57066389772820219592.typedTargetObject = this;
            copy_N57066389772820219592.setAdvisor((Advisor)aop$classAdvisor$aop);
            copy_N57066389772820219592.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(l, messageData);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public Node folderSummary(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_folderSummary_N_7462638425403645780.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            folderSummary_N7462638425403645780 folderSummary_N74626384254036457802 = new folderSummary_N7462638425403645780(methodInfo, interceptorArray);
            folderSummary_N74626384254036457802.arg0 = string;
            folderSummary_N74626384254036457802.setTargetObject(this);
            folderSummary_N74626384254036457802.typedTargetObject = this;
            folderSummary_N74626384254036457802.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Node)folderSummary_N74626384254036457802.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$folderSummary$aop(string);
    }

    @Tx(value=TxType.REQUIRED)
    private void retSummary(Node node) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_retSummary9179350348051872086.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            retSummary_9179350348051872086 retSummary_91793503480518720862 = new retSummary_9179350348051872086(methodInfo, interceptorArray);
            retSummary_91793503480518720862.arg0 = node;
            retSummary_91793503480518720862.setTargetObject(this);
            retSummary_91793503480518720862.typedTargetObject = this;
            retSummary_91793503480518720862.setAdvisor((Advisor)aop$classAdvisor$aop);
            retSummary_91793503480518720862.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$retSummary$aop((Node<FolderSummary>)node);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public List expunge(Folder folder, boolean bl) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_expunge5409646354199440601.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            expunge_5409646354199440601 expunge_54096463541994406012 = new expunge_5409646354199440601(methodInfo, interceptorArray);
            expunge_54096463541994406012.arg0 = folder;
            expunge_54096463541994406012.arg1 = bl;
            expunge_54096463541994406012.setTargetObject(this);
            expunge_54096463541994406012.typedTargetObject = this;
            expunge_54096463541994406012.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)expunge_54096463541994406012.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$expunge$aop(folder, bl);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageData getMail(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMail_N_68618239099411182.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMail_N68618239099411182 getMail_N686182390994111822 = new getMail_N68618239099411182(methodInfo, interceptorArray);
            getMail_N686182390994111822.arg0 = l;
            getMail_N686182390994111822.setTargetObject(this);
            getMail_N686182390994111822.typedTargetObject = this;
            getMail_N686182390994111822.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageData)getMail_N686182390994111822.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMail$aop(l);
    }

    @Tx(value=TxType.REQUIRED)
    private void fastExpunge(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_fastExpunge4919076391455760194.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            fastExpunge_4919076391455760194 fastExpunge_49190763914557601942 = new fastExpunge_4919076391455760194(methodInfo, interceptorArray);
            fastExpunge_49190763914557601942.arg0 = folder;
            fastExpunge_49190763914557601942.setTargetObject(this);
            fastExpunge_49190763914557601942.typedTargetObject = this;
            fastExpunge_49190763914557601942.setAdvisor((Advisor)aop$classAdvisor$aop);
            fastExpunge_49190763914557601942.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$fastExpunge$aop(folder);
        }
    }

    @Tx(value=TxType.REQUIRED)
    private int getCountReferencingBody(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getCountReferencingBody_N_9154764769953758522.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getCountReferencingBody_N9154764769953758522 getCountReferencingBody_N91547647699537585222 = new getCountReferencingBody_N9154764769953758522(methodInfo, interceptorArray);
            getCountReferencingBody_N91547647699537585222.arg0 = l;
            getCountReferencingBody_N91547647699537585222.setTargetObject(this);
            getCountReferencingBody_N91547647699537585222.typedTargetObject = this;
            getCountReferencingBody_N91547647699537585222.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getCountReferencingBody_N91547647699537585222.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getCountReferencingBody$aop(l);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int getUnseenCountForFolder(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getUnseenCountForFolder_N_6283046278616930205.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getUnseenCountForFolder_N6283046278616930205 getUnseenCountForFolder_N62830462786169302052 = new getUnseenCountForFolder_N6283046278616930205(methodInfo, interceptorArray);
            getUnseenCountForFolder_N62830462786169302052.arg0 = folder;
            getUnseenCountForFolder_N62830462786169302052.setTargetObject(this);
            getUnseenCountForFolder_N62830462786169302052.typedTargetObject = this;
            getUnseenCountForFolder_N62830462786169302052.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)getUnseenCountForFolder_N62830462786169302052.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUnseenCountForFolder$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public long getFirstUnseen(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getFirstUnseen_N_5587371301290562644.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getFirstUnseen_N5587371301290562644 getFirstUnseen_N55873713012905626442 = new getFirstUnseen_N5587371301290562644(methodInfo, interceptorArray);
            getFirstUnseen_N55873713012905626442.arg0 = folder;
            getFirstUnseen_N55873713012905626442.setTargetObject(this);
            getFirstUnseen_N55873713012905626442.typedTargetObject = this;
            getFirstUnseen_N55873713012905626442.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)getFirstUnseen_N55873713012905626442.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getFirstUnseen$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder moveFolder(Folder folder, Folder folder2, String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_moveFolder1391768566440483274.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            moveFolder_1391768566440483274 moveFolder_13917685664404832742 = new moveFolder_1391768566440483274(methodInfo, interceptorArray);
            moveFolder_13917685664404832742.arg0 = folder;
            moveFolder_13917685664404832742.arg1 = folder2;
            moveFolder_13917685664404832742.arg2 = string;
            moveFolder_13917685664404832742.setTargetObject(this);
            moveFolder_13917685664404832742.typedTargetObject = this;
            moveFolder_13917685664404832742.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)moveFolder_13917685664404832742.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(folder, folder2, string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder moveFolder(Folder folder, String[] stringArray) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_moveFolder_N_2048023763802867480.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            moveFolder_N2048023763802867480 moveFolder_N20480237638028674802 = new moveFolder_N2048023763802867480(methodInfo, interceptorArray);
            moveFolder_N20480237638028674802.arg0 = folder;
            moveFolder_N20480237638028674802.arg1 = stringArray;
            moveFolder_N20480237638028674802.setTargetObject(this);
            moveFolder_N20480237638028674802.typedTargetObject = this;
            moveFolder_N20480237638028674802.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)moveFolder_N20480237638028674802.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(folder, stringArray);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public String getPathFor(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getPathFor_N_8886049787943587193.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getPathFor_N8886049787943587193 getPathFor_N88860497879435871932 = new getPathFor_N8886049787943587193(methodInfo, interceptorArray);
            getPathFor_N88860497879435871932.arg0 = folder;
            getPathFor_N88860497879435871932.setTargetObject(this);
            getPathFor_N88860497879435871932.typedTargetObject = this;
            getPathFor_N88860497879435871932.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (String)getPathFor_N88860497879435871932.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getPathFor$aop(folder);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteMessage(long l) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteMessage_N_9198329699081340556.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteMessage_N9198329699081340556 deleteMessage_N91983296990813405562 = new deleteMessage_N9198329699081340556(methodInfo, interceptorArray);
            deleteMessage_N91983296990813405562.arg0 = l;
            deleteMessage_N91983296990813405562.setTargetObject(this);
            deleteMessage_N91983296990813405562.typedTargetObject = this;
            deleteMessage_N91983296990813405562.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteMessage_N91983296990813405562.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMessage$aop(l);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteFolder(Folder folder) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteFolder_N_7601395062060664724.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteFolder_N7601395062060664724 deleteFolder_N76013950620606647242 = new deleteFolder_N7601395062060664724(methodInfo, interceptorArray);
            deleteFolder_N76013950620606647242.arg0 = folder;
            deleteFolder_N76013950620606647242.setTargetObject(this);
            deleteFolder_N76013950620606647242.typedTargetObject = this;
            deleteFolder_N76013950620606647242.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteFolder_N76013950620606647242.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteFolder$aop(folder);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Folder getSubfolderByPath(Folder folder, String[] stringArray) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getSubfolderByPath_N_8428708415463439975.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getSubfolderByPath_N8428708415463439975 getSubfolderByPath_N84287084154634399752 = new getSubfolderByPath_N8428708415463439975(methodInfo, interceptorArray);
            getSubfolderByPath_N84287084154634399752.arg0 = folder;
            getSubfolderByPath_N84287084154634399752.arg1 = stringArray;
            getSubfolderByPath_N84287084154634399752.setTargetObject(this);
            getSubfolderByPath_N84287084154634399752.typedTargetObject = this;
            getSubfolderByPath_N84287084154634399752.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Folder)getSubfolderByPath_N84287084154634399752.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByPath$aop(folder, stringArray);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageBody getMessageBody(MessageData messageData, int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMessageBody_N_9074101858728972783.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMessageBody_N9074101858728972783 getMessageBody_N90741018587289727832 = new getMessageBody_N9074101858728972783(methodInfo, interceptorArray);
            getMessageBody_N90741018587289727832.arg0 = messageData;
            getMessageBody_N90741018587289727832.arg1 = n;
            getMessageBody_N90741018587289727832.setTargetObject(this);
            getMessageBody_N90741018587289727832.typedTargetObject = this;
            getMessageBody_N90741018587289727832.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageBody)getMessageBody_N90741018587289727832.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(messageData, n);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public MessageBody getMessageBody(MessageBody messageBody, int n) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getMessageBody_N_6809412181622339899.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getMessageBody_N6809412181622339899 getMessageBody_N68094121816223398992 = new getMessageBody_N6809412181622339899(methodInfo, interceptorArray);
            getMessageBody_N68094121816223398992.arg0 = messageBody;
            getMessageBody_N68094121816223398992.arg1 = n;
            getMessageBody_N68094121816223398992.setTargetObject(this);
            getMessageBody_N68094121816223398992.typedTargetObject = this;
            getMessageBody_N68094121816223398992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (MessageBody)getMessageBody_N68094121816223398992.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(messageBody, n);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void mimePrintMessage(long l, boolean bl, OutputStream outputStream, Copier copier) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_mimePrintMessage_N_2211963482245601720.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            mimePrintMessage_N2211963482245601720 mimePrintMessage_N22119634822456017202 = new mimePrintMessage_N2211963482245601720(methodInfo, interceptorArray);
            mimePrintMessage_N22119634822456017202.arg0 = l;
            mimePrintMessage_N22119634822456017202.arg1 = bl;
            mimePrintMessage_N22119634822456017202.arg2 = outputStream;
            mimePrintMessage_N22119634822456017202.arg3 = copier;
            mimePrintMessage_N22119634822456017202.setTargetObject(this);
            mimePrintMessage_N22119634822456017202.typedTargetObject = this;
            mimePrintMessage_N22119634822456017202.setAdvisor((Advisor)aop$classAdvisor$aop);
            mimePrintMessage_N22119634822456017202.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintMessage$aop(l, bl, outputStream, copier);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void mimePrintBody(long l, boolean bl, OutputStream outputStream, Copier copier) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_mimePrintBody3264814303130705280.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            mimePrintBody_3264814303130705280 mimePrintBody_32648143031307052802 = new mimePrintBody_3264814303130705280(methodInfo, interceptorArray);
            mimePrintBody_32648143031307052802.arg0 = l;
            mimePrintBody_32648143031307052802.arg1 = bl;
            mimePrintBody_32648143031307052802.arg2 = outputStream;
            mimePrintBody_32648143031307052802.arg3 = copier;
            mimePrintBody_32648143031307052802.setTargetObject(this);
            mimePrintBody_32648143031307052802.typedTargetObject = this;
            mimePrintBody_32648143031307052802.setAdvisor((Advisor)aop$classAdvisor$aop);
            mimePrintBody_32648143031307052802.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintBody$aop(l, bl, outputStream, copier);
        }
    }

    @Tx(value=TxType.REQUIRESNEW)
    private void printMessage(long l, boolean bl, OutputStream outputStream, Copier copier) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_printMessage2704115281852340060.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            printMessage_2704115281852340060 printMessage_27041152818523400602 = new printMessage_2704115281852340060(methodInfo, interceptorArray);
            printMessage_27041152818523400602.arg0 = l;
            printMessage_27041152818523400602.arg1 = bl;
            printMessage_27041152818523400602.arg2 = outputStream;
            printMessage_27041152818523400602.arg3 = copier;
            printMessage_27041152818523400602.setTargetObject(this);
            printMessage_27041152818523400602.typedTargetObject = this;
            printMessage_27041152818523400602.setAdvisor((Advisor)aop$classAdvisor$aop);
            printMessage_27041152818523400602.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$printMessage$aop(l, bl, outputStream, copier);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public List getAliases(String string) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getAliases7896895568457778935.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getAliases_7896895568457778935 getAliases_78968955684577789352 = new getAliases_7896895568457778935(methodInfo, interceptorArray);
            getAliases_78968955684577789352.arg0 = string;
            getAliases_78968955684577789352.setTargetObject(this);
            getAliases_78968955684577789352.typedTargetObject = this;
            getAliases_78968955684577789352.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (List)getAliases_78968955684577789352.invokeNext();
        }
        return this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getAliases$aop(string);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public void deleteAlias(String string, String string2) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_deleteAlias_N_7340062284907121816.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            deleteAlias_N7340062284907121816 deleteAlias_N73400622849071218162 = new deleteAlias_N7340062284907121816(methodInfo, interceptorArray);
            deleteAlias_N73400622849071218162.arg0 = string;
            deleteAlias_N73400622849071218162.arg1 = string2;
            deleteAlias_N73400622849071218162.setTargetObject(this);
            deleteAlias_N73400622849071218162.typedTargetObject = this;
            deleteAlias_N73400622849071218162.setAdvisor((Advisor)aop$classAdvisor$aop);
            deleteAlias_N73400622849071218162.invokeNext();
        } else {
            this.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteAlias$aop(string, string2);
        }
    }

    public static class getMailboxById_6413698787834252295
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailboxById_6413698787834252295(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailboxById_6413698787834252295(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailboxById_6413698787834252295(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailboxById_6413698787834252295() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxById$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getMailboxById_6413698787834252295 getMailboxById_64136987878342522952 = new getMailboxById_6413698787834252295(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailboxById_64136987878342522952.arguments = this.arguments;
            ((InvocationBase)getMailboxById_64136987878342522952).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailboxById_64136987878342522952).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailboxById_64136987878342522952).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailboxById_64136987878342522952.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailboxById_64136987878342522952).targetObject = ((InvocationBase)this).targetObject;
            getMailboxById_64136987878342522952.arg0 = this.arg0;
            return getMailboxById_64136987878342522952;
        }
    }

    public static class getMailboxByAlias_2156355474417312895
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailboxByAlias_2156355474417312895(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailboxByAlias_2156355474417312895(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailboxByAlias_2156355474417312895(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailboxByAlias_2156355474417312895() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxByAlias$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMailboxByAlias_2156355474417312895 getMailboxByAlias_21563554744173128952 = new getMailboxByAlias_2156355474417312895(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailboxByAlias_21563554744173128952.arguments = this.arguments;
            ((InvocationBase)getMailboxByAlias_21563554744173128952).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailboxByAlias_21563554744173128952).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailboxByAlias_21563554744173128952).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailboxByAlias_21563554744173128952.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailboxByAlias_21563554744173128952).targetObject = ((InvocationBase)this).targetObject;
            getMailboxByAlias_21563554744173128952.arg0 = this.arg0;
            return getMailboxByAlias_21563554744173128952;
        }
    }

    public static class getDefaultInFolderByAlias_8116454652142676286
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public getDefaultInFolderByAlias_8116454652142676286(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getDefaultInFolderByAlias_8116454652142676286(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getDefaultInFolderByAlias_8116454652142676286(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getDefaultInFolderByAlias_8116454652142676286() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultInFolderByAlias$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getDefaultInFolderByAlias_8116454652142676286 getDefaultInFolderByAlias_81164546521426762862 = new getDefaultInFolderByAlias_8116454652142676286(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getDefaultInFolderByAlias_81164546521426762862.arguments = this.arguments;
            ((InvocationBase)getDefaultInFolderByAlias_81164546521426762862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getDefaultInFolderByAlias_81164546521426762862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getDefaultInFolderByAlias_81164546521426762862).instanceResolver = ((InvocationBase)this).instanceResolver;
            getDefaultInFolderByAlias_81164546521426762862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getDefaultInFolderByAlias_81164546521426762862).targetObject = ((InvocationBase)this).targetObject;
            getDefaultInFolderByAlias_81164546521426762862.arg0 = this.arg0;
            return getDefaultInFolderByAlias_81164546521426762862;
        }
    }

    public static class getDefaultOutFolderByAlias_8130789135759618080
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public getDefaultOutFolderByAlias_8130789135759618080(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getDefaultOutFolderByAlias_8130789135759618080(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getDefaultOutFolderByAlias_8130789135759618080(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getDefaultOutFolderByAlias_8130789135759618080() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getDefaultOutFolderByAlias$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getDefaultOutFolderByAlias_8130789135759618080 getDefaultOutFolderByAlias_81307891357596180802 = new getDefaultOutFolderByAlias_8130789135759618080(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getDefaultOutFolderByAlias_81307891357596180802.arguments = this.arguments;
            ((InvocationBase)getDefaultOutFolderByAlias_81307891357596180802).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getDefaultOutFolderByAlias_81307891357596180802).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getDefaultOutFolderByAlias_81307891357596180802).instanceResolver = ((InvocationBase)this).instanceResolver;
            getDefaultOutFolderByAlias_81307891357596180802.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getDefaultOutFolderByAlias_81307891357596180802).targetObject = ((InvocationBase)this).targetObject;
            getDefaultOutFolderByAlias_81307891357596180802.arg0 = this.arg0;
            return getDefaultOutFolderByAlias_81307891357596180802;
        }
    }

    public static class createMailbox_N3532434502602607002
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public createMailbox_N3532434502602607002(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createMailbox_N3532434502602607002(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createMailbox_N3532434502602607002(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createMailbox_N3532434502602607002() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMailbox$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            createMailbox_N3532434502602607002 createMailbox_N35324345026026070022 = new createMailbox_N3532434502602607002(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createMailbox_N35324345026026070022.arguments = this.arguments;
            ((InvocationBase)createMailbox_N35324345026026070022).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createMailbox_N35324345026026070022).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createMailbox_N35324345026026070022).instanceResolver = ((InvocationBase)this).instanceResolver;
            createMailbox_N35324345026026070022.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createMailbox_N35324345026026070022).targetObject = ((InvocationBase)this).targetObject;
            createMailbox_N35324345026026070022.arg0 = this.arg0;
            return createMailbox_N35324345026026070022;
        }
    }

    public static class createFolder_643777264996518006
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String arg1;
        public MailboxServiceImpl typedTargetObject;

        public createFolder_643777264996518006(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createFolder_643777264996518006(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createFolder_643777264996518006(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createFolder_643777264996518006() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createFolder_643777264996518006 createFolder_6437772649965180062 = new createFolder_643777264996518006(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createFolder_6437772649965180062.arguments = this.arguments;
            ((InvocationBase)createFolder_6437772649965180062).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createFolder_6437772649965180062).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createFolder_6437772649965180062).instanceResolver = ((InvocationBase)this).instanceResolver;
            createFolder_6437772649965180062.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createFolder_6437772649965180062).targetObject = ((InvocationBase)this).targetObject;
            createFolder_6437772649965180062.arg0 = this.arg0;
            createFolder_6437772649965180062.arg1 = this.arg1;
            return createFolder_6437772649965180062;
        }
    }

    public static class createFolder_N2955346000199661124
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String[] arg1;
        public MailboxServiceImpl typedTargetObject;

        public createFolder_N2955346000199661124(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createFolder_N2955346000199661124(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createFolder_N2955346000199661124(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createFolder_N2955346000199661124() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String[])object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createFolder_N2955346000199661124 createFolder_N29553460001996611242 = new createFolder_N2955346000199661124(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createFolder_N29553460001996611242.arguments = this.arguments;
            ((InvocationBase)createFolder_N29553460001996611242).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createFolder_N29553460001996611242).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createFolder_N29553460001996611242).instanceResolver = ((InvocationBase)this).instanceResolver;
            createFolder_N29553460001996611242.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createFolder_N29553460001996611242).targetObject = ((InvocationBase)this).targetObject;
            createFolder_N29553460001996611242.arg0 = this.arg0;
            createFolder_N29553460001996611242.arg1 = this.arg1;
            return createFolder_N29553460001996611242;
        }
    }

    public static class deleteMailboxById_N6905472812705909935
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public deleteMailboxById_N6905472812705909935(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteMailboxById_N6905472812705909935(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteMailboxById_N6905472812705909935(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteMailboxById_N6905472812705909935() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxById$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            deleteMailboxById_N6905472812705909935 deleteMailboxById_N69054728127059099352 = new deleteMailboxById_N6905472812705909935(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteMailboxById_N69054728127059099352.arguments = this.arguments;
            ((InvocationBase)deleteMailboxById_N69054728127059099352).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteMailboxById_N69054728127059099352).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteMailboxById_N69054728127059099352).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteMailboxById_N69054728127059099352.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteMailboxById_N69054728127059099352).targetObject = ((InvocationBase)this).targetObject;
            deleteMailboxById_N69054728127059099352.arg0 = this.arg0;
            return deleteMailboxById_N69054728127059099352;
        }
    }

    public static class deleteMailboxByAlias_N8077316256977076706
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public deleteMailboxByAlias_N8077316256977076706(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteMailboxByAlias_N8077316256977076706(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteMailboxByAlias_N8077316256977076706(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteMailboxByAlias_N8077316256977076706() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMailboxByAlias$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            deleteMailboxByAlias_N8077316256977076706 deleteMailboxByAlias_N80773162569770767062 = new deleteMailboxByAlias_N8077316256977076706(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteMailboxByAlias_N80773162569770767062.arguments = this.arguments;
            ((InvocationBase)deleteMailboxByAlias_N80773162569770767062).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteMailboxByAlias_N80773162569770767062).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteMailboxByAlias_N80773162569770767062).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteMailboxByAlias_N80773162569770767062.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteMailboxByAlias_N80773162569770767062).targetObject = ((InvocationBase)this).targetObject;
            deleteMailboxByAlias_N80773162569770767062.arg0 = this.arg0;
            return deleteMailboxByAlias_N80773162569770767062;
        }
    }

    public static class getMessageBody_3911902284142732
    extends MethodInvocation
    implements Untransformable {
        public MessageData arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMessageBody_3911902284142732(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMessageBody_3911902284142732(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMessageBody_3911902284142732(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMessageBody_3911902284142732() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMessageBody_3911902284142732 getMessageBody_39119022841427322 = new getMessageBody_3911902284142732(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMessageBody_39119022841427322.arguments = this.arguments;
            ((InvocationBase)getMessageBody_39119022841427322).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMessageBody_39119022841427322).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMessageBody_39119022841427322).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMessageBody_39119022841427322.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMessageBody_39119022841427322).targetObject = ((InvocationBase)this).targetObject;
            getMessageBody_39119022841427322.arg0 = this.arg0;
            return getMessageBody_39119022841427322;
        }
    }

    public static class getMailBody_3118972756526648425
    extends MethodInvocation
    implements Untransformable {
        public MessageData arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailBody_3118972756526648425(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailBody_3118972756526648425(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailBody_3118972756526648425(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailBody_3118972756526648425() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMailBody_3118972756526648425 getMailBody_31189727565266484252 = new getMailBody_3118972756526648425(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailBody_31189727565266484252.arguments = this.arguments;
            ((InvocationBase)getMailBody_31189727565266484252).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailBody_31189727565266484252).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailBody_31189727565266484252).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailBody_31189727565266484252.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailBody_31189727565266484252).targetObject = ((InvocationBase)this).targetObject;
            getMailBody_31189727565266484252.arg0 = this.arg0;
            return getMailBody_31189727565266484252;
        }
    }

    public static class getMailBody_N3229837591794905632
    extends MethodInvocation
    implements Untransformable {
        public List arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailBody_N3229837591794905632(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailBody_N3229837591794905632(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailBody_N3229837591794905632(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailBody_N3229837591794905632() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailBody$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (List)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMailBody_N3229837591794905632 getMailBody_N32298375917949056322 = new getMailBody_N3229837591794905632(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailBody_N32298375917949056322.arguments = this.arguments;
            ((InvocationBase)getMailBody_N32298375917949056322).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailBody_N32298375917949056322).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailBody_N32298375917949056322).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailBody_N32298375917949056322.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailBody_N32298375917949056322).targetObject = ((InvocationBase)this).targetObject;
            getMailBody_N32298375917949056322.arg0 = this.arg0;
            return getMailBody_N32298375917949056322;
        }
    }

    public static class createMail_N6532270537506409086
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MessageData arg1;
        public MailboxServiceImpl typedTargetObject;

        public createMail_N6532270537506409086(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createMail_N6532270537506409086(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createMail_N6532270537506409086(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createMail_N6532270537506409086() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createMail$aop(this.arg0, this.arg1);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (MessageData)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createMail_N6532270537506409086 createMail_N65322705375064090862 = new createMail_N6532270537506409086(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createMail_N65322705375064090862.arguments = this.arguments;
            ((InvocationBase)createMail_N65322705375064090862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createMail_N65322705375064090862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createMail_N65322705375064090862).instanceResolver = ((InvocationBase)this).instanceResolver;
            createMail_N65322705375064090862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createMail_N65322705375064090862).targetObject = ((InvocationBase)this).targetObject;
            createMail_N65322705375064090862.arg0 = this.arg0;
            createMail_N65322705375064090862.arg1 = this.arg1;
            return createMail_N65322705375064090862;
        }
    }

    public static class lock_7737480497464535274
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public Folder arg1;
        public Date arg2;
        public MailboxServiceImpl typedTargetObject;

        public lock_7737480497464535274(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public lock_7737480497464535274(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public lock_7737480497464535274(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public lock_7737480497464535274() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$lock$aop(this.arg0, this.arg1, this.arg2));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (Folder)object2;
            Object object3 = objectArray[2];
            this.arg2 = (Date)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            lock_7737480497464535274 lock_77374804974645352742 = new lock_7737480497464535274(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            lock_77374804974645352742.arguments = this.arguments;
            ((InvocationBase)lock_77374804974645352742).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)lock_77374804974645352742).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)lock_77374804974645352742).instanceResolver = ((InvocationBase)this).instanceResolver;
            lock_77374804974645352742.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)lock_77374804974645352742).targetObject = ((InvocationBase)this).targetObject;
            lock_77374804974645352742.arg0 = this.arg0;
            lock_77374804974645352742.arg1 = this.arg1;
            lock_77374804974645352742.arg2 = this.arg2;
            return lock_77374804974645352742;
        }
    }

    public static class getNextUid_6718418978022606846
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public getNextUid_6718418978022606846(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getNextUid_6718418978022606846(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getNextUid_6718418978022606846(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getNextUid_6718418978022606846() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getNextUid$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getNextUid_6718418978022606846 getNextUid_67184189780226068462 = new getNextUid_6718418978022606846(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getNextUid_67184189780226068462.arguments = this.arguments;
            ((InvocationBase)getNextUid_67184189780226068462).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getNextUid_67184189780226068462).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getNextUid_67184189780226068462).instanceResolver = ((InvocationBase)this).instanceResolver;
            getNextUid_67184189780226068462.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getNextUid_67184189780226068462).targetObject = ((InvocationBase)this).targetObject;
            getNextUid_67184189780226068462.arg0 = this.arg0;
            return getNextUid_67184189780226068462;
        }
    }

    public static class getUids_N2093903315196796937
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getUids_N2093903315196796937(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getUids_N2093903315196796937(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getUids_N2093903315196796937(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getUids_N2093903315196796937() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUids$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getUids_N2093903315196796937 getUids_N20939033151967969372 = new getUids_N2093903315196796937(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getUids_N20939033151967969372.arguments = this.arguments;
            ((InvocationBase)getUids_N20939033151967969372).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getUids_N20939033151967969372).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getUids_N20939033151967969372).instanceResolver = ((InvocationBase)this).instanceResolver;
            getUids_N20939033151967969372.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getUids_N20939033151967969372).targetObject = ((InvocationBase)this).targetObject;
            getUids_N20939033151967969372.arg0 = this.arg0;
            return getUids_N20939033151967969372;
        }
    }

    public static class createNewLockForFolder_N8962902594125124229
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public Folder arg1;
        public Date arg2;
        public MailboxServiceImpl typedTargetObject;

        public createNewLockForFolder_N8962902594125124229(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createNewLockForFolder_N8962902594125124229(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createNewLockForFolder_N8962902594125124229(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createNewLockForFolder_N8962902594125124229() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createNewLockForFolder$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (Folder)object2;
            Object object3 = objectArray[2];
            this.arg2 = (Date)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            createNewLockForFolder_N8962902594125124229 createNewLockForFolder_N89629025941251242292 = new createNewLockForFolder_N8962902594125124229(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createNewLockForFolder_N89629025941251242292.arguments = this.arguments;
            ((InvocationBase)createNewLockForFolder_N89629025941251242292).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createNewLockForFolder_N89629025941251242292).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createNewLockForFolder_N89629025941251242292).instanceResolver = ((InvocationBase)this).instanceResolver;
            createNewLockForFolder_N89629025941251242292.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createNewLockForFolder_N89629025941251242292).targetObject = ((InvocationBase)this).targetObject;
            createNewLockForFolder_N89629025941251242292.arg0 = this.arg0;
            createNewLockForFolder_N89629025941251242292.arg1 = this.arg1;
            createNewLockForFolder_N89629025941251242292.arg2 = this.arg2;
            return createNewLockForFolder_N89629025941251242292;
        }
    }

    public static class commit_6802358189941774990
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public commit_6802358189941774990(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public commit_6802358189941774990(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public commit_6802358189941774990(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public commit_6802358189941774990() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$commit$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            commit_6802358189941774990 commit_68023581899417749902 = new commit_6802358189941774990(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            commit_68023581899417749902.arguments = this.arguments;
            ((InvocationBase)commit_68023581899417749902).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)commit_68023581899417749902).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)commit_68023581899417749902).instanceResolver = ((InvocationBase)this).instanceResolver;
            commit_68023581899417749902.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)commit_68023581899417749902).targetObject = ((InvocationBase)this).targetObject;
            commit_68023581899417749902.arg0 = this.arg0;
            return commit_68023581899417749902;
        }
    }

    public static class release_1620172324687511804
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public Folder arg1;
        public MailboxServiceImpl typedTargetObject;

        public release_1620172324687511804(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public release_1620172324687511804(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public release_1620172324687511804(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public release_1620172324687511804() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$release$aop(this.arg0, this.arg1);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (Folder)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            release_1620172324687511804 release_16201723246875118042 = new release_1620172324687511804(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            release_16201723246875118042.arguments = this.arguments;
            ((InvocationBase)release_16201723246875118042).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)release_16201723246875118042).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)release_16201723246875118042).instanceResolver = ((InvocationBase)this).instanceResolver;
            release_16201723246875118042.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)release_16201723246875118042).targetObject = ((InvocationBase)this).targetObject;
            release_16201723246875118042.arg0 = this.arg0;
            release_16201723246875118042.arg1 = this.arg1;
            return release_16201723246875118042;
        }
    }

    public static class getMailCountForFolder_N6834197920250729137
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailCountForFolder_N6834197920250729137(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailCountForFolder_N6834197920250729137(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailCountForFolder_N6834197920250729137(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailCountForFolder_N6834197920250729137() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailCountForFolder$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMailCountForFolder_N6834197920250729137 getMailCountForFolder_N68341979202507291372 = new getMailCountForFolder_N6834197920250729137(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailCountForFolder_N68341979202507291372.arguments = this.arguments;
            ((InvocationBase)getMailCountForFolder_N68341979202507291372).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailCountForFolder_N68341979202507291372).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailCountForFolder_N68341979202507291372).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailCountForFolder_N68341979202507291372.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailCountForFolder_N68341979202507291372).targetObject = ((InvocationBase)this).targetObject;
            getMailCountForFolder_N68341979202507291372.arg0 = this.arg0;
            return getMailCountForFolder_N68341979202507291372;
        }
    }

    public static class getMaxUid_N1578105451562726499
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMaxUid_N1578105451562726499(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMaxUid_N1578105451562726499(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMaxUid_N1578105451562726499(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMaxUid_N1578105451562726499() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMaxUid$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMaxUid_N1578105451562726499 getMaxUid_N15781054515627264992 = new getMaxUid_N1578105451562726499(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMaxUid_N15781054515627264992.arguments = this.arguments;
            ((InvocationBase)getMaxUid_N15781054515627264992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMaxUid_N15781054515627264992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMaxUid_N15781054515627264992).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMaxUid_N15781054515627264992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMaxUid_N15781054515627264992).targetObject = ((InvocationBase)this).targetObject;
            getMaxUid_N15781054515627264992.arg0 = this.arg0;
            return getMaxUid_N15781054515627264992;
        }
    }

    public static class getMailListForFolder_4138335292392595736
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public boolean arg1;
        public MailboxServiceImpl typedTargetObject;

        public getMailListForFolder_4138335292392595736(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailListForFolder_4138335292392595736(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailListForFolder_4138335292392595736(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailListForFolder_4138335292392595736() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailListForFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            this.arg1 = (Boolean)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Boolean(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            getMailListForFolder_4138335292392595736 getMailListForFolder_41383352923925957362 = new getMailListForFolder_4138335292392595736(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailListForFolder_41383352923925957362.arguments = this.arguments;
            ((InvocationBase)getMailListForFolder_41383352923925957362).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailListForFolder_41383352923925957362).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailListForFolder_41383352923925957362).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailListForFolder_41383352923925957362.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailListForFolder_41383352923925957362).targetObject = ((InvocationBase)this).targetObject;
            getMailListForFolder_41383352923925957362.arg0 = this.arg0;
            getMailListForFolder_41383352923925957362.arg1 = this.arg1;
            return getMailListForFolder_41383352923925957362;
        }
    }

    public static class getMessages_1624378364311083764
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public Range[] arg1;
        public boolean arg2;
        public MailboxServiceImpl typedTargetObject;

        public getMessages_1624378364311083764(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMessages_1624378364311083764(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMessages_1624378364311083764(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMessages_1624378364311083764() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessages$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (Range[])object2;
            this.arg2 = (Boolean)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Boolean(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getMessages_1624378364311083764 getMessages_16243783643110837642 = new getMessages_1624378364311083764(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMessages_16243783643110837642.arguments = this.arguments;
            ((InvocationBase)getMessages_16243783643110837642).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMessages_16243783643110837642).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMessages_16243783643110837642).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMessages_16243783643110837642.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMessages_16243783643110837642).targetObject = ((InvocationBase)this).targetObject;
            getMessages_16243783643110837642.arg0 = this.arg0;
            getMessages_16243783643110837642.arg1 = this.arg1;
            getMessages_16243783643110837642.arg2 = this.arg2;
            return getMessages_16243783643110837642;
        }
    }

    public static class getMailAt_N6648734355302922923
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public int arg1;
        public MailboxServiceImpl typedTargetObject;

        public getMailAt_N6648734355302922923(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailAt_N6648734355302922923(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailAt_N6648734355302922923(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailAt_N6648734355302922923() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailAt$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            this.arg1 = (Integer)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            getMailAt_N6648734355302922923 getMailAt_N66487343553029229232 = new getMailAt_N6648734355302922923(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailAt_N66487343553029229232.arguments = this.arguments;
            ((InvocationBase)getMailAt_N66487343553029229232).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailAt_N66487343553029229232).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailAt_N66487343553029229232).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailAt_N66487343553029229232.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailAt_N66487343553029229232).targetObject = ((InvocationBase)this).targetObject;
            getMailAt_N66487343553029229232.arg0 = this.arg0;
            getMailAt_N66487343553029229232.arg1 = this.arg1;
            return getMailAt_N66487343553029229232;
        }
    }

    public static class markDeleted_5934752999000964186
    extends MethodInvocation
    implements Untransformable {
        public Mailbox arg0;
        public int arg1;
        public MailboxServiceImpl typedTargetObject;

        public markDeleted_5934752999000964186(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public markDeleted_5934752999000964186(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public markDeleted_5934752999000964186(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public markDeleted_5934752999000964186() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$markDeleted$aop(this.arg0, this.arg1));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Mailbox)object;
            this.arg1 = (Integer)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            markDeleted_5934752999000964186 markDeleted_59347529990009641862 = new markDeleted_5934752999000964186(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            markDeleted_59347529990009641862.arguments = this.arguments;
            ((InvocationBase)markDeleted_59347529990009641862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)markDeleted_59347529990009641862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)markDeleted_59347529990009641862).instanceResolver = ((InvocationBase)this).instanceResolver;
            markDeleted_59347529990009641862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)markDeleted_59347529990009641862).targetObject = ((InvocationBase)this).targetObject;
            markDeleted_59347529990009641862.arg0 = this.arg0;
            markDeleted_59347529990009641862.arg1 = this.arg1;
            return markDeleted_59347529990009641862;
        }
    }

    public static class deleteMarked_N7319567664623845061
    extends MethodInvocation
    implements Untransformable {
        public Mailbox arg0;
        public MailboxServiceImpl typedTargetObject;

        public deleteMarked_N7319567664623845061(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteMarked_N7319567664623845061(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteMarked_N7319567664623845061(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteMarked_N7319567664623845061() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMarked$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Mailbox)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            deleteMarked_N7319567664623845061 deleteMarked_N73195676646238450612 = new deleteMarked_N7319567664623845061(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteMarked_N73195676646238450612.arguments = this.arguments;
            ((InvocationBase)deleteMarked_N73195676646238450612).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteMarked_N73195676646238450612).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteMarked_N73195676646238450612).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteMarked_N73195676646238450612.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteMarked_N73195676646238450612).targetObject = ((InvocationBase)this).targetObject;
            deleteMarked_N73195676646238450612.arg0 = this.arg0;
            return deleteMarked_N73195676646238450612;
        }
    }

    public static class unmarkDeleted_1914944057986980756
    extends MethodInvocation
    implements Untransformable {
        public Mailbox arg0;
        public MailboxServiceImpl typedTargetObject;

        public unmarkDeleted_1914944057986980756(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public unmarkDeleted_1914944057986980756(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public unmarkDeleted_1914944057986980756(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public unmarkDeleted_1914944057986980756() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$unmarkDeleted$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Mailbox)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            unmarkDeleted_1914944057986980756 unmarkDeleted_19149440579869807562 = new unmarkDeleted_1914944057986980756(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            unmarkDeleted_19149440579869807562.arguments = this.arguments;
            ((InvocationBase)unmarkDeleted_19149440579869807562).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)unmarkDeleted_19149440579869807562).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)unmarkDeleted_19149440579869807562).instanceResolver = ((InvocationBase)this).instanceResolver;
            unmarkDeleted_19149440579869807562.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)unmarkDeleted_19149440579869807562).targetObject = ((InvocationBase)this).targetObject;
            unmarkDeleted_19149440579869807562.arg0 = this.arg0;
            return unmarkDeleted_19149440579869807562;
        }
    }

    public static class getMailboxIdByAlias_N4145491549460421805
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMailboxIdByAlias_N4145491549460421805(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMailboxIdByAlias_N4145491549460421805(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMailboxIdByAlias_N4145491549460421805(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMailboxIdByAlias_N4145491549460421805() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Long(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMailboxIdByAlias$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getMailboxIdByAlias_N4145491549460421805 getMailboxIdByAlias_N41454915494604218052 = new getMailboxIdByAlias_N4145491549460421805(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMailboxIdByAlias_N41454915494604218052.arguments = this.arguments;
            ((InvocationBase)getMailboxIdByAlias_N41454915494604218052).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMailboxIdByAlias_N41454915494604218052).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMailboxIdByAlias_N41454915494604218052).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMailboxIdByAlias_N41454915494604218052.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMailboxIdByAlias_N41454915494604218052).targetObject = ((InvocationBase)this).targetObject;
            getMailboxIdByAlias_N41454915494604218052.arg0 = this.arg0;
            return getMailboxIdByAlias_N41454915494604218052;
        }
    }

    public static class createAlias_968917090120825244
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public String arg1;
        public MailboxServiceImpl typedTargetObject;

        public createAlias_968917090120825244(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createAlias_968917090120825244(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createAlias_968917090120825244(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createAlias_968917090120825244() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Boolean(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$createAlias$aop(this.arg0, this.arg1));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            Object object = objectArray[1];
            this.arg1 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            new Long(this.arg0);
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            createAlias_968917090120825244 createAlias_9689170901208252442 = new createAlias_968917090120825244(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            createAlias_9689170901208252442.arguments = this.arguments;
            ((InvocationBase)createAlias_9689170901208252442).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)createAlias_9689170901208252442).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)createAlias_9689170901208252442).instanceResolver = ((InvocationBase)this).instanceResolver;
            createAlias_9689170901208252442.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)createAlias_9689170901208252442).targetObject = ((InvocationBase)this).targetObject;
            createAlias_9689170901208252442.arg0 = this.arg0;
            createAlias_9689170901208252442.arg1 = this.arg1;
            return createAlias_9689170901208252442;
        }
    }

    public static class getSubfolderByName_6112040871602112999
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String arg1;
        public MailboxServiceImpl typedTargetObject;

        public getSubfolderByName_6112040871602112999(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getSubfolderByName_6112040871602112999(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getSubfolderByName_6112040871602112999(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getSubfolderByName_6112040871602112999() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByName$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getSubfolderByName_6112040871602112999 getSubfolderByName_61120408716021129992 = new getSubfolderByName_6112040871602112999(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getSubfolderByName_61120408716021129992.arguments = this.arguments;
            ((InvocationBase)getSubfolderByName_61120408716021129992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getSubfolderByName_61120408716021129992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getSubfolderByName_61120408716021129992).instanceResolver = ((InvocationBase)this).instanceResolver;
            getSubfolderByName_61120408716021129992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getSubfolderByName_61120408716021129992).targetObject = ((InvocationBase)this).targetObject;
            getSubfolderByName_61120408716021129992.arg0 = this.arg0;
            getSubfolderByName_61120408716021129992.arg1 = this.arg1;
            return getSubfolderByName_61120408716021129992;
        }
    }

    public static class getSubfolders_8285920828106536306
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getSubfolders_8285920828106536306(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getSubfolders_8285920828106536306(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getSubfolders_8285920828106536306(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getSubfolders_8285920828106536306() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getSubfolders_8285920828106536306 getSubfolders_82859208281065363062 = new getSubfolders_8285920828106536306(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getSubfolders_82859208281065363062.arguments = this.arguments;
            ((InvocationBase)getSubfolders_82859208281065363062).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getSubfolders_82859208281065363062).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getSubfolders_82859208281065363062).instanceResolver = ((InvocationBase)this).instanceResolver;
            getSubfolders_82859208281065363062.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getSubfolders_82859208281065363062).targetObject = ((InvocationBase)this).targetObject;
            getSubfolders_82859208281065363062.arg0 = this.arg0;
            return getSubfolders_82859208281065363062;
        }
    }

    public static class getSubfolders_677140112798081686
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String[] arg1;
        public FolderFilter arg2;
        public MailboxServiceImpl typedTargetObject;

        public getSubfolders_677140112798081686(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getSubfolders_677140112798081686(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getSubfolders_677140112798081686(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getSubfolders_677140112798081686() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolders$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String[])object2;
            Object object3 = objectArray[2];
            this.arg2 = (FolderFilter)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            getSubfolders_677140112798081686 getSubfolders_6771401127980816862 = new getSubfolders_677140112798081686(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getSubfolders_6771401127980816862.arguments = this.arguments;
            ((InvocationBase)getSubfolders_6771401127980816862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getSubfolders_6771401127980816862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getSubfolders_6771401127980816862).instanceResolver = ((InvocationBase)this).instanceResolver;
            getSubfolders_6771401127980816862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getSubfolders_6771401127980816862).targetObject = ((InvocationBase)this).targetObject;
            getSubfolders_6771401127980816862.arg0 = this.arg0;
            getSubfolders_6771401127980816862.arg1 = this.arg1;
            getSubfolders_6771401127980816862.arg2 = this.arg2;
            return getSubfolders_6771401127980816862;
        }
    }

    public static class getRecentCountForFolder_N703713320950335564
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getRecentCountForFolder_N703713320950335564(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getRecentCountForFolder_N703713320950335564(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getRecentCountForFolder_N703713320950335564(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getRecentCountForFolder_N703713320950335564() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getRecentCountForFolder$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getRecentCountForFolder_N703713320950335564 getRecentCountForFolder_N7037133209503355642 = new getRecentCountForFolder_N703713320950335564(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getRecentCountForFolder_N7037133209503355642.arguments = this.arguments;
            ((InvocationBase)getRecentCountForFolder_N7037133209503355642).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getRecentCountForFolder_N7037133209503355642).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getRecentCountForFolder_N7037133209503355642).instanceResolver = ((InvocationBase)this).instanceResolver;
            getRecentCountForFolder_N7037133209503355642.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getRecentCountForFolder_N7037133209503355642).targetObject = ((InvocationBase)this).targetObject;
            getRecentCountForFolder_N7037133209503355642.arg0 = this.arg0;
            return getRecentCountForFolder_N7037133209503355642;
        }
    }

    public static class getLikelyUID_2299057798449282556
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getLikelyUID_2299057798449282556(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getLikelyUID_2299057798449282556(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getLikelyUID_2299057798449282556(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getLikelyUID_2299057798449282556() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Long(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getLikelyUID$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getLikelyUID_2299057798449282556 getLikelyUID_22990577984492825562 = new getLikelyUID_2299057798449282556(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getLikelyUID_22990577984492825562.arguments = this.arguments;
            ((InvocationBase)getLikelyUID_22990577984492825562).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getLikelyUID_22990577984492825562).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getLikelyUID_22990577984492825562).instanceResolver = ((InvocationBase)this).instanceResolver;
            getLikelyUID_22990577984492825562.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getLikelyUID_22990577984492825562).targetObject = ((InvocationBase)this).targetObject;
            getLikelyUID_22990577984492825562.arg0 = this.arg0;
            return getLikelyUID_22990577984492825562;
        }
    }

    public static class updateMessageMetaData_1812264909449898229
    extends MethodInvocation
    implements Untransformable {
        public MessageData arg0;
        public MailboxServiceImpl typedTargetObject;

        public updateMessageMetaData_1812264909449898229(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public updateMessageMetaData_1812264909449898229(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public updateMessageMetaData_1812264909449898229(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public updateMessageMetaData_1812264909449898229() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$updateMessageMetaData$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            updateMessageMetaData_1812264909449898229 updateMessageMetaData_18122649094498982292 = new updateMessageMetaData_1812264909449898229(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            updateMessageMetaData_18122649094498982292.arguments = this.arguments;
            ((InvocationBase)updateMessageMetaData_18122649094498982292).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)updateMessageMetaData_18122649094498982292).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)updateMessageMetaData_18122649094498982292).instanceResolver = ((InvocationBase)this).instanceResolver;
            updateMessageMetaData_18122649094498982292.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)updateMessageMetaData_18122649094498982292).targetObject = ((InvocationBase)this).targetObject;
            updateMessageMetaData_18122649094498982292.arg0 = this.arg0;
            return updateMessageMetaData_18122649094498982292;
        }
    }

    public static class copy_N5063802630492799710
    extends MethodInvocation
    implements Untransformable {
        public MessageData arg0;
        public Folder arg1;
        public Folder arg2;
        public MailboxServiceImpl typedTargetObject;

        public copy_N5063802630492799710(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public copy_N5063802630492799710(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public copy_N5063802630492799710(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public copy_N5063802630492799710() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(this.arg0, this.arg1, this.arg2);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageData)object;
            Object object2 = objectArray[1];
            this.arg1 = (Folder)object2;
            Object object3 = objectArray[2];
            this.arg2 = (Folder)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            copy_N5063802630492799710 copy_N50638026304927997102 = new copy_N5063802630492799710(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            copy_N50638026304927997102.arguments = this.arguments;
            ((InvocationBase)copy_N50638026304927997102).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)copy_N50638026304927997102).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)copy_N50638026304927997102).instanceResolver = ((InvocationBase)this).instanceResolver;
            copy_N50638026304927997102.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)copy_N50638026304927997102).targetObject = ((InvocationBase)this).targetObject;
            copy_N50638026304927997102.arg0 = this.arg0;
            copy_N50638026304927997102.arg1 = this.arg1;
            copy_N50638026304927997102.arg2 = this.arg2;
            return copy_N50638026304927997102;
        }
    }

    public static class copy_N5706638977282021959
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MessageData arg1;
        public MailboxServiceImpl typedTargetObject;

        public copy_N5706638977282021959(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public copy_N5706638977282021959(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public copy_N5706638977282021959(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public copy_N5706638977282021959() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$copy$aop(this.arg0, this.arg1);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            Object object = objectArray[1];
            this.arg1 = (MessageData)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            new Long(this.arg0);
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            copy_N5706638977282021959 copy_N57066389772820219592 = new copy_N5706638977282021959(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            copy_N57066389772820219592.arguments = this.arguments;
            ((InvocationBase)copy_N57066389772820219592).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)copy_N57066389772820219592).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)copy_N57066389772820219592).instanceResolver = ((InvocationBase)this).instanceResolver;
            copy_N57066389772820219592.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)copy_N57066389772820219592).targetObject = ((InvocationBase)this).targetObject;
            copy_N57066389772820219592.arg0 = this.arg0;
            copy_N57066389772820219592.arg1 = this.arg1;
            return copy_N57066389772820219592;
        }
    }

    public static class folderSummary_N7462638425403645780
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public folderSummary_N7462638425403645780(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public folderSummary_N7462638425403645780(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public folderSummary_N7462638425403645780(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public folderSummary_N7462638425403645780() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$folderSummary$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            folderSummary_N7462638425403645780 folderSummary_N74626384254036457802 = new folderSummary_N7462638425403645780(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            folderSummary_N74626384254036457802.arguments = this.arguments;
            ((InvocationBase)folderSummary_N74626384254036457802).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)folderSummary_N74626384254036457802).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)folderSummary_N74626384254036457802).instanceResolver = ((InvocationBase)this).instanceResolver;
            folderSummary_N74626384254036457802.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)folderSummary_N74626384254036457802).targetObject = ((InvocationBase)this).targetObject;
            folderSummary_N74626384254036457802.arg0 = this.arg0;
            return folderSummary_N74626384254036457802;
        }
    }

    public static class retSummary_9179350348051872086
    extends MethodInvocation
    implements Untransformable {
        public Node arg0;
        public MailboxServiceImpl typedTargetObject;

        public retSummary_9179350348051872086(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public retSummary_9179350348051872086(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public retSummary_9179350348051872086(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public retSummary_9179350348051872086() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$retSummary$aop((Node<FolderSummary>)this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Node)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            retSummary_9179350348051872086 retSummary_91793503480518720862 = new retSummary_9179350348051872086(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            retSummary_91793503480518720862.arguments = this.arguments;
            ((InvocationBase)retSummary_91793503480518720862).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)retSummary_91793503480518720862).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)retSummary_91793503480518720862).instanceResolver = ((InvocationBase)this).instanceResolver;
            retSummary_91793503480518720862.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)retSummary_91793503480518720862).targetObject = ((InvocationBase)this).targetObject;
            retSummary_91793503480518720862.arg0 = this.arg0;
            return retSummary_91793503480518720862;
        }
    }

    public static class expunge_5409646354199440601
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public boolean arg1;
        public MailboxServiceImpl typedTargetObject;

        public expunge_5409646354199440601(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public expunge_5409646354199440601(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public expunge_5409646354199440601(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public expunge_5409646354199440601() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$expunge$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            this.arg1 = (Boolean)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Boolean(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            expunge_5409646354199440601 expunge_54096463541994406012 = new expunge_5409646354199440601(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            expunge_54096463541994406012.arguments = this.arguments;
            ((InvocationBase)expunge_54096463541994406012).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)expunge_54096463541994406012).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)expunge_54096463541994406012).instanceResolver = ((InvocationBase)this).instanceResolver;
            expunge_54096463541994406012.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)expunge_54096463541994406012).targetObject = ((InvocationBase)this).targetObject;
            expunge_54096463541994406012.arg0 = this.arg0;
            expunge_54096463541994406012.arg1 = this.arg1;
            return expunge_54096463541994406012;
        }
    }

    public static class getMail_N68618239099411182
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public getMail_N68618239099411182(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMail_N68618239099411182(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMail_N68618239099411182(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMail_N68618239099411182() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMail$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getMail_N68618239099411182 getMail_N686182390994111822 = new getMail_N68618239099411182(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMail_N686182390994111822.arguments = this.arguments;
            ((InvocationBase)getMail_N686182390994111822).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMail_N686182390994111822).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMail_N686182390994111822).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMail_N686182390994111822.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMail_N686182390994111822).targetObject = ((InvocationBase)this).targetObject;
            getMail_N686182390994111822.arg0 = this.arg0;
            return getMail_N686182390994111822;
        }
    }

    public static class fastExpunge_4919076391455760194
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public fastExpunge_4919076391455760194(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public fastExpunge_4919076391455760194(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public fastExpunge_4919076391455760194(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public fastExpunge_4919076391455760194() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$fastExpunge$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            fastExpunge_4919076391455760194 fastExpunge_49190763914557601942 = new fastExpunge_4919076391455760194(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            fastExpunge_49190763914557601942.arguments = this.arguments;
            ((InvocationBase)fastExpunge_49190763914557601942).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)fastExpunge_49190763914557601942).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)fastExpunge_49190763914557601942).instanceResolver = ((InvocationBase)this).instanceResolver;
            fastExpunge_49190763914557601942.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)fastExpunge_49190763914557601942).targetObject = ((InvocationBase)this).targetObject;
            fastExpunge_49190763914557601942.arg0 = this.arg0;
            return fastExpunge_49190763914557601942;
        }
    }

    public static class getCountReferencingBody_N9154764769953758522
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public getCountReferencingBody_N9154764769953758522(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getCountReferencingBody_N9154764769953758522(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getCountReferencingBody_N9154764769953758522(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getCountReferencingBody_N9154764769953758522() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getCountReferencingBody$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            getCountReferencingBody_N9154764769953758522 getCountReferencingBody_N91547647699537585222 = new getCountReferencingBody_N9154764769953758522(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getCountReferencingBody_N91547647699537585222.arguments = this.arguments;
            ((InvocationBase)getCountReferencingBody_N91547647699537585222).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getCountReferencingBody_N91547647699537585222).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getCountReferencingBody_N91547647699537585222).instanceResolver = ((InvocationBase)this).instanceResolver;
            getCountReferencingBody_N91547647699537585222.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getCountReferencingBody_N91547647699537585222).targetObject = ((InvocationBase)this).targetObject;
            getCountReferencingBody_N91547647699537585222.arg0 = this.arg0;
            return getCountReferencingBody_N91547647699537585222;
        }
    }

    public static class getUnseenCountForFolder_N6283046278616930205
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getUnseenCountForFolder_N6283046278616930205(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getUnseenCountForFolder_N6283046278616930205(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getUnseenCountForFolder_N6283046278616930205(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getUnseenCountForFolder_N6283046278616930205() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getUnseenCountForFolder$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getUnseenCountForFolder_N6283046278616930205 getUnseenCountForFolder_N62830462786169302052 = new getUnseenCountForFolder_N6283046278616930205(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getUnseenCountForFolder_N62830462786169302052.arguments = this.arguments;
            ((InvocationBase)getUnseenCountForFolder_N62830462786169302052).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getUnseenCountForFolder_N62830462786169302052).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getUnseenCountForFolder_N62830462786169302052).instanceResolver = ((InvocationBase)this).instanceResolver;
            getUnseenCountForFolder_N62830462786169302052.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getUnseenCountForFolder_N62830462786169302052).targetObject = ((InvocationBase)this).targetObject;
            getUnseenCountForFolder_N62830462786169302052.arg0 = this.arg0;
            return getUnseenCountForFolder_N62830462786169302052;
        }
    }

    public static class getFirstUnseen_N5587371301290562644
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getFirstUnseen_N5587371301290562644(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getFirstUnseen_N5587371301290562644(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getFirstUnseen_N5587371301290562644(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getFirstUnseen_N5587371301290562644() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Long(this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getFirstUnseen$aop(this.arg0));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getFirstUnseen_N5587371301290562644 getFirstUnseen_N55873713012905626442 = new getFirstUnseen_N5587371301290562644(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getFirstUnseen_N55873713012905626442.arguments = this.arguments;
            ((InvocationBase)getFirstUnseen_N55873713012905626442).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getFirstUnseen_N55873713012905626442).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getFirstUnseen_N55873713012905626442).instanceResolver = ((InvocationBase)this).instanceResolver;
            getFirstUnseen_N55873713012905626442.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getFirstUnseen_N55873713012905626442).targetObject = ((InvocationBase)this).targetObject;
            getFirstUnseen_N55873713012905626442.arg0 = this.arg0;
            return getFirstUnseen_N55873713012905626442;
        }
    }

    public static class moveFolder_1391768566440483274
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public Folder arg1;
        public String arg2;
        public MailboxServiceImpl typedTargetObject;

        public moveFolder_1391768566440483274(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public moveFolder_1391768566440483274(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public moveFolder_1391768566440483274(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public moveFolder_1391768566440483274() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (Folder)object2;
            Object object3 = objectArray[2];
            this.arg2 = (String)object3;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            this.arguments[2] = this.arg2;
            return this.arguments;
        }

        public Invocation copy() {
            moveFolder_1391768566440483274 moveFolder_13917685664404832742 = new moveFolder_1391768566440483274(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            moveFolder_13917685664404832742.arguments = this.arguments;
            ((InvocationBase)moveFolder_13917685664404832742).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)moveFolder_13917685664404832742).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)moveFolder_13917685664404832742).instanceResolver = ((InvocationBase)this).instanceResolver;
            moveFolder_13917685664404832742.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)moveFolder_13917685664404832742).targetObject = ((InvocationBase)this).targetObject;
            moveFolder_13917685664404832742.arg0 = this.arg0;
            moveFolder_13917685664404832742.arg1 = this.arg1;
            moveFolder_13917685664404832742.arg2 = this.arg2;
            return moveFolder_13917685664404832742;
        }
    }

    public static class moveFolder_N2048023763802867480
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String[] arg1;
        public MailboxServiceImpl typedTargetObject;

        public moveFolder_N2048023763802867480(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public moveFolder_N2048023763802867480(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public moveFolder_N2048023763802867480(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public moveFolder_N2048023763802867480() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$moveFolder$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String[])object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            moveFolder_N2048023763802867480 moveFolder_N20480237638028674802 = new moveFolder_N2048023763802867480(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            moveFolder_N20480237638028674802.arguments = this.arguments;
            ((InvocationBase)moveFolder_N20480237638028674802).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)moveFolder_N20480237638028674802).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)moveFolder_N20480237638028674802).instanceResolver = ((InvocationBase)this).instanceResolver;
            moveFolder_N20480237638028674802.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)moveFolder_N20480237638028674802).targetObject = ((InvocationBase)this).targetObject;
            moveFolder_N20480237638028674802.arg0 = this.arg0;
            moveFolder_N20480237638028674802.arg1 = this.arg1;
            return moveFolder_N20480237638028674802;
        }
    }

    public static class getPathFor_N8886049787943587193
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public getPathFor_N8886049787943587193(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getPathFor_N8886049787943587193(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getPathFor_N8886049787943587193(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getPathFor_N8886049787943587193() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getPathFor$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getPathFor_N8886049787943587193 getPathFor_N88860497879435871932 = new getPathFor_N8886049787943587193(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getPathFor_N88860497879435871932.arguments = this.arguments;
            ((InvocationBase)getPathFor_N88860497879435871932).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getPathFor_N88860497879435871932).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getPathFor_N88860497879435871932).instanceResolver = ((InvocationBase)this).instanceResolver;
            getPathFor_N88860497879435871932.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getPathFor_N88860497879435871932).targetObject = ((InvocationBase)this).targetObject;
            getPathFor_N88860497879435871932.arg0 = this.arg0;
            return getPathFor_N88860497879435871932;
        }
    }

    public static class deleteMessage_N9198329699081340556
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public MailboxServiceImpl typedTargetObject;

        public deleteMessage_N9198329699081340556(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteMessage_N9198329699081340556(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteMessage_N9198329699081340556(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteMessage_N9198329699081340556() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteMessage$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            new Long(this.arg0);
            return this.arguments;
        }

        public Invocation copy() {
            deleteMessage_N9198329699081340556 deleteMessage_N91983296990813405562 = new deleteMessage_N9198329699081340556(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteMessage_N91983296990813405562.arguments = this.arguments;
            ((InvocationBase)deleteMessage_N91983296990813405562).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteMessage_N91983296990813405562).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteMessage_N91983296990813405562).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteMessage_N91983296990813405562.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteMessage_N91983296990813405562).targetObject = ((InvocationBase)this).targetObject;
            deleteMessage_N91983296990813405562.arg0 = this.arg0;
            return deleteMessage_N91983296990813405562;
        }
    }

    public static class deleteFolder_N7601395062060664724
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public MailboxServiceImpl typedTargetObject;

        public deleteFolder_N7601395062060664724(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteFolder_N7601395062060664724(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteFolder_N7601395062060664724(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteFolder_N7601395062060664724() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteFolder$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            deleteFolder_N7601395062060664724 deleteFolder_N76013950620606647242 = new deleteFolder_N7601395062060664724(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteFolder_N76013950620606647242.arguments = this.arguments;
            ((InvocationBase)deleteFolder_N76013950620606647242).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteFolder_N76013950620606647242).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteFolder_N76013950620606647242).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteFolder_N76013950620606647242.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteFolder_N76013950620606647242).targetObject = ((InvocationBase)this).targetObject;
            deleteFolder_N76013950620606647242.arg0 = this.arg0;
            return deleteFolder_N76013950620606647242;
        }
    }

    public static class getSubfolderByPath_N8428708415463439975
    extends MethodInvocation
    implements Untransformable {
        public Folder arg0;
        public String[] arg1;
        public MailboxServiceImpl typedTargetObject;

        public getSubfolderByPath_N8428708415463439975(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getSubfolderByPath_N8428708415463439975(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getSubfolderByPath_N8428708415463439975(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getSubfolderByPath_N8428708415463439975() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getSubfolderByPath$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Folder)object;
            Object object2 = objectArray[1];
            this.arg1 = (String[])object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getSubfolderByPath_N8428708415463439975 getSubfolderByPath_N84287084154634399752 = new getSubfolderByPath_N8428708415463439975(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getSubfolderByPath_N84287084154634399752.arguments = this.arguments;
            ((InvocationBase)getSubfolderByPath_N84287084154634399752).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getSubfolderByPath_N84287084154634399752).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getSubfolderByPath_N84287084154634399752).instanceResolver = ((InvocationBase)this).instanceResolver;
            getSubfolderByPath_N84287084154634399752.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getSubfolderByPath_N84287084154634399752).targetObject = ((InvocationBase)this).targetObject;
            getSubfolderByPath_N84287084154634399752.arg0 = this.arg0;
            getSubfolderByPath_N84287084154634399752.arg1 = this.arg1;
            return getSubfolderByPath_N84287084154634399752;
        }
    }

    public static class getMessageBody_N9074101858728972783
    extends MethodInvocation
    implements Untransformable {
        public MessageData arg0;
        public int arg1;
        public MailboxServiceImpl typedTargetObject;

        public getMessageBody_N9074101858728972783(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMessageBody_N9074101858728972783(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMessageBody_N9074101858728972783(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMessageBody_N9074101858728972783() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageData)object;
            this.arg1 = (Integer)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            getMessageBody_N9074101858728972783 getMessageBody_N90741018587289727832 = new getMessageBody_N9074101858728972783(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMessageBody_N90741018587289727832.arguments = this.arguments;
            ((InvocationBase)getMessageBody_N90741018587289727832).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMessageBody_N90741018587289727832).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMessageBody_N90741018587289727832).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMessageBody_N90741018587289727832.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMessageBody_N90741018587289727832).targetObject = ((InvocationBase)this).targetObject;
            getMessageBody_N90741018587289727832.arg0 = this.arg0;
            getMessageBody_N90741018587289727832.arg1 = this.arg1;
            return getMessageBody_N90741018587289727832;
        }
    }

    public static class getMessageBody_N6809412181622339899
    extends MethodInvocation
    implements Untransformable {
        public MessageBody arg0;
        public int arg1;
        public MailboxServiceImpl typedTargetObject;

        public getMessageBody_N6809412181622339899(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getMessageBody_N6809412181622339899(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getMessageBody_N6809412181622339899(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getMessageBody_N6809412181622339899() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getMessageBody$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (MessageBody)object;
            this.arg1 = (Integer)objectArray[1];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            new Integer(this.arg1);
            return this.arguments;
        }

        public Invocation copy() {
            getMessageBody_N6809412181622339899 getMessageBody_N68094121816223398992 = new getMessageBody_N6809412181622339899(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getMessageBody_N68094121816223398992.arguments = this.arguments;
            ((InvocationBase)getMessageBody_N68094121816223398992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getMessageBody_N68094121816223398992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getMessageBody_N68094121816223398992).instanceResolver = ((InvocationBase)this).instanceResolver;
            getMessageBody_N68094121816223398992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getMessageBody_N68094121816223398992).targetObject = ((InvocationBase)this).targetObject;
            getMessageBody_N68094121816223398992.arg0 = this.arg0;
            getMessageBody_N68094121816223398992.arg1 = this.arg1;
            return getMessageBody_N68094121816223398992;
        }
    }

    public static class mimePrintMessage_N2211963482245601720
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public boolean arg1;
        public OutputStream arg2;
        public Copier arg3;
        public MailboxServiceImpl typedTargetObject;

        public mimePrintMessage_N2211963482245601720(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public mimePrintMessage_N2211963482245601720(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public mimePrintMessage_N2211963482245601720(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public mimePrintMessage_N2211963482245601720() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintMessage$aop(this.arg0, this.arg1, this.arg2, this.arg3);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            this.arg1 = (Boolean)objectArray[1];
            Object object = objectArray[2];
            this.arg2 = (OutputStream)object;
            Object object2 = objectArray[3];
            this.arg3 = (Copier)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[4];
            new Long(this.arg0);
            new Boolean(this.arg1);
            this.arguments[2] = this.arg2;
            this.arguments[3] = this.arg3;
            return this.arguments;
        }

        public Invocation copy() {
            mimePrintMessage_N2211963482245601720 mimePrintMessage_N22119634822456017202 = new mimePrintMessage_N2211963482245601720(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            mimePrintMessage_N22119634822456017202.arguments = this.arguments;
            ((InvocationBase)mimePrintMessage_N22119634822456017202).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)mimePrintMessage_N22119634822456017202).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)mimePrintMessage_N22119634822456017202).instanceResolver = ((InvocationBase)this).instanceResolver;
            mimePrintMessage_N22119634822456017202.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)mimePrintMessage_N22119634822456017202).targetObject = ((InvocationBase)this).targetObject;
            mimePrintMessage_N22119634822456017202.arg0 = this.arg0;
            mimePrintMessage_N22119634822456017202.arg1 = this.arg1;
            mimePrintMessage_N22119634822456017202.arg2 = this.arg2;
            mimePrintMessage_N22119634822456017202.arg3 = this.arg3;
            return mimePrintMessage_N22119634822456017202;
        }
    }

    public static class mimePrintBody_3264814303130705280
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public boolean arg1;
        public OutputStream arg2;
        public Copier arg3;
        public MailboxServiceImpl typedTargetObject;

        public mimePrintBody_3264814303130705280(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public mimePrintBody_3264814303130705280(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public mimePrintBody_3264814303130705280(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public mimePrintBody_3264814303130705280() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$mimePrintBody$aop(this.arg0, this.arg1, this.arg2, this.arg3);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            this.arg1 = (Boolean)objectArray[1];
            Object object = objectArray[2];
            this.arg2 = (OutputStream)object;
            Object object2 = objectArray[3];
            this.arg3 = (Copier)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[4];
            new Long(this.arg0);
            new Boolean(this.arg1);
            this.arguments[2] = this.arg2;
            this.arguments[3] = this.arg3;
            return this.arguments;
        }

        public Invocation copy() {
            mimePrintBody_3264814303130705280 mimePrintBody_32648143031307052802 = new mimePrintBody_3264814303130705280(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            mimePrintBody_32648143031307052802.arguments = this.arguments;
            ((InvocationBase)mimePrintBody_32648143031307052802).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)mimePrintBody_32648143031307052802).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)mimePrintBody_32648143031307052802).instanceResolver = ((InvocationBase)this).instanceResolver;
            mimePrintBody_32648143031307052802.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)mimePrintBody_32648143031307052802).targetObject = ((InvocationBase)this).targetObject;
            mimePrintBody_32648143031307052802.arg0 = this.arg0;
            mimePrintBody_32648143031307052802.arg1 = this.arg1;
            mimePrintBody_32648143031307052802.arg2 = this.arg2;
            mimePrintBody_32648143031307052802.arg3 = this.arg3;
            return mimePrintBody_32648143031307052802;
        }
    }

    public static class printMessage_2704115281852340060
    extends MethodInvocation
    implements Untransformable {
        public long arg0;
        public boolean arg1;
        public OutputStream arg2;
        public Copier arg3;
        public MailboxServiceImpl typedTargetObject;

        public printMessage_2704115281852340060(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public printMessage_2704115281852340060(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public printMessage_2704115281852340060(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public printMessage_2704115281852340060() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$printMessage$aop(this.arg0, this.arg1, this.arg2, this.arg3);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            this.arg0 = (Long)objectArray[0];
            this.arg1 = (Boolean)objectArray[1];
            Object object = objectArray[2];
            this.arg2 = (OutputStream)object;
            Object object2 = objectArray[3];
            this.arg3 = (Copier)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[4];
            new Long(this.arg0);
            new Boolean(this.arg1);
            this.arguments[2] = this.arg2;
            this.arguments[3] = this.arg3;
            return this.arguments;
        }

        public Invocation copy() {
            printMessage_2704115281852340060 printMessage_27041152818523400602 = new printMessage_2704115281852340060(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            printMessage_27041152818523400602.arguments = this.arguments;
            ((InvocationBase)printMessage_27041152818523400602).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)printMessage_27041152818523400602).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)printMessage_27041152818523400602).instanceResolver = ((InvocationBase)this).instanceResolver;
            printMessage_27041152818523400602.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)printMessage_27041152818523400602).targetObject = ((InvocationBase)this).targetObject;
            printMessage_27041152818523400602.arg0 = this.arg0;
            printMessage_27041152818523400602.arg1 = this.arg1;
            printMessage_27041152818523400602.arg2 = this.arg2;
            printMessage_27041152818523400602.arg3 = this.arg3;
            return printMessage_27041152818523400602;
        }
    }

    public static class getAliases_7896895568457778935
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public MailboxServiceImpl typedTargetObject;

        public getAliases_7896895568457778935(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getAliases_7896895568457778935(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getAliases_7896895568457778935(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getAliases_7896895568457778935() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$getAliases$aop(this.arg0);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            getAliases_7896895568457778935 getAliases_78968955684577789352 = new getAliases_7896895568457778935(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getAliases_78968955684577789352.arguments = this.arguments;
            ((InvocationBase)getAliases_78968955684577789352).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getAliases_78968955684577789352).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getAliases_78968955684577789352).instanceResolver = ((InvocationBase)this).instanceResolver;
            getAliases_78968955684577789352.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getAliases_78968955684577789352).targetObject = ((InvocationBase)this).targetObject;
            getAliases_78968955684577789352.arg0 = this.arg0;
            return getAliases_78968955684577789352;
        }
    }

    public static class deleteAlias_N7340062284907121816
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public MailboxServiceImpl typedTargetObject;

        public deleteAlias_N7340062284907121816(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public deleteAlias_N7340062284907121816(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public deleteAlias_N7340062284907121816(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public deleteAlias_N7340062284907121816() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$mailbox$MailboxServiceImpl$deleteAlias$aop(this.arg0, this.arg1);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            deleteAlias_N7340062284907121816 deleteAlias_N73400622849071218162 = new deleteAlias_N7340062284907121816(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            deleteAlias_N73400622849071218162.arguments = this.arguments;
            ((InvocationBase)deleteAlias_N73400622849071218162).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)deleteAlias_N73400622849071218162).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)deleteAlias_N73400622849071218162).instanceResolver = ((InvocationBase)this).instanceResolver;
            deleteAlias_N73400622849071218162.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)deleteAlias_N73400622849071218162).targetObject = ((InvocationBase)this).targetObject;
            deleteAlias_N73400622849071218162.arg0 = this.arg0;
            deleteAlias_N73400622849071218162.arg1 = this.arg1;
            return deleteAlias_N73400622849071218162;
        }
    }
}

