/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.maillistener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListenerChain;
import org.buni.meldware.mail.maillist.MailList;
import org.buni.meldware.mail.maillist.MailListManager;
import org.buni.meldware.mail.maillist.MailListProperties;
import org.buni.meldware.mail.maillistener.MailListDeliveryMBean;
import org.buni.meldware.mail.message.Mail;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.Message;

public class MailListDelivery
implements MailListDeliveryMBean {
    private static final Logger log = Logger.getLogger(MailListDelivery.class);
    private MailListManager mgr;
    private MailListenerChain chain;

    public MailListDelivery() {
        log.debug((Object)"mail list delivery listener started");
    }

    public Message send(Message msg) throws MailException {
        MailAddress[] listAddresses;
        Mail mail = (Mail)msg;
        MailAddress[] mailAddressArray = listAddresses = mail != null ? this.getListAddresses(mail) : null;
        if (listAddresses != null) {
            log.debug((Object)"got at least one list address");
            int i = 0;
            while (i < listAddresses.length) {
                Mail xmail = new Mail(mail);
                xmail.removeTo(listAddresses[i]);
                MailAddress[] listmembers = this.getListMembers(listAddresses[i]);
                boolean breakLoop = this.setOptions(listAddresses[i], xmail, listmembers);
                if (breakLoop) break;
                int j = 0;
                while (j < listmembers.length) {
                    xmail.addBCC(listmembers[j]);
                    ++j;
                }
                this.chain.processMail((Message)xmail);
                mail = null;
                ++i;
            }
        }
        return mail;
    }

    private boolean setOptions(MailAddress address, Mail xmail, MailAddress[] listmembers) {
        boolean breakloop = false;
        MailList lst = this.mgr.findList(address);
        MailListProperties props = lst.getProperties();
        Boolean replyto = props.getPropertyBool("replyToList");
        Boolean membersOnly = props.getPropertyBool("membersOnly");
        Boolean subjectPrefix = props.getPropertyBool("subjectPrefix");
        membersOnly = membersOnly != null ? membersOnly : false;
        replyto = replyto != null ? replyto : false;
        subjectPrefix = subjectPrefix != null ? subjectPrefix : false;
        if (membersOnly.booleanValue()) {
            HashSet lms = new HashSet();
            lms.addAll(Arrays.asList(listmembers));
            List froms = xmail.getFrom();
            for (MailAddress from : froms) {
                if (lms.contains(from)) continue;
                breakloop = true;
                return breakloop;
            }
        }
        if (replyto.booleanValue()) {
            xmail.addHeader("Reply-To", address.toSMTPString());
        }
        if (subjectPrefix.booleanValue()) {
            String subj = xmail.getSubject();
            subj = "[" + address.getUser() + "] " + subj;
        }
        return breakloop;
    }

    private MailAddress[] getListAddresses(Mail mail) {
        ArrayList<MailAddress> results = new ArrayList<MailAddress>();
        for (MailAddress address : mail.getTo()) {
            if (this.mgr.findList(address.toString()) == null) continue;
            results.add(address);
        }
        MailAddress[] r = new MailAddress[results.size()];
        return results.toArray(r);
    }

    private MailAddress[] getListMembers(MailAddress addy) {
        return this.mgr.findList(addy).getMembers();
    }

    public void setMailListManager(MailListManager mgr) {
        this.mgr = mgr;
    }

    public MailListManager getMailListManager() {
        return this.mgr;
    }

    public void setDeliveryChain(MailListenerChain chain) {
        this.chain = chain;
    }

    public MailListenerChain getDeliveryChain() {
        return this.chain;
    }
}

