/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.management;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.buni.meldware.mail.management.ChangeElement;
import org.buni.meldware.mail.management.ChangeList;
import org.buni.meldware.mail.management.DumDOM;
import org.buni.meldware.mail.management.WrappingInvocationHander;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumDOMImpl
implements DumDOM {
    private String filename;
    private File file;
    Document doc;
    List<Element> mbeans;
    Element selectedMbean;
    Element selectedAttribute;
    ChangeList changes = new ChangeList();
    private MBeanServerConnection server;
    private ServiceControllerMBean serviceController;
    private String url;

    public void setDeploymentURL(String url) {
        this.url = url;
    }

    public String getDeploymentURL() {
        return this.url;
    }

    public void setConfigFile(String configfile) {
        this.filename = configfile;
    }

    public String getConfigFile() {
        return this.filename;
    }

    public void start() {
        this.jbConnect();
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)((MBeanServer)this.server));
    }

    public void stop() {
    }

    public void read() throws Exception {
        this.file = new File(this.filename);
        this.changes = new ChangeList();
        DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = bld.parse(this.file);
        NodeList lst = this.doc.getElementsByTagName("mbean");
        this.mbeans = new ArrayList<Element>(lst.getLength());
        int i = 0;
        while (i < lst.getLength()) {
            this.mbeans.add((Element)lst.item(i));
            ++i;
        }
        System.out.println("DONE");
    }

    public void write() throws Exception {
        this.suspend(this.url);
        FileOutputStream stream = new FileOutputStream(this.file);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(stream);
        transformer.transform(source, result);
        stream.close();
        this.resume(this.url);
    }

    public List<Element> getMBeanAttributes() {
        Element mbean = this.selectedMbean;
        NodeList list = mbean.getChildNodes();
        ArrayList<Element> retval = new ArrayList<Element>(list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n instanceof Element) {
                String oan;
                Element e = (Element)n;
                if (e.getNodeName().equals("attribute")) {
                    retval.add(e);
                } else if (e.getNodeName().equals("depends") && (oan = e.getAttribute("optional-attribute-name")) != null && !oan.equals("")) {
                    retval.add(e);
                }
            }
            ++i;
        }
        return retval;
    }

    public String getMBeanName(Element mbean) {
        return mbean.getAttribute("name");
    }

    public Element getMBeanAttribute(String name) {
        List<Element> attrs = this.getMBeanAttributes();
        int i = 0;
        while (i < attrs.size()) {
            Element e = attrs.get(i);
            if (e.getNodeName().equals("attribute") ? e.getAttribute("name").equals(name) : e.getNodeName().equals("depends") && e.getAttribute("optional-attribute-name").equals(name)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public Element createMBean(String name, String className, String interfaceName, String xmbeanpath, String[] attributeNames, Object[] attributeVals, String[] proxyNames, boolean[] depends) {
        return this.createMBean(name, className, interfaceName, xmbeanpath, attributeNames, attributeVals, proxyNames, null, null, depends);
    }

    public Element createMBean(String name, String className, String xmbeanpath, String[] attributeNames, Object[] attributeVals, String[] proxyNames, boolean[] depends) {
        return this.createMBean(name, className, xmbeanpath, attributeNames, attributeVals, proxyNames, null, null, depends);
    }

    public Element createMBean(String name, String className, String xmbeanpath, String[] attributeNames, Object[] attributeVals, String[] proxyNames, String[] constructorArgTypes, String[] constructorArgs, boolean[] depends) {
        return this.createMBean(name, className, null, xmbeanpath, attributeNames, attributeVals, proxyNames, constructorArgTypes, constructorArgs, depends);
    }

    public Element createMBean(String name, String className, String interfaceName, String xmbeanpath, String[] attributeNames, Object[] attributeVals, String[] proxyNames, String[] constructorArgTypes, String[] constructorArgs, boolean[] depends) {
        NodeList lst = this.doc.getElementsByTagName("server");
        Element root = (Element)lst.item(0);
        Element mbean = this.doc.createElement("mbean");
        mbean.setAttribute("name", name);
        mbean.setAttribute("code", className);
        if (interfaceName != null) {
            mbean.setAttribute("interface", interfaceName);
        }
        if (xmbeanpath != null) {
            mbean.setAttribute("xmbean-attr", xmbeanpath);
        }
        if (constructorArgs != null) {
            String elementName = "constructor";
            Element cons = this.doc.createElement(elementName);
            int i = 0;
            while (i < constructorArgTypes.length) {
                Element arg = this.doc.createElement("arg");
                arg.setAttribute("type", constructorArgTypes[i]);
                arg.setAttribute("value", constructorArgs[i]);
                cons.appendChild(arg);
                ++i;
            }
            mbean.appendChild(cons);
        }
        int i = 0;
        while (i < attributeNames.length) {
            String elementName = "attribute";
            if (depends[i]) {
                elementName = "depends";
            }
            Element attr = this.doc.createElement(elementName);
            if (depends[i]) {
                if (attributeNames[i] != null) {
                    attr.setAttribute("optional-attribute-name", attributeNames[i]);
                }
                if (proxyNames[i] != null) {
                    attr.setAttribute("proxy-type", proxyNames[i]);
                }
            } else {
                attr.setAttribute("name", attributeNames[i]);
            }
            if (attributeVals[i] instanceof String) {
                attr.setTextContent((String)attributeVals[i]);
            } else if (attributeVals[i] instanceof Element) {
                Element v = (Element)attributeVals[i];
                Node n = this.doc.importNode(v, true);
                attr.appendChild(n);
            } else {
                throw new RuntimeException("Illegal type for attribute value");
            }
            mbean.appendChild(attr);
            ++i;
        }
        root.appendChild(mbean);
        this.mbeans.add(mbean);
        this.changes.addChange(name, "", 4);
        return mbean;
    }

    public Element createAttribute(String name, String value) {
        Element mbean = this.selectedMbean;
        Element attribute = this.doc.createElement("attribute");
        attribute.setAttribute("name", name);
        this.setMBeanAttributeValue(attribute, value);
        mbean.appendChild(attribute);
        this.changes.addChange(this.getMBeanName(mbean), name, 2);
        return attribute;
    }

    public Object getMBeanAttributeValue(Element attribute) {
        NodeList list = attribute.getChildNodes();
        if (list.getLength() > 0) {
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n.getNodeType() == 1) {
                    Element e = (Element)n;
                    return e;
                }
                ++i;
            }
        }
        return attribute.getFirstChild().getTextContent();
    }

    public void setMBeanAttributeValue(Element attribute, Object value) {
        String theName;
        if (value instanceof Element) {
            Node n = this.doc.importNode((Element)value, true);
            Node child = attribute.getFirstChild();
            while (child != null) {
                Node oldChild = child;
                child = oldChild.getNextSibling();
                if (oldChild.getNodeType() != 1) continue;
                attribute.replaceChild(n, oldChild);
                break;
            }
            if (child == null) {
                attribute.appendChild(n);
            }
        } else {
            Node mba = attribute.getFirstChild();
            if (mba == null) {
                mba = this.doc.createTextNode(value.toString());
                attribute.appendChild(mba);
                return;
            }
            mba.setTextContent(value.toString());
        }
        theName = (theName = attribute.getAttribute("name")) == null || theName.equals("") ? attribute.getAttribute("optional-attribute-name") : theName;
        this.changes.addChange(this.getMBeanName(this.selectedMbean), theName, 0);
    }

    public void deleteAttribute(Element attribute) {
        attribute.getParentNode().removeChild(attribute);
        this.changes.addChange(this.getMBeanName(this.selectedMbean), attribute.getAttribute("name"), 1);
    }

    public void deleteMBean() {
        Element mbean = this.selectedMbean;
        mbean.getParentNode().removeChild(mbean);
        this.mbeans.remove(mbean);
        this.changes.addChange(this.getMBeanName(this.selectedMbean), "", 3);
    }

    public Element findMBeanByName(String name) {
        int i = 0;
        while (i < this.mbeans.size()) {
            Element e = this.mbeans.get(i);
            if (this.getMBeanName(e).equals(name)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public void selectMBean(Element mbean) {
        this.selectedMbean = mbean;
    }

    public void selectMBeanAttribute(Element attr) {
        this.selectedAttribute = attr;
    }

    public Element getSelectedMBean() {
        return this.selectedMbean;
    }

    public Element getSelectedMBeanAttribute() {
        return this.selectedAttribute;
    }

    public void sync() throws Exception {
        ChangeList list = this.changes;
        Set<String> set = list.changes.keySet();
        for (String key : set) {
            List<ChangeElement> changeElems = list.changes.get(key);
            for (ChangeElement change : changeElems) {
                if (change.getType() == 0 || change.getType() == 2) {
                    String attr = change.getAttribute();
                    String mbean = change.getMBean();
                    ObjectName on = new ObjectName(mbean);
                    this.selectMBean(this.findMBeanByName(key));
                    Object val = this.getMBeanAttributeValue(this.getMBeanAttribute(attr));
                    if (val instanceof Element) {
                        new Attribute(attr, val);
                        this.setAttributeWithType(on, attr, (Element)val);
                        continue;
                    }
                    new Attribute(attr, val.toString());
                    this.setAttributeWithType(on, attr, val.toString());
                    continue;
                }
                if (change.getType() == 3) {
                    String mbean = change.getMBean();
                    ObjectName on = new ObjectName(mbean);
                    this.selectMBean(this.findMBeanByName(key));
                    try {
                        this.serviceController.stop(on);
                        this.serviceController.destroy(on);
                        this.serviceController.remove(on);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (change.getType() == 4) {
                    RepositoryClassLoader ucl = (RepositoryClassLoader)DumDOMImpl.class.getClassLoader();
                    ObjectName cl = ucl.getObjectName();
                    String mbean = change.getMBean();
                    ObjectName on = new ObjectName(mbean);
                    this.selectMBean(this.findMBeanByName(key));
                    this.serviceController.install(this.getSelectedMBean(), cl);
                    this.serviceController.create(on);
                    this.serviceController.start(on);
                    continue;
                }
                throw new RuntimeException("UNSUPPORTED CHANGE TYPE");
            }
        }
    }

    private void setAttributeWithType(ObjectName on, String attr, Object val) throws Exception {
        short type = this.getAttributeType(on, attr);
        Attribute attribute = null;
        switch (type) {
            case 1: {
                attribute = new Attribute(attr, val.toString());
                this.server.setAttribute(on, attribute);
                break;
            }
            case 2: {
                attribute = new Attribute(attr, Long.parseLong(val.toString()));
                this.server.setAttribute(on, attribute);
                break;
            }
            case 3: {
                attribute = new Attribute(attr, Integer.parseInt(val.toString()));
                this.server.setAttribute(on, attribute);
                break;
            }
            case 4: {
                Element e = null;
                if (val instanceof String) {
                    DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document adoc = bld.parse(new ByteArrayInputStream(val.toString().getBytes()));
                    e = (Element)adoc.getFirstChild();
                } else {
                    e = (Element)val;
                }
                attribute = new Attribute(attr, e);
                this.server.setAttribute(on, attribute);
                break;
            }
            case 5: {
                attribute = new Attribute(attr, Boolean.parseBoolean(val.toString()));
                this.server.setAttribute(on, attribute);
                break;
            }
            case 6: {
                String typename = this.getTypeName(on, attr);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(typename);
                Object o = MMJMXUtil.getMBean(new ObjectName(val.toString()), clazz);
                Object w = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new WrappingInvocationHander(o));
                attribute = new Attribute(attr, w);
                this.server.setAttribute(on, attribute);
                break;
            }
            case 7: {
                ObjectName aon = new ObjectName(val.toString());
                attribute = new Attribute(attr, aon);
                this.server.setAttribute(on, attribute);
                break;
            }
            default: {
                throw new RuntimeException("Unknown attribute type " + type + "," + attr + "," + val);
            }
        }
    }

    private short getAttributeType(ObjectName on, String attr) throws Exception {
        MBeanInfo info = this.server.getMBeanInfo(on);
        MBeanAttributeInfo[] mai = info.getAttributes();
        int i = 0;
        while (i < mai.length) {
            if (mai[i].getName().equals(attr)) {
                if (mai[i].getType().equals(String.class.getName())) {
                    return 1;
                }
                if (mai[i].getType().equals(Long.class.getName()) || mai[i].getType().equals(Long.TYPE.getName())) {
                    return 2;
                }
                if (mai[i].getType().equals(Integer.class.getName()) || mai[i].getType().equals(Integer.TYPE.getName())) {
                    return 3;
                }
                if (mai[i].getType().equals(Element.class.getName())) {
                    return 4;
                }
                if (mai[i].getType().equals(Boolean.class.getName()) || mai[i].getType().equals(Boolean.TYPE.getName())) {
                    return 5;
                }
                if (mai[i].getType().startsWith("org.buni")) {
                    return 6;
                }
                if (mai[i].getType().equals(ObjectName.class.getName())) {
                    return 7;
                }
                System.out.println("******************UNKNOWN TYPE***************" + mai[i].getType());
            }
            ++i;
        }
        return 0;
    }

    private String getTypeName(ObjectName on, String attr) throws Exception {
        MBeanInfo info = this.server.getMBeanInfo(on);
        MBeanAttributeInfo[] mai = info.getAttributes();
        int i = 0;
        while (i < mai.length) {
            if (mai[i].getName().equals(attr)) {
                return mai[i].getType();
            }
            ++i;
        }
        return null;
    }

    private void resume(String string) {
        try {
            ObjectName on = new ObjectName("jboss.deployment:type=DeploymentScanner,flavor=URL");
            this.server.invoke(on, "resumeDeployment", new Object[]{new URL("file:" + string), new Boolean(true)}, new String[]{URL.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void suspend(String string) {
        try {
            ObjectName on = new ObjectName("jboss.deployment:type=DeploymentScanner,flavor=URL");
            this.server.invoke(on, "suspendDeployment", new Object[]{new URL("file:" + string)}, new String[]{URL.class.getName()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void jbConnect() {
        try {
            this.server = MMJMXUtil.locateJBoss();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void lilTestyWesty() {
        try {
            DumDOMImpl dd = this;
            dd.read();
            Element e = dd.findMBeanByName("meldware.mail:type=MailServices,name=SMTPProtocol");
            System.out.println(dd.getMBeanName(e));
            dd.selectMBean(e);
            Element attr = dd.getMBeanAttribute("Servername");
            String val = dd.getMBeanAttributeValue(attr).toString();
            System.out.println("servername was " + val + " changing to localhost.localdomain");
            dd.setMBeanAttributeValue(attr, "localhost.localdomain");
            dd.sync();
            dd.write();
            System.out.println("done");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Element createDependency(String attrName, String value, boolean proxy) {
        Element mbean = this.selectedMbean;
        Element attribute = this.doc.createElement("depends");
        if (attrName != null) {
            attribute.setAttribute("optional-attribute-name", attrName);
        }
        if (proxy) {
            attribute.setAttribute("proxy-type", "attribute");
        }
        attribute.setTextContent(value);
        mbean.appendChild(attribute);
        this.changes.addChange(this.getMBeanName(mbean), attrName, 2);
        return attribute;
    }

    public Element parse(String val) {
        try {
            DocumentBuilder bld = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document adoc = bld.parse(new ByteArrayInputStream(val.getBytes()));
            return (Element)adoc.getFirstChild();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

