/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdUIDL
extends AbstractCommand
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "UIDL";
    private static final Logger log = Logger.getLogger(CmdUIDL.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug((Object)"UIDL command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        if (this.verifyState(protocol, writer, 1)) {
            String[] arguments = request.getArguments();
            if (arguments.length == 0) {
                List<MessageData> messages = protocol.getInboxMailList();
                writer.println("+OK");
                int index = 0;
                while (index < messages.size()) {
                    MessageData data = messages.get(index);
                    if (!data.isDeleted()) {
                        writer.println(String.valueOf(index + 1) + " " + messages.get(index).getId());
                    }
                    ++index;
                }
                writer.println(".");
            } else if (arguments.length == 1) {
                MessageData message = protocol.getMessageAt(new Integer(arguments[0]));
                if (message == null || message.isDeleted()) {
                    writer.println("-ERR Unknown message.");
                } else {
                    writer.println("+OK " + arguments[0] + " " + message.getId());
                }
            } else {
                writer.println("-ERR Too many parameters specified.");
            }
        }
        writer.flush();
        return response;
    }
}

