/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.logging.Logger;

class LoggingInputStream
extends InputStream {
    private InputStream stream;
    boolean enabled;
    StringBuffer buffer;
    Logger log = Logger.getLogger(LoggingInputStream.class);

    public LoggingInputStream(InputStream stream) {
        this.stream = stream;
        boolean bl = this.enabled = this.log != null;
        if (this.enabled) {
            this.buffer = new StringBuffer();
        }
    }

    public void close() throws IOException {
        this.stream.close();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(String.valueOf(this.escape(this.buffer.toString())) + "\r\nDONE\r\n"));
            this.buffer = null;
        }
    }

    public synchronized void mark(int arg0) {
        super.mark(arg0);
        if (this.log.isTraceEnabled() && this.buffer.length() > 0) {
            this.log.trace((Object)this.escape(this.buffer.toString()));
            this.buffer = new StringBuffer();
        }
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int result = this.stream.read(arg0, arg1, arg2);
        if (this.enabled) {
            this.buffer.append(new String(arg0, arg1, arg2, "US-ASCII"));
        }
        return result;
    }

    public int read(byte[] arg0) throws IOException {
        int retval = this.stream.read(arg0);
        if (this.enabled) {
            this.buffer.append(new String(arg0, 0, retval, "US-ASCII"));
        }
        return retval;
    }

    public int read() throws IOException {
        int retval = this.stream.read();
        if (this.enabled) {
            this.buffer.append((char)retval);
            if ((char)retval == '\n') {
                this.log.info((Object)this.escape(this.buffer.toString()));
                this.buffer = new StringBuffer();
            }
        }
        return retval;
    }

    private String escape(Object o) {
        return o.toString().replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");
    }
}

