/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.ObjectName;
import org.buni.meldware.mail.AbstractProtocol;
import org.buni.meldware.mail.AbstractResponse;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.Request;
import org.buni.meldware.mail.Response;
import org.buni.meldware.mail.domaingroup.DomainGroupMBean;
import org.buni.meldware.mail.message.LoopDetectedException;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.message.MailBodyManager;
import org.buni.meldware.mail.message.MailCreateAdapter;
import org.buni.meldware.mail.message.MailCreateListener;
import org.buni.meldware.mail.message.MailHeaders;
import org.buni.meldware.mail.smtp.MutableSMTPRequest;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolMBean;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.buni.meldware.mail.util.DateUtil;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.DotUnstuffingCopier;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPProtocolInstance
extends AbstractProtocol
implements Protocol,
SMTPConstants {
    private static final long serialVersionUID = 3258689927104705587L;
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>(0);
    private static final Logger log = Logger.getLogger(SMTPProtocolInstance.class);
    private Map handlers;
    private MailBodyManager manager = null;
    private SMTPProtocolMBean parent;
    private static final String UNKNOWN = "unknown";

    public MailBodyManager getManager() {
        return this.manager;
    }

    public void setManager(MailBodyManager manager) {
        this.manager = manager;
    }

    public SMTPProtocolInstance(Map handlers, ObjectName parent, MailBodyManager mailBodyManager) {
        super(parent);
        this.handlers = handlers;
        this.parent = MMJMXUtil.getMBean(parent, SMTPProtocolMBean.class);
        this.setManager(mailBodyManager);
    }

    public void greet(OutputStream stream) throws IOException {
        PrintWriter writer = AbstractResponse.getWrappedWriter(new PrintWriter(stream));
        writer.println("220 " + this.getProperty("Servername") + " SMTP Server (Meldware Mail SMTP Server version 0.7) " + "ready" + " " + DateUtil.longInternetDate());
        writer.flush();
    }

    public SMTPProtocolMBean getSMTPMBean() {
        return this.parent;
    }

    public Request parseRequest(InputStream stream, Socket socket) throws IOException {
        MutableSMTPRequest request = new MutableSMTPRequest(this, stream);
        String commstring = this.readCommand(stream);
        String[] command = this.parseCommand(commstring);
        request.setCommand(command[0].trim());
        request.addArgument(command[1]);
        request.setSocket(socket);
        if (log.isTraceEnabled()) {
            log.trace((Object)commstring);
        }
        return request;
    }

    public String readResponse(SMTPRequest request) throws IOException {
        return this.readCommand(request.getInputStream());
    }

    public Response handleRequest(OutputStream stream, Request request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HandleRequest called with request = " + (request == null ? "true" : "false")));
            log.debug((Object)("HandleRequest called with command = " + (request == null ? "null" : ((SMTPRequest)request).getCommand())));
        }
        SMTPHandler handler = (SMTPHandler)this.handlers.get(((SMTPRequest)request).getCommand());
        SMTPResponse response = null;
        if (handler != null) {
            try {
                response = handler.handleRequest(stream, (SMTPRequest)request, this);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.handleIOError(stream);
            }
        } else {
            try {
                response = new SMTPResponse((SMTPRequest)request, stream, this, this.secure);
                PrintWriter writer = response.getWriter();
                writer.println("500 " + this.getProperty("Servername") + " Syntax error, command unrecognized: " + ((SMTPRequest)request).getCommand());
                writer.flush();
            }
            catch (IOException iOException) {
                response = (SMTPResponse)this.handleIOError(stream);
            }
        }
        return response;
    }

    public boolean handleAuth(MailAddress rcptAddr, OutputStream out, SMTPRequest request, SMTPProtocolInstance protocol, PrintWriter writer) {
        DomainGroupMBean dg = (DomainGroupMBean)protocol.getProperty("DomainGroup");
        log.debug((Object)"HANDLE AUTH");
        if (protocol != this) {
            throw new RuntimeException("THIS SHOULD NOT HAPPEN:::WRONG PROTOCOL INSTANCE TO HANDLE AUTH...I THINK I'LL CHOKE NOW...BYE");
        }
        if (!this.getPropertyBool("AuthRequired") && this.getPropertyBool("AuthAllowed")) {
            log.debug((Object)"AUTH NOT REQUIRED");
            return true;
        }
        if (!this.getPropertyBool("AuthAllowed")) {
            writer.println("503 This server does not allow authentication");
            writer.flush();
            return false;
        }
        if (this.authShouldBeRequired((String)this.getState("USER"), rcptAddr.getDomain()) && this.getProperty("VerifyIdentity") != null && this.getProperty("VerifyIdentity").equals("true")) {
            String authUser = (String)this.getState("USER");
            authUser = authUser != null ? authUser.toLowerCase(Locale.US) : null;
            MailAddress senderAddress = (MailAddress)this.getState("SENDER");
            if (authUser != null && !authUser.equals(senderAddress.getUser()) || !dg.isInGroup(senderAddress.getDomain())) {
                writer.println("503 Incorrect Authentication for Specified Email Address");
                writer.flush();
                return false;
            }
        }
        String toDomain = rcptAddr.getDomain();
        if (this.isMailAddressLocal(rcptAddr)) {
            return true;
        }
        if (this.getState("USER") == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("USER ==" + this.getState("USER")));
        }
        if (this.getState("USER") == null && dg.isInGroup(toDomain)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SERVERNAME != domain");
                log.debug((Object)("SERVERNAME = " + this.getProperty("Servername") + " domain = " + rcptAddr.getDomain()));
            }
            writer.println("530 Authentication Required");
            writer.flush();
            return false;
        }
        return true;
    }

    public boolean isMailAddressLocal(MailAddress address) {
        DomainGroupMBean dg = this.parent.getDomainGroup();
        String toDomain = address.getDomain();
        return dg.isInGroup(toDomain);
    }

    public boolean isRelayByDomainAllowed(InetAddress address) {
        if (this.parent.isRelayByDomain()) {
            String hostname = address.getCanonicalHostName();
            log.debug((Object)("Checking if domain relaying is allowed from: " + hostname));
            DomainGroupMBean relayGroup = this.parent.getRelayDomainGroup();
            if (relayGroup != null) {
                return relayGroup.isHostInGroup(hostname);
            }
        }
        return false;
    }

    public boolean isRelayByDomainAllowed(MailAddress address) {
        if (this.parent.isRelayByDomain()) {
            log.debug((Object)("Checking if domain relaying is allowed to: " + address));
            DomainGroupMBean relayGroup = this.parent.getRelayDomainGroup();
            if (relayGroup != null) {
                return relayGroup.isInGroup(address.getDomain());
            }
        }
        return false;
    }

    public boolean isRelayByAddrAllowed(InetAddress address) {
        if (this.parent.isRelayByAddr()) {
            log.debug((Object)"Relaying by IP Address is not supported");
        }
        return false;
    }

    private boolean authShouldBeRequired(String user, String domain) {
        DomainGroupMBean dg = (DomainGroupMBean)this.getProperty("DomainGroup");
        if (dg.isInGroup(domain)) {
            return false;
        }
        return user != null;
    }

    public Response handleIOError(OutputStream stream) {
        log.error((Object)"Handle IO Error");
        return null;
    }

    public String getName() {
        return "SMTP";
    }

    public boolean isAuthenticated() {
        return this.getState("USER") != null;
    }

    public void greet(SocketChannel ioChannel) throws IOException {
        char[] chr = new String("220 " + this.getProperty("Servername") + " SMTP Server (JBMAIL SMTP Server version 0.1) " + "ready" + " " + DateUtil.longInternetDate()).toCharArray();
        ByteBuffer buffer = ByteBuffer.allocate(chr.length * 2);
        buffer.asCharBuffer().put(chr);
        ioChannel.write(buffer);
    }

    public void handleCleanup(OutputStream out) {
    }

    public String getIP(String key) {
        InetAddress addr = (InetAddress)this.getState(key);
        String ip = addr != null ? addr.getHostAddress() : UNKNOWN;
        return ip;
    }

    public String getHost(String key) {
        InetAddress addr = (InetAddress)this.getState(key);
        String host = addr != null ? addr.getHostName() : UNKNOWN;
        return host;
    }

    public String getServername() {
        return this.parent.getServername();
    }

    public void checkForLoops(MailHeaders headers) throws LoopDetectedException {
        SMTPProtocolMBean p = this.getSMTPMBean();
        String serverName = this.getServername();
        String localIP = this.getIP("local address");
        long maxReceived = p.getMaxReceivedHdrs();
        long receivedThreshold = p.getReceivedHdrsThreshold();
        long maxOwnReceived = p.getMaxOwnReceivedHdrs();
        String[] receivedHeaders = headers.getHeader("Received");
        if (receivedHeaders != null) {
            if ((long)receivedHeaders.length > maxReceived) {
                String pattern = "SMTP loop? Too many Received headers. Max allowed is %d";
                String msg = String.format(pattern, maxReceived);
                throw new LoopDetectedException(msg);
            }
            if ((long)receivedHeaders.length > receivedThreshold) {
                int count = 0;
                String[] stringArray = receivedHeaders;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String hdr = stringArray[n];
                    if (hdr.indexOf(serverName) > -1 && hdr.indexOf(localIP) > -1 && (long)(++count) > maxOwnReceived) {
                        String pattern = "SMTP loop? More than %d Received headers contain the name of our server: %s";
                        String msg = String.format(pattern, maxOwnReceived, serverName);
                        throw new LoopDetectedException(msg);
                    }
                    ++n;
                }
            }
        }
    }

    public String getTraceInfo() {
        String serverName = this.getServername();
        String localIP = this.getIP("local address");
        String remoteIP = this.getIP("client address");
        String remoteHost = this.getHost("client address");
        String heloDomain = (String)this.getState("h");
        String pattern = "from %s (%s %s) by %s/%s (%s)\r\n\twith SMTP id %s; %s";
        String version = "Meldware Mail 1.0M7-pre";
        StringBuffer id = new StringBuffer();
        id.append(System.currentTimeMillis());
        id.append(Math.random() * 1024.0);
        String date = DateUtil.mailHeaderDate();
        return String.format(pattern, heloDomain, remoteHost, remoteIP, serverName, version, localIP, id, date);
    }

    public MailCreateListener getMailCreateListener(MailAddress from, MailAddress[] to, Map<String, String> hdrs) {
        SMTPProtocolMBean p = this.getSMTPMBean();
        String serverName = this.getServername();
        String localIP = this.getIP("local address");
        long maxReceived = p.getMaxReceivedHdrs();
        long receivedThreshold = p.getReceivedHdrsThreshold();
        long maxOwnReceived = p.getMaxOwnReceivedHdrs();
        String trace = this.getTraceInfo();
        boolean isAuth = this.getState("USER") != null;
        SMTPMailCreateAdapter mcl = new SMTPMailCreateAdapter(from, to, hdrs, isAuth, serverName, localIP, trace, maxReceived, receivedThreshold, maxOwnReceived);
        return mcl;
    }

    public MailCreateListener getMailCreateListener(MailAddress from, MailAddress[] to) {
        return this.getMailCreateListener(from, to, EMPTY_MAP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SMTPMailCreateAdapter
    extends MailCreateAdapter {
        private final MailAddress from;
        private final MailAddress[] to;
        private final Map<String, String> hdrs;
        private final String hostname;
        private final String ip;
        private final long maxReceived;
        private final long receivedThreshold;
        private final long maxOwnReceived;
        private boolean isAuth;
        private String trace;

        public SMTPMailCreateAdapter(MailAddress from, MailAddress[] to, Map<String, String> hdrs, boolean isAuth, String hostname, String ip, String trace, long maxReceived, long receivedThreshold, long maxOwnReceived) {
            this.from = from;
            this.to = to;
            this.hostname = hostname;
            this.ip = ip;
            this.hdrs = hdrs;
            this.isAuth = isAuth;
            this.maxReceived = maxReceived;
            this.receivedThreshold = receivedThreshold;
            this.maxOwnReceived = maxOwnReceived;
            this.trace = trace;
        }

        protected void postHeadersParsed() {
            if (this.isAuth) {
                String fromStr = this.from.toString();
                this.getMailHeaders().addIfAbsent("From", fromStr);
                this.getMailHeaders().addIfAbsent("Return-Path", fromStr);
                this.getMailHeaders().addIfAbsent("Date", DateUtil.mailHeaderDate());
            }
            this.getMailHeaders().addHeader("Received", this.trace);
        }

        public Copier getCopier() {
            return new DotUnstuffingCopier();
        }

        public MailAddress getFrom() {
            return this.from;
        }

        public MailAddress[] getTo() {
            return this.to;
        }

        public void verifyHeaders() throws MailException {
            this.checkForLoops(this.getMailHeaders());
        }

        public void checkForLoops(MailHeaders headers) throws LoopDetectedException {
            String[] receivedHeaders = headers.getHeader("Received");
            if (receivedHeaders != null) {
                if ((long)receivedHeaders.length > this.maxReceived) {
                    String pattern = "SMTP loop? Too many Received headers. Max allowed is %d";
                    String msg = String.format(pattern, this.maxReceived);
                    throw new LoopDetectedException(msg);
                }
                if ((long)receivedHeaders.length > this.receivedThreshold) {
                    int count = 0;
                    String[] stringArray = receivedHeaders;
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String hdr = stringArray[n];
                        if ((hdr.indexOf(this.hostname) > -1 || hdr.indexOf(this.ip) > -1) && (long)(++count) > this.maxOwnReceived) {
                            String pattern = "SMTP loop? More than %d Received headers contain the name of our server: %s";
                            String msg = String.format(pattern, this.maxOwnReceived, this.hostname);
                            throw new LoopDetectedException(msg);
                        }
                        ++n;
                    }
                }
            }
        }
    }
}

