/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.handlers;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.Security;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.buni.meldware.mail.Protocol;
import org.buni.meldware.mail.smtp.MutableSMTPRequest;
import org.buni.meldware.mail.smtp.SMTPConstants;
import org.buni.meldware.mail.smtp.SMTPProtocolInstance;
import org.buni.meldware.mail.smtp.SMTPRequest;
import org.buni.meldware.mail.smtp.SMTPResponse;
import org.buni.meldware.mail.smtp.handlers.SMTPHandler;
import org.jboss.logging.Logger;

public class CmdSTARTTLS
implements SMTPHandler,
SMTPConstants {
    public static final String COMMAND = "STARTTLS";
    private static final Logger jblog = Logger.getLogger(CmdSTARTTLS.class);

    public SMTPResponse handleRequest(OutputStream out, SMTPRequest request, Protocol protocol) throws IOException {
        jblog.debug((Object)"STARTTLS command handler called");
        SMTPResponse response = new SMTPResponse(request, out, protocol);
        PrintWriter writer = response.getWriter();
        if (request.arguments().hasNext()) {
            writer.println("501 Syntax error (no parameters allowed)");
        } else {
            writer.println("220 Ready to start TLS");
            Security.addProvider((java.security.Provider)new Provider());
            SMTPProtocolInstance smtpProtocol = (SMTPProtocolInstance)protocol;
            SSLSocketFactory factory = (SSLSocketFactory)smtpProtocol.getProperty("SslSocketFactory");
            Socket oldSocket = ((MutableSMTPRequest)request).getSocket();
            final SSLSocket newSocket = (SSLSocket)factory.createSocket(oldSocket, oldSocket.getLocalAddress().getHostName(), oldSocket.getLocalPort(), true);
            newSocket.setNeedClientAuth(protocol.getPropertyBool("RequireClientCert"));
            newSocket.setUseClientMode(false);
            final SMTPProtocolInstance tempProtocol = (SMTPProtocolInstance)protocol;
            newSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    jblog.debug((Object)"HS completed");
                    tempProtocol.setSecure(true);
                    Object localAddr = tempProtocol.getState("local address");
                    Object remoteAddr = tempProtocol.getState("client address");
                    tempProtocol.resetState();
                    tempProtocol.setState("local address", localAddr);
                    tempProtocol.setState("client address", remoteAddr);
                    jblog.debug((Object)"State reset");
                    Certificate[] certs = null;
                    try {
                        certs = newSocket.getSession().getPeerCertificates();
                        int j = certs.length - 1;
                        while (j >= 0) {
                            jblog.debug((Object)certs[j]);
                            --j;
                        }
                    }
                    catch (SSLPeerUnverifiedException e) {
                        e.printStackTrace();
                    }
                }
            });
            ((SMTPProtocolInstance)protocol).getServerThread();
            response.setSocketOverride(newSocket);
        }
        writer.flush();
        return response;
    }
}

