/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.sender;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.buni.meldware.mail.message.EnvelopedAddress;
import org.buni.meldware.mail.message.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MailAddressesByDomain {
    HashMap addressesByDomain = new HashMap();

    public MailAddressesByDomain(List<MailAddress> addresses, MailAddress[] exclude) {
        for (MailAddress address : addresses) {
            EnvelopedAddress ea = new EnvelopedAddress(address);
            if (this.included((MailAddress)ea, exclude) || ea.getLocal()) continue;
            String domain = ea.getDomain();
            HashSet<EnvelopedAddress> addrs = (HashSet<EnvelopedAddress>)this.addressesByDomain.get(domain);
            if (addrs == null) {
                addrs = new HashSet<EnvelopedAddress>();
                this.addressesByDomain.put(domain, addrs);
            }
            addrs.add(ea);
        }
    }

    private boolean included(MailAddress address, MailAddress[] list) {
        boolean retval = false;
        int k = 0;
        while (k < list.length) {
            if (address.equals(list[k])) {
                retval = true;
                break;
            }
            ++k;
        }
        return retval;
    }

    public Iterator getDomains() {
        return this.addressesByDomain.keySet().iterator();
    }

    public MailAddress[] getAddresses(String domain) {
        Set addrs = (Set)this.addressesByDomain.get(domain);
        if (addrs != null) {
            return addrs.toArray(new MailAddress[addrs.size()]);
        }
        return new MailAddress[0];
    }
}

