/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.file;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import org.buni.filestore.FileStore;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.store.file.FileStoreService;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStoreImpl
extends AbstractStore
implements FileStoreService,
Advised {
    FileStore fileStore;
    private String path;
    private int tries;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.file.FileStoreImpl"));
    private static WeakReference aop$MethodInfo_getBuffer_N_8328802641894955898;

    @Override
    public void init() {
        Properties props = new Properties();
        props.put("base.dir", this.path);
        props.put("tries", (Object)this.tries);
        this.fileStore = new FileStore(props);
    }

    @Override
    protected Long doCreate() throws StoreException {
        return this.fileStore.allocate();
    }

    public void cleanUp(List<Long> bods) {
        int i = 0;
        while (i < bods.size()) {
            this.delete(bods.get(i));
            ++i;
        }
    }

    public void delete(Long id) throws StoreException {
        this.fileStore.setToZeroLength(id.longValue());
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer org$buni$meldware$mail$store$file$FileStoreImpl$getBuffer$aop(Long id, long position, int len) throws StoreException {
        ByteBuffer buffer;
        try {
            FileInputStream stream = (FileInputStream)this.fileStore.getInputStream(id.longValue(), false);
            stream.getChannel().position(position);
            byte[] b = new byte[len];
            int numRead = stream.read(b, 0, len);
            buffer = ByteBuffer.wrap(b, 0, numRead);
            stream.close();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
        return buffer;
    }

    @Override
    public InputStream getInputStream(Long id, StoreItemMetaData meta) throws StoreException {
        return this.fileStore.getInputStream(id.longValue(), true);
    }

    @Override
    public OutputStream getOutputStream(Long id, StoreItemMetaData meta) throws StoreException {
        return this.fileStore.getOutputStream(id.longValue(), true);
    }

    public String idToString(Object id) {
        return id.toString();
    }

    @Override
    public int read(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int read = 0;
        try {
            InputStream stream = this.fileStore.getInputStream(id.longValue(), true);
            stream.skip(position);
            read = stream.read(b, off, len);
            stream.close();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
        return read;
    }

    public Object stringToId(String s) {
        return Long.parseLong(s);
    }

    @Override
    public int write(Long id, long position, byte[] b, int off, int len) throws StoreException {
        int written = 0;
        try {
            FileOutputStream stream = (FileOutputStream)this.fileStore.getOutputStream(id.longValue(), true);
            stream.getChannel().position(position);
            stream.write(b, off, len);
            written = len;
            stream.close();
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
        return written;
    }

    @Override
    public int getAttemptsPerAllocate() {
        return this.tries;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setAttemptsPerAllocate(int tries) {
        this.tries = tries;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public ByteBuffer getBuffer(Long l, long l2, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_8328802641894955898.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(methodInfo, interceptorArray);
            getBuffer_N83288026418949558982.arg0 = l;
            getBuffer_N83288026418949558982.arg1 = l2;
            getBuffer_N83288026418949558982.arg2 = n;
            getBuffer_N83288026418949558982.setTargetObject(this);
            getBuffer_N83288026418949558982.typedTargetObject = this;
            getBuffer_N83288026418949558982.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N83288026418949558982.invokeNext();
        }
        return this.org$buni$meldware$mail$store$file$FileStoreImpl$getBuffer$aop(l, l2, n);
    }

    public static class getBuffer_N8328802641894955898
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public int arg2;
        public FileStoreImpl typedTargetObject;

        public getBuffer_N8328802641894955898(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N8328802641894955898() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$file$FileStoreImpl$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N83288026418949558982.arguments = this.arguments;
            ((InvocationBase)getBuffer_N83288026418949558982).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N83288026418949558982).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N83288026418949558982).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N83288026418949558982.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N83288026418949558982).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N83288026418949558982.arg0 = this.arg0;
            getBuffer_N83288026418949558982.arg1 = this.arg1;
            getBuffer_N83288026418949558982.arg2 = this.arg2;
            return getBuffer_N83288026418949558982;
        }
    }
}

