/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.jvm;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.ByteBufferOutputStream;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;

public class BufferHandler
implements Component {
    Field directAllocatedByteBufferAddressField;
    int defaultBufferSize;
    Function<Integer, ByteBuffer> defaultByteBufferAllocator;
    static final float reallocationFactor = 1.1f;

    public BufferHandler(Map<?, ?> config) {
        this.init(config);
    }

    void init(Map<?, ?> config) {
        this.setDefaultByteBufferSize(config);
        this.setDefaultByteBufferAllocationMode(config);
        this.checkAndListenTo(config);
        block0: for (Class<?> directByteBufferClass = ByteBuffer.allocateDirect(0).getClass(); directByteBufferClass != null && this.directAllocatedByteBufferAddressField == null; directByteBufferClass = directByteBufferClass.getSuperclass()) {
            for (Field field : StaticComponentContainer.Driver.getDeclaredFields(directByteBufferClass)) {
                if (!field.getName().equals("address")) continue;
                this.directAllocatedByteBufferAddressField = field;
                break block0;
            }
        }
    }

    private void setDefaultByteBufferSize(Map<?, ?> config) {
        String defaultBufferSize = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("buffer-handler.default-buffer-size").on(config)).withDefaultValues(Configuration.DEFAULT_VALUES));
        try {
            this.defaultBufferSize = Integer.valueOf(defaultBufferSize);
        }
        catch (Throwable exc) {
            String unit = defaultBufferSize.substring(defaultBufferSize.length() - 2);
            String value = defaultBufferSize.substring(0, defaultBufferSize.length() - 2);
            if (unit.equalsIgnoreCase("KB")) {
                this.defaultBufferSize = new BigDecimal(value).multiply(new BigDecimal(1024)).intValue();
            }
            if (unit.equalsIgnoreCase("MB")) {
                this.defaultBufferSize = new BigDecimal(value).multiply(new BigDecimal(0x100000)).intValue();
            }
            this.defaultBufferSize = Integer.valueOf(value);
        }
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "default buffer size: {} bytes", this.defaultBufferSize);
    }

    private void setDefaultByteBufferAllocationMode(Map<?, ?> config) {
        String defaultByteBufferAllocationMode = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("buffer-handler.default-allocation-mode").on(config)).withDefaultValues(Configuration.DEFAULT_VALUES));
        if (defaultByteBufferAllocationMode.equalsIgnoreCase("ByteBuffer::allocate")) {
            this.defaultByteBufferAllocator = this::allocateInHeap;
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "default allocation mode: ByteBuffer::allocate");
        } else {
            this.defaultByteBufferAllocator = this::allocateDirect;
            StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "default allocation mode: ByteBuffer::allocateDirect");
        }
    }

    @Override
    public <K, V> void processChangeNotification(Properties config, Properties.Event event, K key, V newValue, V previousValue) {
        if (event.name().equals(Properties.Event.PUT.name()) && key instanceof String) {
            String keyAsString = (String)key;
            if (keyAsString.equals("buffer-handler.default-buffer-size")) {
                this.setDefaultByteBufferSize(config);
            } else if (keyAsString.equals("buffer-handler.default-allocation-mode")) {
                this.setDefaultByteBufferAllocationMode(config);
            }
        }
    }

    public int getDefaultBufferSize() {
        return this.defaultBufferSize;
    }

    public static BufferHandler create(Map<?, ?> config) {
        return new BufferHandler(config);
    }

    public ByteBuffer allocate(int capacity) {
        return this.defaultByteBufferAllocator.apply(capacity);
    }

    public ByteBuffer allocateInHeap(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    public ByteBuffer duplicate(ByteBuffer buffer) {
        return buffer.duplicate();
    }

    public <T extends Buffer> int limit(T buffer) {
        return buffer.limit();
    }

    public <T extends Buffer> int position(T buffer) {
        return buffer.position();
    }

    public <T extends Buffer> T limit(T buffer, int newLimit) {
        return (T)buffer.limit(newLimit);
    }

    public <T extends Buffer> T position(T buffer, int newPosition) {
        return (T)buffer.position(newPosition);
    }

    public <T extends Buffer> T flip(T buffer) {
        return (T)buffer.flip();
    }

    public <T extends Buffer> int capacity(T buffer) {
        return buffer.capacity();
    }

    public <T extends Buffer> int remaining(T buffer) {
        return buffer.remaining();
    }

    public ByteBuffer put(ByteBuffer byteBuffer, byte[] heapBuffer) {
        return this.put(byteBuffer, heapBuffer, heapBuffer.length);
    }

    public ByteBuffer put(ByteBuffer byteBuffer, byte[] heapBuffer, int bytesToWrite) {
        return this.put(byteBuffer, heapBuffer, bytesToWrite, 0);
    }

    public ByteBuffer shareContent(ByteBuffer byteBuffer) {
        ByteBuffer duplicated = this.duplicate(byteBuffer);
        if (this.position(byteBuffer) > 0) {
            this.flip(duplicated);
        }
        return duplicated;
    }

    public ByteBuffer put(ByteBuffer byteBuffer, byte[] heapBuffer, int bytesToWrite, int initialPosition) {
        byteBuffer = this.ensureRemaining(byteBuffer, bytesToWrite, initialPosition);
        byteBuffer.put(heapBuffer, 0, bytesToWrite);
        return byteBuffer;
    }

    public byte[] toByteArray(ByteBuffer byteBuffer) {
        byteBuffer = this.shareContent(byteBuffer);
        byte[] result = new byte[this.limit(byteBuffer)];
        byteBuffer.get(result, 0, result.length);
        return result;
    }

    public ByteBuffer ensureRemaining(ByteBuffer byteBuffer, int requiredBytes) {
        return this.ensureRemaining(byteBuffer, requiredBytes, 0);
    }

    public ByteBuffer ensureRemaining(ByteBuffer byteBuffer, int requiredBytes, int initialPosition) {
        if (requiredBytes > this.remaining(byteBuffer)) {
            return this.expandBuffer(byteBuffer, requiredBytes, initialPosition);
        }
        return byteBuffer;
    }

    public ByteBuffer expandBuffer(ByteBuffer byteBuffer, int requiredBytes) {
        return this.expandBuffer(byteBuffer, requiredBytes, 0);
    }

    public ByteBuffer expandBuffer(ByteBuffer byteBuffer, int requiredBytes, int initialPosition) {
        int limit = this.limit(byteBuffer);
        ByteBuffer newBuffer = this.allocate(Math.max((int)((float)limit * 1.1f), this.position(byteBuffer) + requiredBytes));
        this.flip(byteBuffer);
        newBuffer.put(byteBuffer);
        this.limit(byteBuffer, limit);
        this.position(byteBuffer, initialPosition);
        return newBuffer;
    }

    public <T extends Buffer> long getAddress(T buffer) {
        try {
            return (Long)StaticComponentContainer.Driver.getFieldValue(buffer, this.directAllocatedByteBufferAddressField);
        }
        catch (NullPointerException exc) {
            return (Long)StaticComponentContainer.Driver.getFieldValue(buffer, this.getDirectAllocatedByteBufferAddressField());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Field getDirectAllocatedByteBufferAddressField() {
        if (this.directAllocatedByteBufferAddressField == null) {
            BufferHandler bufferHandler = this;
            synchronized (bufferHandler) {
                if (this.directAllocatedByteBufferAddressField == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.Driver.throwException((Throwable)exc);
                    }
                }
            }
        }
        return this.directAllocatedByteBufferAddressField;
    }

    public <T extends Buffer> boolean destroy(T buffer, boolean force) {
        if (buffer.isDirect()) {
            Cleaner cleaner = this.getCleaner(buffer, force);
            if (cleaner != null) {
                return cleaner.clean();
            }
            return false;
        }
        return true;
    }

    private <T extends Buffer> Object getInternalCleaner(T buffer, boolean findInAttachments) {
        if (buffer.isDirect() && buffer != null) {
            Object cleaner = StaticComponentContainer.Fields.get(buffer, "cleaner");
            if (cleaner != null) {
                return cleaner;
            }
            if (findInAttachments) {
                return this.getInternalCleaner((Buffer)StaticComponentContainer.Fields.getDirect(buffer, "att"), findInAttachments);
            }
        }
        return null;
    }

    private <T extends Buffer> Object getInternalDeallocator(T buffer, boolean findInAttachments) {
        Object cleaner;
        if (buffer.isDirect() && (cleaner = this.getInternalCleaner(buffer, findInAttachments)) != null) {
            return StaticComponentContainer.Fields.getDirect(cleaner, "thunk");
        }
        return null;
    }

    private <T extends Buffer> Collection<T> getAllLinkedBuffers(T buffer) {
        ArrayList<T> allLinkedBuffers = new ArrayList<T>();
        allLinkedBuffers.add((T)buffer);
        while ((buffer = (Buffer)StaticComponentContainer.Fields.getDirect(buffer, "att")) != null) {
            allLinkedBuffers.add((T)buffer);
        }
        return allLinkedBuffers;
    }

    public ByteBuffer newByteBufferWithDefaultSize() {
        return this.allocate(this.defaultBufferSize);
    }

    public ByteBuffer newByteBuffer(int size) {
        return this.allocate(size > -1 ? size : this.defaultBufferSize);
    }

    public ByteBufferOutputStream newByteBufferOutputStreamWithDefaultSize() {
        return new ByteBufferOutputStream(this.defaultBufferSize);
    }

    public ByteBufferOutputStream newByteBufferOutputStream(int size) {
        return new ByteBufferOutputStream(size > -1 ? size : this.defaultBufferSize);
    }

    public byte[] newByteArrayWithDefaultSize() {
        return new byte[this.defaultBufferSize];
    }

    public byte[] newByteArray(int size) {
        return new byte[size > -1 ? size : this.defaultBufferSize];
    }

    public <T extends Buffer> Cleaner getCleaner(final T buffer, boolean findInAttachments) {
        final Object cleaner = this.getInternalCleaner(buffer, findInAttachments);
        if (cleaner != null) {
            return new Cleaner(){

                @Override
                public boolean clean() {
                    if (this.getAddress() != 0L) {
                        StaticComponentContainer.Methods.invokeDirect(cleaner, "clean", new Object[0]);
                        BufferHandler.this.getAllLinkedBuffers(buffer).stream().forEach(linkedBuffer -> StaticComponentContainer.Fields.setDirect(linkedBuffer, "address", (Object)0L));
                        return true;
                    }
                    return false;
                }

                long getAddress() {
                    return (Long)StaticComponentContainer.Fields.getDirect(StaticComponentContainer.Fields.getDirect(cleaner, "thunk"), "address");
                }

                @Override
                public boolean cleaningHasBeenPerformed() {
                    return this.getAddress() == 0L;
                }
            };
        }
        return null;
    }

    public <T extends Buffer> Deallocator getDeallocator(final T buffer, boolean findInAttachments) {
        Object deallocator;
        if (buffer.isDirect() && (deallocator = this.getInternalDeallocator(buffer, findInAttachments)) != null) {
            return new Deallocator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean freeMemory() {
                    if (this.getAddress() != 0L) {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.getAddress() != 0L) {
                                StaticComponentContainer.Methods.invokeDirect(deallocator, "run", new Object[0]);
                                BufferHandler.this.getAllLinkedBuffers(buffer).stream().forEach(linkedBuffer -> StaticComponentContainer.Fields.setDirect(linkedBuffer, "address", (Object)0L));
                                if (this.getAddress() != 0L) {
                                    StaticComponentContainer.Fields.setDirect(deallocator, "address", (Object)0L);
                                }
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public long getAddress() {
                    return (Long)StaticComponentContainer.Fields.getDirect(deallocator, "address");
                }

                @Override
                public boolean memoryHasBeenReleased() {
                    return this.getAddress() == 0L;
                }
            };
        }
        return null;
    }

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put("buffer-handler.default-buffer-size", "1024");
            defaultValues.put("buffer-handler.default-allocation-mode", "ByteBuffer::allocateDirect");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            static final String BUFFER_SIZE = "buffer-handler.default-buffer-size";
            static final String BUFFER_ALLOCATION_MODE = "buffer-handler.default-allocation-mode";
        }
    }

    public static interface Cleaner {
        public boolean clean();

        public boolean cleaningHasBeenPerformed();
    }

    public static interface Deallocator {
        public boolean freeMemory();

        public boolean memoryHasBeenReleased();
    }
}

