/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.common;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.cache2k.config.CacheType;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.common.AbstractCacheStatistics;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.CacheStatistics;
import org.cache2k.operation.TimeReference;

public class BaseCacheControl
implements CacheControl {
    InternalCache<?, ?> internalCache;
    String qualifiedCacheName;

    public BaseCacheControl(InternalCache<?, ?> cache) {
        this.internalCache = cache;
        this.qualifiedCacheName = cache.getQualifiedName();
    }

    public CacheType<?> getKeyType() {
        return this.getCache().getKeyType();
    }

    public CacheType<?> getValueType() {
        return this.getCache().getValueType();
    }

    public String getName() {
        return this.getCache().getName();
    }

    public String getManagerName() {
        return this.getCache().getCacheManager().getName();
    }

    private InternalCache<?, ?> getCache() {
        return this.internalCache;
    }

    private InternalCacheInfo getInfo() {
        return this.getCache().getInfo();
    }

    public long getSize() {
        return this.getCache().getTotalEntryCount();
    }

    public long getEntryCapacity() {
        return this.getInfo().getHeapCapacity();
    }

    public long getCapacityLimit() {
        return this.isWeigherPresent() ? this.getMaximumWeight() : this.getEntryCapacity();
    }

    public long getMaximumWeight() {
        return this.getInfo().getMaximumWeight();
    }

    public long getTotalWeight() {
        return this.getInfo().getTotalWeight();
    }

    public Instant getCreatedTime() {
        return this.getInfo().getStartedTime();
    }

    public Instant getClearedTime() {
        return this.getInfo().getClearedTime();
    }

    public String getImplementation() {
        return this.getInfo().getImplementation();
    }

    public CompletableFuture<Void> clear() {
        this.getCache().clear();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> removeAll() {
        this.getCache().removeAll();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> changeCapacity(long entryCountOrWeight) {
        if (entryCountOrWeight == 0L) {
            this.getCache().setDisabled(true);
            this.getCache().getEviction().changeCapacity(1L);
            this.getCache().removeAll();
        } else {
            this.getCache().getEviction().changeCapacity(entryCountOrWeight);
            this.getCache().setDisabled(false);
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isLoaderPresent() {
        return this.getCache().isLoaderPresent();
    }

    public boolean isWeigherPresent() {
        return this.getCache().isWeigherPresent();
    }

    public boolean isStatisticsEnabled() {
        return !(this.getCache().getCommonMetrics() instanceof CommonMetrics.BlackHole);
    }

    public CacheStatistics sampleStatistics() {
        if (!this.isStatisticsEnabled()) {
            return null;
        }
        final InternalCacheInfo info = this.getInfo();
        return new AbstractCacheStatistics(){

            @Override
            protected InternalCacheInfo info() {
                return info;
            }
        };
    }

    public CompletableFuture<Void> close() {
        this.getCache().close();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> destroy() {
        this.getCache().close();
        return CompletableFuture.completedFuture(null);
    }

    public long getExpiryAfterWriteTicks() {
        return this.getCache().getTiming().getExpiryAfterWriteTicks();
    }

    public TimeReference getTimeReference() {
        return this.getCache().getTimeReference();
    }
}

