/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.rest.GroupRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.identity.GroupDto;
import org.camunda.bpm.engine.rest.dto.identity.GroupQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.camunda.bpm.engine.rest.sub.identity.GroupResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.GroupResourceImpl;
import org.camunda.bpm.engine.rest.util.PathUtil;

public class GroupRestServiceImpl
extends AbstractAuthorizedRestResource
implements GroupRestService {
    public GroupRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.GROUP, "*", objectMapper);
    }

    @Override
    public GroupResource getGroup(String id) {
        id = PathUtil.decodePathParam(id);
        return new GroupResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<GroupDto> queryGroups(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        GroupQueryDto queryDto = new GroupQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryGroups(queryDto, firstResult, maxResults);
    }

    @Override
    public List<GroupDto> queryGroups(GroupQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.getObjectMapper());
        GroupQuery query = (GroupQuery)queryDto.toQuery(this.getProcessEngine());
        List<Group> resultList = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return GroupDto.fromGroupList(resultList);
    }

    @Override
    public CountResultDto getGroupCount(UriInfo uriInfo) {
        GroupQueryDto queryDto = new GroupQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryGroupCount(queryDto);
    }

    @Override
    public CountResultDto queryGroupCount(GroupQueryDto queryDto) {
        GroupQuery query = (GroupQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public void createGroup(GroupDto groupDto) {
        IdentityService identityService = this.getIdentityService();
        if (identityService.isReadOnly()) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Identity service implementation is read-only.");
        }
        Group newGroup = identityService.newGroup(groupDto.getId());
        groupDto.update(newGroup);
        identityService.saveGroup(newGroup);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        IdentityService identityService = this.getIdentityService();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/group");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (!identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    protected List<Group> executePaginatedQuery(GroupQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

