/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.PasswordPolicyResult;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.dto.identity.BasicUserCredentialsDto;
import org.camunda.bpm.engine.rest.dto.identity.CheckPasswordPolicyResultDto;
import org.camunda.bpm.engine.rest.dto.identity.PasswordPolicyDto;
import org.camunda.bpm.engine.rest.dto.identity.PasswordPolicyRequestDto;
import org.camunda.bpm.engine.rest.dto.identity.UserProfileDto;
import org.camunda.bpm.engine.rest.dto.task.GroupDto;
import org.camunda.bpm.engine.rest.dto.task.GroupInfoDto;
import org.camunda.bpm.engine.rest.dto.task.UserDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.security.auth.AuthenticationResult;

public class IdentityRestServiceImpl
extends AbstractRestProcessEngineAware
implements IdentityRestService {
    public IdentityRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public GroupInfoDto getGroupInfo(String userId) {
        if (userId == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No user id was supplied");
        }
        IdentityService identityService = this.getProcessEngine().getIdentityService();
        GroupQuery query = identityService.createGroupQuery();
        List userGroups = ((GroupQuery)query.groupMember(userId).orderByGroupName().asc()).unlimitedList();
        HashSet<UserDto> allGroupUsers = new HashSet<UserDto>();
        ArrayList<GroupDto> allGroups = new ArrayList<GroupDto>();
        for (Group group : userGroups) {
            List groupUsers = identityService.createUserQuery().memberOfGroup(group.getId()).unlimitedList();
            for (User user : groupUsers) {
                if (user.getId().equals(userId)) continue;
                allGroupUsers.add(new UserDto(user.getId(), user.getFirstName(), user.getLastName()));
            }
            allGroups.add(new GroupDto(group.getId(), group.getName()));
        }
        return new GroupInfoDto(allGroups, allGroupUsers);
    }

    @Override
    public AuthenticationResult verifyUser(BasicUserCredentialsDto credentialsDto) {
        if (credentialsDto.getUsername() == null || credentialsDto.getPassword() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Username and password are required");
        }
        IdentityService identityService = this.getProcessEngine().getIdentityService();
        boolean valid = identityService.checkPassword(credentialsDto.getUsername(), credentialsDto.getPassword());
        if (valid) {
            return AuthenticationResult.successful(credentialsDto.getUsername());
        }
        return AuthenticationResult.unsuccessful(credentialsDto.getUsername());
    }

    @Override
    public Response getPasswordPolicy() {
        boolean isEnabled = this.processEngine.getProcessEngineConfiguration().isEnablePasswordPolicy();
        if (isEnabled) {
            IdentityService identityService = this.processEngine.getIdentityService();
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)PasswordPolicyDto.fromPasswordPolicy(identityService.getPasswordPolicy())).build();
        }
        return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).build();
    }

    @Override
    public Response checkPassword(PasswordPolicyRequestDto dto) {
        boolean isEnabled = this.processEngine.getProcessEngineConfiguration().isEnablePasswordPolicy();
        if (isEnabled) {
            IdentityService identityService = this.processEngine.getIdentityService();
            User user = null;
            UserProfileDto profileDto = dto.getProfile();
            if (profileDto != null) {
                String id = this.sanitizeUserId(profileDto.getId());
                user = identityService.newUser(id);
                user.setFirstName(profileDto.getFirstName());
                user.setLastName(profileDto.getLastName());
                user.setEmail(profileDto.getEmail());
            }
            String candidatePassword = dto.getPassword();
            PasswordPolicyResult result = identityService.checkPasswordAgainstPolicy(candidatePassword, user);
            return Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)CheckPasswordPolicyResultDto.fromPasswordPolicyResult(result)).build();
        }
        return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).build();
    }

    protected String sanitizeUserId(String userId) {
        return userId != null ? userId : "";
    }
}

