/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;

public class URLEncodingUtil {
    public static String encode(String value) {
        if (value != null) {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException ex) {
                return value;
            }
        }
        return null;
    }

    public static String buildAttachmentValue(String attachmentFileName) {
        return MessageFormat.format("attachment; filename=\"{0}\"; filename*=UTF-8''''{1}", attachmentFileName, URLEncodingUtil.encode(attachmentFileName));
    }
}

