/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.batch.BatchStatisticsQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.JobDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.SchemaLogQueryImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.SetJobsRetriesByProcessBatchCmd;
import org.camunda.bpm.engine.impl.TablePageQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.batch.DeleteBatchCmd;
import org.camunda.bpm.engine.impl.cmd.ActivateBatchCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteJobCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteLicenseKeyCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteMetricsCmd;
import org.camunda.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.camunda.bpm.engine.impl.cmd.GetHistoryLevelCmd;
import org.camunda.bpm.engine.impl.cmd.GetJobExceptionStacktraceCmd;
import org.camunda.bpm.engine.impl.cmd.GetLicenseKeyCmd;
import org.camunda.bpm.engine.impl.cmd.GetProcessApplicationForDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.GetPropertiesCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableCountCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableMetaDataCmd;
import org.camunda.bpm.engine.impl.cmd.GetTableNameCmd;
import org.camunda.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import org.camunda.bpm.engine.impl.cmd.PurgeDatabaseAndCacheCmd;
import org.camunda.bpm.engine.impl.cmd.RecalculateJobDuedateCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.RegisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.cmd.ReportDbMetricsCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobDefinitionPriorityCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobDuedateCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobPriorityCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobsRetriesBatchCmd;
import org.camunda.bpm.engine.impl.cmd.SetJobsRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.SetLicenseKeyCmd;
import org.camunda.bpm.engine.impl.cmd.SetPropertyCmd;
import org.camunda.bpm.engine.impl.cmd.SuspendBatchCmd;
import org.camunda.bpm.engine.impl.cmd.TelemetryConfigureCmd;
import org.camunda.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.UnregisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.ExecuteJobHelper;
import org.camunda.bpm.engine.impl.management.PurgeReport;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.metrics.MetricsQueryImpl;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.management.SchemaLogQuery;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePageQuery;
import org.camunda.bpm.engine.management.UpdateJobDefinitionSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.management.UpdateJobSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    @Override
    public ProcessApplicationRegistration registerProcessApplication(String deploymentId, ProcessApplicationReference reference) {
        return this.commandExecutor.execute(new RegisterProcessApplicationCmd(deploymentId, reference));
    }

    @Override
    public void unregisterProcessApplication(String deploymentId, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentId, removeProcessesFromCache));
    }

    @Override
    public void unregisterProcessApplication(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.commandExecutor.execute(new UnregisterProcessApplicationCmd(deploymentIds, removeProcessesFromCache));
    }

    @Override
    public String getProcessApplicationForDeployment(String deploymentId) {
        return this.commandExecutor.execute(new GetProcessApplicationForDeploymentCmd(deploymentId));
    }

    @Override
    public Map<String, Long> getTableCount() {
        return this.commandExecutor.execute(new GetTableCountCmd());
    }

    @Override
    public String getTableName(Class<?> activitiEntityClass) {
        return this.commandExecutor.execute(new GetTableNameCmd(activitiEntityClass));
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.commandExecutor.execute(new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        ExecuteJobHelper.executeJob(jobId, this.commandExecutor);
    }

    @Override
    public void deleteJob(String jobId) {
        this.commandExecutor.execute(new DeleteJobCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute(new SetJobRetriesCmd(jobId, null, retries));
    }

    @Override
    public void setJobRetries(List<String> jobIds, int retries) {
        this.commandExecutor.execute(new SetJobsRetriesCmd(jobIds, retries));
    }

    @Override
    public Batch setJobRetriesAsync(List<String> jobIds, int retries) {
        return this.setJobRetriesAsync(jobIds, (JobQuery)null, retries);
    }

    @Override
    public Batch setJobRetriesAsync(JobQuery jobQuery, int retries) {
        return this.setJobRetriesAsync(null, jobQuery, retries);
    }

    @Override
    public Batch setJobRetriesAsync(List<String> jobIds, JobQuery jobQuery, int retries) {
        return this.commandExecutor.execute(new SetJobsRetriesBatchCmd(jobIds, jobQuery, retries));
    }

    @Override
    public Batch setJobRetriesAsync(List<String> processInstanceIds, ProcessInstanceQuery query, int retries) {
        return this.commandExecutor.execute(new SetJobsRetriesByProcessBatchCmd(processInstanceIds, query, null, retries));
    }

    @Override
    public Batch setJobRetriesAsync(List<String> processInstanceIds, ProcessInstanceQuery query, HistoricProcessInstanceQuery historicProcessInstanceQuery, int retries) {
        return this.commandExecutor.execute(new SetJobsRetriesByProcessBatchCmd(processInstanceIds, query, historicProcessInstanceQuery, retries));
    }

    @Override
    public void setJobRetriesByJobDefinitionId(String jobDefinitionId, int retries) {
        this.commandExecutor.execute(new SetJobRetriesCmd(null, jobDefinitionId, retries));
    }

    @Override
    public void setJobDuedate(String jobId, Date newDuedate) {
        this.setJobDuedate(jobId, newDuedate, false);
    }

    @Override
    public void setJobDuedate(String jobId, Date newDuedate, boolean cascade) {
        this.commandExecutor.execute(new SetJobDuedateCmd(jobId, newDuedate, cascade));
    }

    @Override
    public void recalculateJobDuedate(String jobId, boolean creationDateBased) {
        this.commandExecutor.execute(new RecalculateJobDuedateCmd(jobId, creationDateBased));
    }

    @Override
    public void setJobPriority(String jobId, long priority) {
        this.commandExecutor.execute(new SetJobPriorityCmd(jobId, priority));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public JobDefinitionQuery createJobDefinitionQuery() {
        return new JobDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return this.commandExecutor.execute(new GetJobExceptionStacktraceCmd(jobId));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.commandExecutor.execute(new GetPropertiesCmd());
    }

    @Override
    public void setProperty(String name, String value) {
        this.commandExecutor.execute(new SetPropertyCmd(name, value));
    }

    @Override
    public void deleteProperty(String name) {
        this.commandExecutor.execute(new DeletePropertyCmd(name));
    }

    @Override
    public void setLicenseKey(String licenseKey) {
        this.commandExecutor.execute(new SetLicenseKeyCmd(licenseKey));
    }

    @Override
    public String getLicenseKey() {
        return this.commandExecutor.execute(new GetLicenseKeyCmd());
    }

    @Override
    public void deleteLicenseKey() {
        this.commandExecutor.execute(new DeleteLicenseKeyCmd(true));
    }

    @Override
    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        return this.commandExecutor.execute(new Command<String>(){

            @Override
            public String execute(CommandContext commandContext) {
                commandContext.getAuthorizationManager().checkCamundaAdmin();
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
                DbSqlSession dbSqlSession = dbSqlSessionFactory.openSession(connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                dbSqlSession.dbSchemaUpdate();
                return "";
            }
        });
    }

    public PurgeReport purge() {
        return this.commandExecutor.execute(new PurgeDatabaseAndCacheCmd());
    }

    @Override
    public ProcessDefinitionStatisticsQuery createProcessDefinitionStatisticsQuery() {
        return new ProcessDefinitionStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public ActivityStatisticsQuery createActivityStatisticsQuery(String processDefinitionId) {
        return new ActivityStatisticsQueryImpl(processDefinitionId, this.commandExecutor);
    }

    @Override
    public DeploymentStatisticsQuery createDeploymentStatisticsQuery() {
        return new DeploymentStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public Set<String> getRegisteredDeployments() {
        return this.commandExecutor.execute(new Command<Set<String>>(){

            @Override
            public Set<String> execute(CommandContext commandContext) {
                commandContext.getAuthorizationManager().checkCamundaAdmin();
                Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
                return new HashSet<String>(registeredDeployments);
            }
        });
    }

    @Override
    public void registerDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new RegisterDeploymentCmd(deploymentId));
    }

    @Override
    public void unregisterDeploymentForJobExecutor(String deploymentId) {
        this.commandExecutor.execute(new UnregisterDeploymentCmd(deploymentId));
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).activate();
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionById(String jobDefinitionId, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).suspend();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionById(String jobDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byJobDefinitionId(jobDefinitionId).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionId(String processDefinitionId, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(activateJobs).activate();
    }

    @Override
    public void activateJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean activateJobs, Date activationDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(activateJobs).executionDate(activationDate).activate();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(suspendJobs).suspend();
    }

    @Override
    public void suspendJobDefinitionByProcessDefinitionKey(String processDefinitionKey, boolean suspendJobs, Date suspensionDate) {
        this.updateJobDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeJobs(suspendJobs).executionDate(suspensionDate).suspend();
    }

    @Override
    public UpdateJobDefinitionSuspensionStateSelectBuilder updateJobDefinitionSuspensionState() {
        return new UpdateJobDefinitionSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public void activateJobById(String jobId) {
        this.updateJobSuspensionState().byJobId(jobId).activate();
    }

    @Override
    public void activateJobByProcessInstanceId(String processInstanceId) {
        this.updateJobSuspensionState().byProcessInstanceId(processInstanceId).activate();
    }

    @Override
    public void activateJobByJobDefinitionId(String jobDefinitionId) {
        this.updateJobSuspensionState().byJobDefinitionId(jobDefinitionId).activate();
    }

    @Override
    public void activateJobByProcessDefinitionId(String processDefinitionId) {
        this.updateJobSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateJobByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void suspendJobById(String jobId) {
        this.updateJobSuspensionState().byJobId(jobId).suspend();
    }

    @Override
    public void suspendJobByJobDefinitionId(String jobDefinitionId) {
        this.updateJobSuspensionState().byJobDefinitionId(jobDefinitionId).suspend();
    }

    @Override
    public void suspendJobByProcessInstanceId(String processInstanceId) {
        this.updateJobSuspensionState().byProcessInstanceId(processInstanceId).suspend();
    }

    @Override
    public void suspendJobByProcessDefinitionId(String processDefinitionId) {
        this.updateJobSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendJobByProcessDefinitionKey(String processDefinitionKey) {
        this.updateJobSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public UpdateJobSuspensionStateSelectBuilder updateJobSuspensionState() {
        return new UpdateJobSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public int getHistoryLevel() {
        return this.commandExecutor.execute(new GetHistoryLevelCmd());
    }

    @Override
    public MetricsQuery createMetricsQuery() {
        return new MetricsQueryImpl(this.commandExecutor);
    }

    @Override
    public void deleteMetrics(Date timestamp) {
        this.commandExecutor.execute(new DeleteMetricsCmd(timestamp, null));
    }

    @Override
    public void deleteMetrics(Date timestamp, String reporter) {
        this.commandExecutor.execute(new DeleteMetricsCmd(timestamp, reporter));
    }

    @Override
    public void reportDbMetricsNow() {
        this.commandExecutor.execute(new ReportDbMetricsCmd());
    }

    @Override
    public void setOverridingJobPriorityForJobDefinition(String jobDefinitionId, long priority) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, priority, false));
    }

    @Override
    public void setOverridingJobPriorityForJobDefinition(String jobDefinitionId, long priority, boolean cascade) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, priority, true));
    }

    @Override
    public void clearOverridingJobPriorityForJobDefinition(String jobDefinitionId) {
        this.commandExecutor.execute(new SetJobDefinitionPriorityCmd(jobDefinitionId, null, false));
    }

    @Override
    public BatchQuery createBatchQuery() {
        return new BatchQueryImpl(this.commandExecutor);
    }

    @Override
    public void deleteBatch(String batchId, boolean cascade) {
        this.commandExecutor.execute(new DeleteBatchCmd(batchId, cascade));
    }

    @Override
    public void suspendBatchById(String batchId) {
        this.commandExecutor.execute(new SuspendBatchCmd(batchId));
    }

    @Override
    public void activateBatchById(String batchId) {
        this.commandExecutor.execute(new ActivateBatchCmd(batchId));
    }

    @Override
    public BatchStatisticsQuery createBatchStatisticsQuery() {
        return new BatchStatisticsQueryImpl(this.commandExecutor);
    }

    @Override
    public SchemaLogQuery createSchemaLogQuery() {
        return new SchemaLogQueryImpl(this.commandExecutor);
    }

    @Override
    public void toggleTelemetry(boolean enabled) {
        this.commandExecutor.execute(new TelemetryConfigureCmd(enabled));
    }

    @Override
    public Boolean isTelemetryEnabled() {
        return this.commandExecutor.execute(new IsTelemetryEnabledCmd());
    }
}

