/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cmd.AbstractWritableIdentityServiceCmd;
import org.camunda.bpm.engine.impl.identity.IdentityOperationResult;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SaveUserCmd
extends AbstractWritableIdentityServiceCmd<Void>
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected UserEntity user;
    protected boolean skipPasswordPolicy;

    public SaveUserCmd(User user) {
        this(user, false);
    }

    public SaveUserCmd(User user, boolean skipPasswordPolicy) {
        this.user = (UserEntity)user;
        this.skipPasswordPolicy = skipPasswordPolicy;
    }

    @Override
    protected Void executeCmd(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("user", (Object)this.user);
        EnsureUtil.ensureWhitelistedResourceId(commandContext, "User", this.user.getId());
        if (this.shouldCheckPasswordPolicy(commandContext) && !this.user.checkPasswordAgainstPolicy()) {
            throw new ProcessEngineException("Password does not match policy");
        }
        IdentityOperationResult operationResult = commandContext.getWritableIdentityProvider().saveUser(this.user);
        commandContext.getOperationLogManager().logUserOperation(operationResult, this.user.getId());
        return null;
    }

    protected boolean shouldCheckPasswordPolicy(CommandContext commandContext) {
        return this.user.hasNewPassword() && !this.skipPasswordPolicy && commandContext.getProcessEngineConfiguration().isEnablePasswordPolicy();
    }
}

