/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import camundajar.impl.com.google.gson.JsonObject;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class JsonTaskQueryVariableValueConverter
extends JsonObjectConverter<TaskQueryVariableValue> {
    @Override
    public JsonObject toJsonObject(TaskQueryVariableValue variable) {
        JsonObject jsonObject = JsonUtil.createObject();
        JsonUtil.addField(jsonObject, "name", variable.getName());
        JsonUtil.addFieldRawValue(jsonObject, "value", variable.getValue());
        JsonUtil.addField(jsonObject, "operator", variable.getOperator().name());
        return jsonObject;
    }

    @Override
    public TaskQueryVariableValue toObject(JsonObject json) {
        String name = JsonUtil.getString(json, "name");
        Object value = JsonUtil.getRawObject(json, "value");
        QueryOperator operator = QueryOperator.valueOf(JsonUtil.getString(json, "operator"));
        boolean isTaskVariable = JsonUtil.getBoolean(json, "taskVariable");
        boolean isProcessVariable = JsonUtil.getBoolean(json, "processVariable");
        return new TaskQueryVariableValue(name, value, operator, isTaskVariable, isProcessVariable);
    }
}

