/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractTypedValueSerializer<T extends TypedValue>
implements TypedValueSerializer<T> {
    public static final Set<String> BINARY_VALUE_TYPES = new HashSet<String>();
    protected ValueType valueType;

    public AbstractTypedValueSerializer(ValueType type) {
        this.valueType = type;
    }

    @Override
    public ValueType getType() {
        return this.valueType;
    }

    @Override
    public String getSerializationDataformat() {
        return null;
    }

    @Override
    public boolean canHandle(TypedValue value) {
        if (value.getType() != null && !this.valueType.getClass().isAssignableFrom(value.getType().getClass())) {
            return false;
        }
        return this.canWriteValue(value);
    }

    protected abstract boolean canWriteValue(TypedValue var1);

    @Override
    public boolean isMutableValue(T typedValue) {
        return false;
    }

    static {
        BINARY_VALUE_TYPES.add(ValueType.BYTES.getName());
        BINARY_VALUE_TYPES.add(ValueType.FILE.getName());
    }
}

