/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.DeploymentMapping;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public abstract class AbstractBatchJobHandler<T extends BatchConfiguration>
implements BatchJobHandler<T> {
    @Override
    public abstract JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration();

    @Override
    public boolean createJobs(BatchEntity batch) {
        Object configuration = this.readConfiguration(batch.getConfigurationBytes());
        String deploymentId = null;
        DeploymentMappings idMappings = ((BatchConfiguration)configuration).getIdMappings();
        boolean deploymentAware = idMappings != null && !idMappings.isEmpty();
        List<String> ids = ((BatchConfiguration)configuration).getIds();
        if (deploymentAware) {
            this.sanitizeMappings(idMappings, ids);
            DeploymentMapping mappingToProcess = (DeploymentMapping)idMappings.get(0);
            ids = mappingToProcess.getIds(ids);
            deploymentId = mappingToProcess.getDeploymentId();
        }
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        int numberOfItemsToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, ids.size());
        List<String> processIds = ids.subList(0, numberOfItemsToProcess);
        this.createJobEntities(batch, configuration, deploymentId, processIds, invocationsPerBatchJob);
        if (deploymentAware) {
            if (ids.isEmpty()) {
                idMappings.remove(0);
            } else {
                ((DeploymentMapping)idMappings.get(0)).removeIds(numberOfItemsToProcess);
            }
        }
        batch.setConfigurationBytes(this.writeConfiguration((T)configuration));
        return deploymentAware ? idMappings.isEmpty() : ids.isEmpty();
    }

    protected void sanitizeMappings(DeploymentMappings idMappings, List<String> ids) {
        int elementsToRemove = idMappings.getOverallIdCount() - ids.size();
        if (elementsToRemove > 0) {
            Iterator iterator = idMappings.iterator();
            while (iterator.hasNext()) {
                DeploymentMapping deploymentMapping = (DeploymentMapping)iterator.next();
                if (deploymentMapping.getCount() <= elementsToRemove) {
                    iterator.remove();
                    if ((elementsToRemove -= deploymentMapping.getCount()) != 0) continue;
                    break;
                }
                deploymentMapping.removeIds(elementsToRemove);
                break;
            }
        }
    }

    protected void createJobEntities(BatchEntity batch, T configuration, String deploymentId, List<String> processIds, int invocationsPerBatchJob) {
        if (processIds == null || processIds.isEmpty()) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        int createdJobs = 0;
        while (!processIds.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processIds.size());
            List<String> idsForJob = processIds.subList(0, lastIdIndex);
            T jobConfiguration = this.createJobConfiguration(configuration, idsForJob);
            ((BatchConfiguration)jobConfiguration).setBatchId(batch.getId());
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            job.setDeploymentId(deploymentId);
            this.postProcessJob(configuration, job, jobConfiguration);
            jobManager.insertAndHintJobExecutor(job);
            idsForJob.clear();
            ++createdJobs;
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
    }

    protected abstract T createJobConfiguration(T var1, List<String> var2);

    protected void postProcessJob(T configuration, JobEntity job, T jobConfiguration) {
    }

    protected JobEntity createBatchJob(BatchEntity batch, ByteArrayEntity configuration) {
        BatchJobContext creationContext = new BatchJobContext(batch, configuration);
        return this.getJobDeclaration().createJobInstance(creationContext);
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        List<JobEntity> jobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        for (JobEntity job : jobs) {
            job.delete();
        }
    }

    @Override
    public BatchJobConfiguration newConfiguration(String canonicalString) {
        return new BatchJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchJobConfiguration configuration, JobEntity jobEntity) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        if (byteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(byteArrayId);
        }
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, T jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    @Override
    public byte[] writeConfiguration(T configuration) {
        JsonObject jsonObject = this.getJsonConverterInstance().toJsonObject(configuration);
        return JsonUtil.asBytes(jsonObject);
    }

    @Override
    public T readConfiguration(byte[] serializedConfiguration) {
        return (T)((BatchConfiguration)this.getJsonConverterInstance().toObject(JsonUtil.asObject(serializedConfiguration)));
    }

    protected abstract JsonObjectConverter<T> getJsonConverterInstance();
}

