/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.jboss.vfs.VirtualFile;

public class ContainerIntegrationLogger
extends ProcessEngineLogger {
    public ProcessEngineException couldNotInstantiateJobExecutorClass(Exception e) {
        return new ProcessEngineException(this.exceptionMessage("001", "Could not instantiate job executor class", new Object[0]), e);
    }

    public ProcessEngineException couldNotLoadJobExecutorClass(Exception e) {
        return new ProcessEngineException(this.exceptionMessage("002", "Could not load job executor class", new Object[0]), e);
    }

    public void exceptionWhileStopping(String serviceType, String serviceName, Throwable t) {
        this.logWarn("003", "Exception while stopping {} '{}': {}", new Object[]{serviceType, serviceName, t.getMessage(), t});
    }

    public void debugRootPath(String urlPath) {
        this.logDebug("004", "Rootpath is {}", new Object[]{urlPath});
    }

    public ProcessEngineException cannotDecodePathName(UnsupportedEncodingException e) {
        return new ProcessEngineException(this.exceptionMessage("005", "Could not decode pathname using utf-8 decoder.", new Object[0]), e);
    }

    public ProcessEngineException exceptionWhileScanning(String file, IOException e) {
        return new ProcessEngineException(this.exceptionMessage("006", "IOException while scanning archive '{}'.", new Object[]{file}), e);
    }

    public void debugDiscoveredResource(String resourcePath) {
        this.logDebug("007", "Discovered resource {}", new Object[]{resourcePath});
    }

    public ProcessEngineException cannotOpenFileInputStream(String absolutePath, IOException e) {
        return new ProcessEngineException(this.exceptionMessage("008", "Cannot not open file for reading: {}.", new Object[]{e.getMessage()}), e);
    }

    public ProcessEngineException couldNotGetResource(String strippedPaResourceRootPath, ClassLoader cl, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("009", "Could not load resources at '{}' using classloaded '{}'", new Object[]{strippedPaResourceRootPath, cl}), e);
    }

    public void cannotFindResourcesForPath(String resourceRootPath, ClassLoader classLoader) {
        this.logWarn("010", "Could not find any resources for process archive resource root path '{}' using classloader '{}'.", new Object[]{resourceRootPath, classLoader});
    }

    public ProcessEngineException exceptionWhileGettingVirtualFolder(URL url, URISyntaxException e) {
        return new ProcessEngineException(this.exceptionMessage("011", "Could not load virtual file for url '{}'", new Object[]{url}), e);
    }

    public void cannotScanVfsRoot(VirtualFile processArchiveRoot, IOException e) {
        this.logWarn("012", "Cannot scan process archive root {}", new Object[]{processArchiveRoot, e});
    }

    public void cannotReadInputStreamForFile(String resourceName, VirtualFile processArchiveRoot, IOException e) {
        this.logWarn("013", "Could not read input stream of file '{}' from process archive '{}'.", new Object[]{resourceName, processArchiveRoot, e});
    }

    public ProcessEngineException exceptionWhileLoadingCpRoots(String strippedPaResourceRootPath, ClassLoader classLoader, IOException e) {
        return new ProcessEngineException(this.exceptionMessage("014", "Could not load resources at '{}' using classloaded '{}'", new Object[]{strippedPaResourceRootPath, classLoader}), e);
    }

    public ProcessEngineException unsuppoertedParameterType(Type parameterType) {
        return new ProcessEngineException(this.exceptionMessage("015", "Unsupported parametertype {}", new Object[]{parameterType}));
    }

    public void debugAutoCompleteUrl(String url) {
        this.logDebug("016", "Autocompleting url : [{}]", new Object[]{url});
    }

    public void debugAutoCompletedUrl(String url) {
        this.logDebug("017", "Autocompleted url : [{}]", new Object[]{url});
    }

    public void foundConfigJndi(String jndi, String string) {
        this.logInfo("018", "Found Camunda Platform configuration in JNDI [{}] at {}", new Object[]{jndi, string});
    }

    public void debugExceptionWhileGettingConfigFromJndi(String jndi, NamingException e) {
        this.logDebug("019", "Failed to look up Camunda Platform configuration in JNDI [{}]: {}", new Object[]{jndi, e});
    }

    public void foundConfigAtLocation(String logStatement, String string) {
        this.logInfo("020", "Found Camunda Platform configuration through {}  at {} ", new Object[]{logStatement, string});
    }

    public void notCreatingPaDeployment(String name) {
        this.logInfo("021", "Not creating a deployment for process archive '{}': no resources provided.", new Object[]{name});
    }

    public IllegalArgumentException illegalValueForResumePreviousByProperty(String string) {
        return new IllegalArgumentException(this.exceptionMessage("022", string, new Object[0]));
    }

    public void deploymentSummary(Collection<String> deploymentResourceNames, String deploymentName) {
        StringBuilder builder = new StringBuilder();
        builder.append("Deployment summary for process archive '" + deploymentName + "': \n");
        builder.append("\n");
        for (String resourceName : deploymentResourceNames) {
            builder.append("        " + resourceName);
            builder.append("\n");
        }
        this.logInfo("023", builder.toString(), new Object[0]);
    }

    public void foundProcessesXmlFile(String string) {
        this.logInfo("024", "Found processes.xml file at {}", new Object[]{string});
    }

    public void emptyProcessesXml() {
        this.logInfo("025", "Detected empty processes.xml file, using default values", new Object[0]);
    }

    public void noProcessesXmlForPa(String paName) {
        this.logInfo("026", "No processes.xml file found in process application '{}'", new Object[]{paName});
    }

    public ProcessEngineException exceptionWhileReadingProcessesXml(String deploymentDescriptor, IOException e) {
        return new ProcessEngineException(this.exceptionMessage("027", "Exception while reading {}", new Object[]{deploymentDescriptor}), e);
    }

    public ProcessEngineException exceptionWhileInvokingPaLifecycleCallback(String methodName, String paName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("028", "Exception while invoking {} on Process Application {}: {}", new Object[]{methodName, paName, e.getMessage()}), e);
    }

    public void debugFoundPaLifecycleCallbackMethod(String methodName, String paName) {
        this.logDebug("029", "Found Process Application lifecycle callback method {} in application {}", new Object[]{methodName, paName});
    }

    public void debugPaLifecycleMethodNotFound(String methodName, String paName) {
        this.logDebug("030", "Process Application lifecycle callback method {} not found in application {}", new Object[]{methodName, paName});
    }

    public ProcessEngineException cannotLoadConfigurationClass(String className, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("031", "Failed to load configuration class '{}': {}", new Object[]{className, e.getMessage()}), e);
    }

    public ProcessEngineException configurationClassHasWrongType(String className, Class<?> expectedType, ClassCastException e) {
        return new ProcessEngineException(this.exceptionMessage("032", "Class '{}' has wrong type. Must extend {}", new Object[]{expectedType.getName()}), e);
    }

    public void timeoutDuringShutdownOfThreadPool(int i, TimeUnit seconds) {
        this.logError("033", "Timeout during shutdown of managed thread pool. The current running tasks could not end within {} {} after shutdown operation.", new Object[]{i, seconds});
    }

    public void interruptedWhileShuttingDownThreadPool(InterruptedException e) {
        this.logError("034", "Interrupted while shutting down thread pool", new Object[]{e});
    }

    public ProcessEngineException cannotRegisterService(ObjectName serviceName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("035", "Cannot register service {} with MBean Server: {}", new Object[]{serviceName, e.getMessage()}), e);
    }

    public ProcessEngineException cannotComposeNameFor(String serviceName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("036", "Cannot compose name for service {}: {}", new Object[]{serviceName, e.getMessage()}), e);
    }

    public ProcessEngineException exceptionWhileUnregisteringService(String canonicalName, Throwable t) {
        return new ProcessEngineException(this.exceptionMessage("037", "Exception while unregistering service {} with the MBeanServer: {}", new Object[]{canonicalName, t}), t);
    }

    public ProcessEngineException unknownExceptionWhileParsingDeploymentDescriptor(Exception e) {
        return new ProcessEngineException(this.exceptionMessage("038", "Unknown exception while parsing deployment camunda descriptor: {}", new Object[]{e.getMessage()}), e);
    }

    public ProcessEngineException cannotSetValueForProperty(String key, String canonicalName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("039", "Cannot set property '{}' on instance of class '{}'", new Object[]{key, canonicalName}), e);
    }

    public ProcessEngineException cannotFindSetterForProperty(String key, String canonicalName) {
        return new ProcessEngineException(this.exceptionMessage("040", "Cannot find setter for property '{}' on class '{}'", new Object[]{key, canonicalName}));
    }

    public void debugPerformOperationStep(String stepName) {
        this.logDebug("041", "Performing deployment operation step '{}'", new Object[]{stepName});
    }

    public void debugSuccessfullyPerformedOperationStep(String stepName) {
        this.logDebug("041", "Successfully performed deployment operation step '{}'", new Object[]{stepName});
    }

    public void exceptionWhileRollingBackOperation(Exception e) {
        this.logError("042", "Exception while rolling back operation", new Object[]{e});
    }

    public ProcessEngineException exceptionWhilePerformingOperationStep(String opName, String stepName, Exception e) {
        return new ProcessEngineException(this.exceptionMessage("043", "Exception while performing '{}' => '{}': {}", new Object[]{opName, stepName, e.getMessage()}), e);
    }

    public void exceptionWhilePerformingOperationStep(String name, Exception e) {
        this.logError("044", "Exception while performing '{}': {}", new Object[]{name, e.getMessage(), e});
    }

    public void debugRejectedExecutionException(RejectedExecutionException e) {
        this.logDebug("045", "RejectedExecutionException while scheduling work", new Object[]{e});
    }

    public void foundTomcatDeploymentDescriptor(String bpmPlatformFileLocation, String fileLocation) {
        this.logInfo("046", "Found Camunda Platform configuration in CATALINA_BASE/CATALINA_HOME conf directory [{}] at '{}'", new Object[]{bpmPlatformFileLocation, fileLocation});
    }

    public ProcessEngineException invalidDeploymentDescriptorLocation(String bpmPlatformFileLocation, MalformedURLException e) {
        throw new ProcessEngineException(this.exceptionMessage("047", "'{} is not a valid Camunda Platform configuration resource location.", new Object[]{bpmPlatformFileLocation}), e);
    }

    public void camundaBpmPlatformSuccessfullyStarted(String serverInfo) {
        this.logInfo("048", "Camunda Platform sucessfully started at '{}'.", new Object[]{serverInfo});
    }

    public void camundaBpmPlatformStopped(String serverInfo) {
        this.logInfo("049", "Camunda Platform stopped at '{}'", new Object[]{serverInfo});
    }

    public void paDeployed(String name) {
        this.logInfo("050", "Process application {} successfully deployed", new Object[]{name});
    }

    public void paUndeployed(String name) {
        this.logInfo("051", "Process application {} undeployed", new Object[]{name});
    }
}

